/*
 * Decompiled with CFR 0.152.
 */
package com.sap.vmc.core.sharing;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@Deprecated
public class SerializedObject
implements Serializable {
    private static final long serialVersionUID = -1211864495446255904L;
    static final int CHUNKSIZE = 1024;
    private static final int INITIAL_CHUNKS = 8;
    private byte[][] byteChunks;
    private Object[][] objectChunks;
    private static Method lookupMethod;

    public SerializedObject(Object obj) throws IOException {
        ChunkedOutputStream chunkedStream = new ChunkedOutputStream();
        FastObjectOutputStream objectStream = new FastObjectOutputStream(chunkedStream);
        objectStream.writeObject(obj);
        objectStream.close();
        chunkedStream.close();
        this.byteChunks = chunkedStream.trimByteChunks();
        this.objectChunks = objectStream.trimObjectChunks();
    }

    public Object deserialize() throws IOException, ClassNotFoundException {
        ChunkedInputStream chunkedStream = new ChunkedInputStream(this.byteChunks);
        try (FastObjectInputStream objectStream = new FastObjectInputStream(chunkedStream, this.objectChunks);){
            Object object = objectStream.readObject();
            return object;
        }
    }

    private static ObjectStreamClass lookupObjectStreamClass(Class<?> cl) {
        if (lookupMethod == null) {
            try {
                lookupMethod = ObjectStreamClass.class.getDeclaredMethod("lookup", Class.class, Boolean.TYPE);
                lookupMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e.toString());
            }
        }
        try {
            return (ObjectStreamClass)lookupMethod.invoke(null, cl, true);
        }
        catch (IllegalArgumentException e) {
            throw new InternalError(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e.toString());
        }
        catch (InvocationTargetException e) {
            throw new InternalError(e.toString());
        }
    }

    private static final class ChunkedInputStream
    extends InputStream {
        private int chunkIdx;
        private int pos;
        private byte[][] chunks;

        private ChunkedInputStream(byte[][] chunks) {
            this.chunks = chunks;
        }

        @Override
        public int available() throws IOException {
            int avail = this.chunks[this.chunkIdx].length - this.pos;
            if (avail > 0) {
                return avail;
            }
            if (this.chunkIdx + 1 < this.chunks.length) {
                ++this.chunkIdx;
                this.pos = 0;
                return this.chunks[this.chunkIdx].length;
            }
            return 0;
        }

        @Override
        public int read() throws IOException {
            int avail = this.chunks[this.chunkIdx].length - this.pos;
            if (avail > 0) {
                return this.chunks[this.chunkIdx][this.pos++];
            }
            if (this.chunkIdx + 1 < this.chunks.length) {
                ++this.chunkIdx;
                this.pos = 0;
                return this.chunks[this.chunkIdx][this.pos++];
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            int avail = Math.min(len, this.chunks[this.chunkIdx].length - this.pos);
            if (avail > 0) {
                System.arraycopy(this.chunks[this.chunkIdx], this.pos, b, off, avail);
                this.pos += avail;
                return avail;
            }
            if (this.chunkIdx + 1 < this.chunks.length) {
                ++this.chunkIdx;
                avail = Math.min(len, this.chunks[this.chunkIdx].length);
                System.arraycopy(this.chunks[this.chunkIdx], 0, b, off, avail);
                this.pos = avail;
                return avail;
            }
            return -1;
        }

        @Override
        public long skip(long n) throws IOException {
            if (n == 0L) {
                return 0L;
            }
            int avail = Math.min((int)n, this.chunks[this.chunkIdx].length - this.pos);
            if (avail > 0) {
                this.pos += avail;
                return avail;
            }
            if (this.chunkIdx + 1 < this.chunks.length) {
                ++this.chunkIdx;
                this.pos = avail = Math.min((int)n, this.chunks[this.chunkIdx].length);
                return avail;
            }
            return 0L;
        }
    }

    private static final class ChunkedOutputStream
    extends OutputStream {
        private int chunkIdx;
        private int pos;
        private byte[][] chunks = new byte[8][];

        private ChunkedOutputStream() {
            this.chunks[0] = new byte[1024];
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int fits = 1024 - this.pos;
            if (len <= fits) {
                System.arraycopy(b, off, this.chunks[this.chunkIdx], this.pos, len);
                this.pos += len;
            } else {
                System.arraycopy(b, off, this.chunks[this.chunkIdx], this.pos, fits);
                int remainder = len - fits;
                System.arraycopy(b, off + fits, this.newChunk(remainder), 0, remainder);
                this.pos += Math.min(remainder, 1024);
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.pos < 1024) {
                this.chunks[this.chunkIdx][this.pos] = (byte)b;
                ++this.pos;
            } else {
                this.newChunk((int)1)[0] = (byte)b;
                ++this.pos;
            }
        }

        private byte[] newChunk(int minSize) {
            if (this.chunkIdx >= this.chunks.length - 1) {
                byte[][] newChunks = new byte[2 * this.chunks.length][];
                System.arraycopy(this.chunks, 0, newChunks, 0, this.chunks.length);
                this.chunks = newChunks;
            }
            int size = Math.max(minSize, 1024);
            byte[] newChunk = new byte[size];
            this.chunks[++this.chunkIdx] = newChunk;
            this.pos = 0;
            return newChunk;
        }

        byte[][] trimByteChunks() {
            if (this.pos < 1024) {
                byte[] newChunk = new byte[this.pos];
                System.arraycopy(this.chunks[this.chunkIdx], 0, newChunk, 0, this.pos);
                this.chunks[this.chunkIdx] = newChunk;
            }
            if (this.chunkIdx + 1 < this.chunks.length) {
                byte[][] newChunks = new byte[this.chunkIdx + 1][];
                System.arraycopy(this.chunks, 0, newChunks, 0, this.chunkIdx + 1);
                return newChunks;
            }
            return this.chunks;
        }
    }

    private static final class SharedWrapper
    implements Serializable {
        private static final long serialVersionUID = -6791898418664976143L;
        public int idx;

        private SharedWrapper(int idx) {
            this.idx = idx;
        }
    }

    private static final class FastObjectInputStream
    extends ObjectInputStream {
        private Object[][] chunks;

        private FastObjectInputStream(InputStream in, Object[][] objectChunks) throws IOException {
            super(in);
            this.enableResolveObject(true);
            this.chunks = objectChunks;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return desc.forClass();
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            int idx = this.readInt();
            return (Class)this.chunks[idx / 1024][idx % 1024];
        }

        @Override
        protected Object resolveObject(Object obj) throws IOException {
            if (obj instanceof SharedWrapper) {
                int idx = ((SharedWrapper)obj).idx;
                return this.chunks[idx / 1024][idx % 1024];
            }
            return obj;
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            int idx = this.readInt();
            Class cl = (Class)this.chunks[idx / 1024][idx % 1024];
            return SerializedObject.lookupObjectStreamClass(cl);
        }
    }

    private static final class FastObjectOutputStream
    extends ObjectOutputStream {
        private int chunkIdx;
        private int pos;
        private Object[][] chunks;
        private int numObjects;

        FastObjectOutputStream(OutputStream out) throws IOException {
            super(out);
            this.enableReplaceObject(true);
            this.chunks = new Object[8][];
            this.chunks[0] = new Object[1024];
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            if (obj instanceof ClassLoader) {
                return new SharedWrapper(this.storeObject(obj));
            }
            return obj;
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            Class<?> cl = desc.forClass();
            this.writeInt(this.storeObject(cl));
        }

        @Override
        protected void annotateProxyClass(Class<?> cl) throws IOException {
            this.writeInt(this.storeObject(cl));
        }

        private int storeObject(Object obj) {
            ++this.numObjects;
            if (this.pos < 1024) {
                this.chunks[this.chunkIdx][this.pos] = obj;
                return this.pos++;
            }
            this.newChunk()[this.pos] = obj;
            return this.chunkIdx * 1024 + this.pos++;
        }

        private Object[] newChunk() {
            if (this.chunkIdx >= this.chunks.length - 1) {
                Object[][] newChunks = new Object[2 * this.chunks.length][];
                System.arraycopy(this.chunks, 0, newChunks, 0, this.chunks.length);
                this.chunks = newChunks;
            }
            Object[] newChunk = new Object[1024];
            this.chunks[++this.chunkIdx] = newChunk;
            this.pos = 0;
            return newChunk;
        }

        private Object[][] trimObjectChunks() {
            if (this.pos < 1024) {
                Object[] newChunk = new Object[this.pos];
                System.arraycopy(this.chunks[this.chunkIdx], 0, newChunk, 0, this.pos);
                this.chunks[this.chunkIdx] = newChunk;
            }
            if (this.chunkIdx + 1 < this.chunks.length) {
                Object[][] newChunks = new Object[this.chunkIdx + 1][];
                System.arraycopy(this.chunks, 0, newChunks, 0, this.chunkIdx + 1);
                return newChunks;
            }
            return this.chunks;
        }
    }
}

