/*
 * Decompiled with CFR 0.152.
 */
package com.sap.vmc.core.sharing;

@Deprecated
public class ShareabilityProperties {
    public static final int REASON_OK_DEFINED = 16;
    public static final int REASON_OK_DERIVED = 32;
    public static final int REASON_NOT_SERIALIZABLE = 64;
    public static final int REASON_HAS_READOBJECT = 128;
    public static final int REASON_HAS_WRITEOBJECT = 256;
    public static final int REASON_HAS_READEXTERNAL = 512;
    public static final int REASON_HAS_WRITEEXTERNAL = 1024;
    public static final int REASON_HAS_READRESOLVE = 2048;
    public static final int REASON_HAS_WRITEREPLACE = 4096;
    public static final int REASON_NOT_SERIALIZABLE_AND_NONTRIVIAL_CONSTRUCTOR = 8192;
    public static final int REASON_HAS_TRANSIENT_FIELDS = 16384;
    public static final int REASON_HAS_SERIALPERSISTENTFIELDS_FIELD = 32768;
    public static final int REASON_HAS_NONTRIVIAL_FINALIZER = 65536;
    public static final int REASON_IS_REFERENCE = 131072;
    public static final int REASON_NOT_SHAREABLE_CLASS_LOADER = 262144;
    public static final int REASON_ENUM_HAS_NONFINAL_MEMBERS = 524288;
    public static final int REASON_ENUM_HAS_NONCONSTANT_CONSTRUCTOR_CODE = 0x100000;
    public static final int REASON_ENUM_HAS_NONCONSTANT_CONSTRUCTOR_ARGS = 0x200000;
    public static final int REASON_ENUM_HAS_NONCONSTANT_CLINIT_CODE = 0x400000;
    public static final int REASON_ENUM_NOT_PARSEABLE = 0x800000;
    public static final int REASON_FIRST = 4;
    public static final int REASON_LAST = 24;
    public static final int REASON_OK = 48;
    private static final String[] REASON_MESSAGES = new String[]{"  It is a defined shareable class.", "  It is a derived shareable class.", "  It is not serializable.", "  It has a custom serialization method 'readObject(ObjectInputStream)'.", "  It has a custom serialization method 'writeObject(ObjectOutputStream)'.", "  It has a custom serialization method 'readExternal(ObjectInput)'.", "  It has a custom serialization method 'writeExternal(ObjectOutput)'.", "  It has a custom serialization method 'readResolve()'.", "  It has a custom serialization method 'writeReplace()'.", "  It has a nonserializable base class which has a nontrivial default constructor.", "  It has transient fields.", "  It has an 'ObjectStreamField[] serialPersistentFields' field.", "  It has a nontrivial finalizer.", "  It is derived from 'Reference'.", "  It does not have a shareable class loader.", "  It is an enum class and has non-final member variables.", "  It is an enum class and has a constructor with non-constant input.", "  It is an enum class and has non-constant constructor arguments.", "  It is an enum class and has non-constant class initialization code.", "  It is an enum class and the VM was unable to analyze it (should not happen - please report as bug)."};
    private Class<?> clazz;
    private int reasonCode;

    public ShareabilityProperties(Class<?> clazz, int reasonCode) {
        this.clazz = clazz;
        this.reasonCode = reasonCode;
        if (clazz == Class.class) {
            this.reasonCode = 262144;
        }
    }

    public Class<?> getDescribedClass() {
        return this.clazz;
    }

    public boolean isShareable() {
        return (this.reasonCode & 0x30) != 0;
    }

    public boolean isDefinedShareable() {
        return (this.reasonCode & 0x10) != 0;
    }

    public boolean isDerivedShareable() {
        return (this.reasonCode & 0x20) != 0;
    }

    public boolean isNotSerializable() {
        return (this.reasonCode & 0x40) != 0;
    }

    public boolean hasReadObject() {
        return (this.reasonCode & 0x80) != 0;
    }

    public boolean hasWriteObject() {
        return (this.reasonCode & 0x100) != 0;
    }

    public boolean hasReadExternal() {
        return (this.reasonCode & 0x200) != 0;
    }

    public boolean hasWriteExternal() {
        return (this.reasonCode & 0x400) != 0;
    }

    public boolean hasReadResolve() {
        return (this.reasonCode & 0x800) != 0;
    }

    public boolean hasWriteReplace() {
        return (this.reasonCode & 0x1000) != 0;
    }

    public boolean hasNonSerializableBaseClass() {
        return (this.reasonCode & 0x2000) != 0;
    }

    public boolean hasTransientFields() {
        return (this.reasonCode & 0x4000) != 0;
    }

    public boolean hasSerialPersistentFieldsField() {
        return (this.reasonCode & 0x8000) != 0;
    }

    public boolean hasNonTrivialFinalizer() {
        return (this.reasonCode & 0x10000) != 0;
    }

    public boolean isReference() {
        return (this.reasonCode & 0x20000) != 0;
    }

    public boolean hasNonShareableClassLoader() {
        return (this.reasonCode & 0x40000) != 0;
    }

    public boolean isEnumWithNonFinalMembers() {
        return (this.reasonCode & 0x80000) != 0;
    }

    public boolean isEnumWithNonConstantConstructor() {
        return (this.reasonCode & 0x100000) != 0;
    }

    public boolean isEnumWithNonConstantConstructorArguments() {
        return (this.reasonCode & 0x200000) != 0;
    }

    public boolean isEnumWithNonConstantClassInitializer() {
        return (this.reasonCode & 0x400000) != 0;
    }

    public boolean isUnparseableEnum() {
        return (this.reasonCode & 0x800000) != 0;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("Class '");
        strBuf.append(this.clazz.getName());
        strBuf.append("' is ");
        if ((this.reasonCode & 0x30) == 0) {
            strBuf.append("not ");
        }
        strBuf.append("a shareable class: ");
        for (int i = 4; i <= 24; ++i) {
            if ((this.reasonCode & 1 << i) == 0) continue;
            strBuf.append(System.getProperty("line.separator"));
            strBuf.append(REASON_MESSAGES[i - 4]);
        }
        return strBuf.toString();
    }
}

