/*
 * Decompiled with CFR 0.152.
 */
package com.sap.vmc.util.collection;

import com.sap.vmc.util.collection.NodeList;
import com.sap.vmc.util.collection.NodePath;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@Deprecated
public class Node
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4612641559725299817L;
    protected NodeList children = new NodeList();
    protected String name;
    protected Node parent;
    protected Properties properties;
    protected Object key;

    public Node(String name) {
        this(null, name);
    }

    public Node(Object key, String name) {
        this.name = name;
        this.parent = null;
        this.key = key;
    }

    public Node getChild(int index) {
        return this.children.get(index);
    }

    public Node getChild(String name) {
        return this.children.get(name);
    }

    public NodeList getChildren(String name) {
        return this.children.getElementsWithName(name);
    }

    public NodeList getChildren() {
        return this.children;
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public boolean addNode(NodePath path, Node node) {
        Node nodeToAddTo = this.findNode(path);
        if (nodeToAddTo != null) {
            nodeToAddTo.addChild(node);
            return true;
        }
        return false;
    }

    public boolean addNode(String path, Node node) {
        return this.addNode(NodePath.parse(path), node);
    }

    public boolean addSubNode(NodePath path, Node node) {
        Node nodeToAddTo = this.findSubNode(path);
        if (nodeToAddTo != null) {
            nodeToAddTo.addChild(node);
            return true;
        }
        return false;
    }

    public boolean addSubNode(String path, Node node) {
        return this.addSubNode(NodePath.parse(path), node);
    }

    public void addChild(Node child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void addChildren(NodeList children) {
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            this.addChild(children.get(i));
        }
    }

    public void addChildren(Node[] children) {
        int size = children.length;
        for (int i = 0; i < size; ++i) {
            this.addChild(children[i]);
        }
    }

    public Node getParent() {
        return this.parent;
    }

    protected void setParent(Node parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public Node removeChild(int index) {
        return this.children.remove(index);
    }

    public boolean removeChild(Node node) {
        return this.children.remove(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(String name, String value) {
        Node node = this;
        synchronized (node) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
        }
        this.properties.setProperty(name, value);
    }

    public void addProperties(Properties props) {
        Enumeration e = props.elements();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            this.addProperty(prop, props.getProperty(prop));
        }
    }

    public String getProperty(String name) {
        if (this.properties != null) {
            return this.properties.getProperty(name);
        }
        return null;
    }

    public Node findSubNode(String path) {
        return this.findSubNode(NodePath.parse(path));
    }

    public Node findSubNode(NodePath path) {
        NodeList result = this.findSubNodes(path);
        if (result == null || result.size() < 1) {
            return null;
        }
        return result.get(0);
    }

    private NodeList findSubNodesInternal(NodePath path) {
        NodeList result;
        this.ensurePathIntegrity(path);
        String pathElement = path.get(0);
        NodeList matches = this.children.getElementsWithName(pathElement);
        NodePath processedPath = path;
        if (processedPath.size() > 1) {
            processedPath = processedPath.getSubPath(1);
            result = new NodeList();
            for (int i = 0; i < matches.size(); ++i) {
                Node node = matches.get(i);
                result.add(node.findSubNodesInternal(processedPath));
            }
        } else {
            result = matches;
        }
        return result;
    }

    public NodeList findSubNodes(NodePath path) {
        if (path.isAbsolute()) {
            return this.findNodes(path);
        }
        return this.findSubNodesInternal(path);
    }

    public NodeList findSubNodes(String path) {
        return this.findSubNodes(NodePath.parse(path));
    }

    public NodeList findNodes(String path) {
        return this.findNodes(NodePath.parse(path));
    }

    public NodeList findNodes(NodePath path) {
        this.ensurePathIntegrity(path);
        if (path.isAbsolute() && !this.isRoot()) {
            return this.findRoot().findNodes(path);
        }
        if (path.size() == 1 && path.get(0).equals(this.name)) {
            NodeList result = new NodeList();
            result.add(this);
            return result;
        }
        if (path.size() == 1 && !path.get(0).equals(this.name)) {
            return new NodeList();
        }
        return this.findSubNodes(path.getSubPath(1));
    }

    public Node findNode(NodePath path) {
        NodeList list = this.findNodes(path);
        if (list == null || list.size() < 1) {
            return null;
        }
        return list.get(0);
    }

    public Node findNode(String path) {
        return this.findNode(NodePath.parse(path));
    }

    public Node findNodeByKey(Object key) {
        if (this.key.equals(key)) {
            return this;
        }
        return this.children.findNodeByKey(key);
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public final void checkIntegrity() {
        this.checkIntegrity(new HashMap<Integer, Node>(), this.isRoot());
    }

    private void checkIntegrity(Map<Integer, Node> visitedNodes, boolean rootNode) {
        Integer hashCode = new Integer(System.identityHashCode(this));
        Node other = visitedNodes.get(hashCode);
        if (other != null && this == other) {
            throw new IllegalStateException("Tree seems to be a mesh. Node '" + this.name + "' has two nodes referencing it as there child.");
        }
        visitedNodes.put(hashCode, this);
        if (!rootNode && this.parent == null) {
            throw new IllegalStateException("Parent value for node '" + this.name + "' is not correctly set.");
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Node child = this.children.get(i);
            child.checkIntegrity(visitedNodes, false);
        }
    }

    public NodeList flatten() {
        this.checkIntegrity();
        NodeList result = new NodeList();
        result.add(this);
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            Node child = this.children.get(i);
            NodeList flatChildren = child.flatten();
            result.add(flatChildren);
        }
        return result;
    }

    public NodePath getAbsolutePath() {
        NodeList nodes = this.findAncestors();
        nodes = nodes.getReversedList();
        NodePath path = nodes.toPath();
        path.setAbsolute(true);
        return path;
    }

    public NodePath getPath(Node child) {
        NodeList list = this.findDescendants(child);
        if (list != null) {
            return list.toPath();
        }
        return null;
    }

    public Node findRoot() {
        this.checkIntegrity();
        if (this.parent == null) {
            return this;
        }
        return this.parent.findRoot();
    }

    private void ensurePathIntegrity(NodePath path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (path.size() == 0) {
            throw new IllegalArgumentException("path.size() == 0");
        }
    }

    public boolean deleteSubNode(NodePath path) {
        if (path.isAbsolute()) {
            return this.deleteNode(path);
        }
        Node nodeToDelete = this.findSubNode(path);
        boolean success = false;
        if (nodeToDelete != null) {
            if (nodeToDelete.isRoot()) {
                throw new IllegalArgumentException("cannot delete root nodes");
            }
            Node parentNode = nodeToDelete.parent;
            parentNode.children.remove(nodeToDelete);
            nodeToDelete.parent = null;
            success = true;
        }
        return success;
    }

    public boolean deleteSubNode(String path) {
        return this.deleteSubNode(NodePath.parse(path));
    }

    public boolean deleteNode(NodePath path) {
        this.ensurePathIntegrity(path);
        if (path.isAbsolute() && !this.isRoot()) {
            return this.findRoot().deleteNode(path);
        }
        if (path.size() == 1 && path.get(0).equals(this.name)) {
            if (this.isRoot()) {
                throw new IllegalArgumentException("cannot delete root nodes");
            }
            Node parentNode = this.parent;
            if (parentNode != null) {
                this.parent.children.remove(this);
            }
            this.parent = null;
            return true;
        }
        if (path.size() == 1 && !path.get(0).equals(this.name)) {
            return false;
        }
        return this.deleteSubNode(path.getSubPath(1));
    }

    public boolean deleteNode(String path) {
        return this.deleteNode(NodePath.parse(path));
    }

    public NodeList findDescendants(Node descendant) {
        if (descendant == null) {
            throw new NullPointerException("descendant == null");
        }
        this.checkIntegrity();
        NodeList result = descendant.findAncestors(this);
        if (result == null) {
            return null;
        }
        return result.getReversedList();
    }

    public NodeList findAncestors(Node ancestor) {
        if (ancestor == null) {
            throw new NullPointerException("ancestor == null");
        }
        this.checkIntegrity();
        NodeList list = new NodeList();
        return this.findAncestors(ancestor, list);
    }

    public NodeList findAncestors() {
        this.checkIntegrity();
        NodeList list = new NodeList();
        return this.findAncestors(null, list);
    }

    private NodeList findAncestors(Node ancestor, NodeList list) {
        if (this.parent == null && ancestor != this && ancestor != null) {
            return null;
        }
        if (this.parent == null && ancestor == null) {
            list.add(this);
            return list;
        }
        list.add(this);
        if (ancestor == this) {
            return list;
        }
        return this.parent.findAncestors(ancestor, list);
    }

    public NodePath[] getPathListing() {
        this.checkIntegrity();
        NodePath currentPath = new NodePath();
        if (this.isRoot()) {
            currentPath.setAbsolute(true);
        }
        List<NodePath> result = this.getPathListing(currentPath, null);
        return result.toArray(new NodePath[result.size()]);
    }

    private List<NodePath> getPathListing(NodePath currentPath, List<NodePath> list) {
        ArrayList<NodePath> listNotNull = list == null ? new ArrayList<NodePath>() : list;
        NodePath currentPathClone = (NodePath)currentPath.clone();
        currentPathClone.add(this.name);
        listNotNull.add(currentPathClone);
        for (int i = 0; i < this.children.size(); ++i) {
            Node child = this.children.get(i);
            child.getPathListing(currentPathClone, listNotNull);
        }
        return listNotNull;
    }

    public void subtract(Node startNode) {
        if (startNode == null) {
            throw new NullPointerException("startNode");
        }
        if (this.name == null && startNode.name != null || this.name != null && !this.name.equals(startNode.name)) {
            throw new IllegalArgumentException("Other node has different name, expecting '" + this.name + "' but has '" + startNode.name + "'.");
        }
        this.checkIntegrity();
        startNode.checkIntegrity();
        while (this.subtractInternal(startNode)) {
        }
    }

    private boolean subtractInternal(Node startNode) {
        int i;
        ArrayList<Node[]> concurrentNodes = new ArrayList<Node[]>();
        ArrayList<Node> newNodes = new ArrayList<Node>();
        ArrayList<Node> deletedNodes = new ArrayList<Node>();
        boolean changed = false;
        this.compareSubNodes(startNode, concurrentNodes, newNodes, deletedNodes);
        for (i = 0; i < concurrentNodes.size(); ++i) {
            Node myNode = ((Node[])concurrentNodes.get(i))[0];
            if (!myNode.isLeaf()) continue;
            this.children.remove(myNode);
            changed = true;
        }
        for (i = 0; i < this.children.size(); ++i) {
            Node myChild = this.children.get(i);
            Node otherNode = startNode.children.get(myChild.name);
            if (otherNode == null) continue;
            changed |= myChild.subtractInternal(otherNode);
        }
        return changed;
    }

    public void merge(Node startNode) {
        if (startNode == null) {
            throw new NullPointerException("startNode");
        }
        if (this.name == null && startNode.name != null || this.name != null && !this.name.equals(startNode.name)) {
            throw new IllegalArgumentException("Other node has different name, expecting '" + this.name + "' but has '" + startNode.name + "'.");
        }
        this.checkIntegrity();
        startNode.checkIntegrity();
        this.mergeInternal(startNode);
    }

    private void mergeInternal(Node startNode) {
        int i;
        this.mergeNode(startNode);
        ArrayList<Node[]> concurrentNodes = new ArrayList<Node[]>();
        ArrayList<Node> newNodes = new ArrayList<Node>();
        this.compareSubNodes(startNode, concurrentNodes, newNodes, new LinkedList<Node>());
        for (i = concurrentNodes.size() - 1; i >= 0; --i) {
            Node[] nodes = (Node[])concurrentNodes.get(i);
            Node thisNode = nodes[0];
            Node otherNode = nodes[1];
            thisNode.mergeInternal(otherNode);
        }
        for (i = newNodes.size() - 1; i >= 0; --i) {
            Node otherNode = (Node)newNodes.get(i);
            this.addChild(otherNode);
        }
    }

    public void compareTrees(Node startNode, List<Node> added, List<Node> equal, List<Node> removed, List<Node[]> changed) {
        if (startNode == null) {
            throw new NullPointerException("startNode");
        }
        if (added == null) {
            throw new NullPointerException("added");
        }
        if (equal == null) {
            throw new NullPointerException("equal");
        }
        if (removed == null) {
            throw new NullPointerException("removed");
        }
        if (changed == null) {
            throw new NullPointerException("changed");
        }
        if (!this.name.equals(startNode.name)) {
            throw new IllegalArgumentException("Node names do not match, this name is '" + this.name + "', other node's name is '" + startNode.name + "'.");
        }
        this.compareTreesInternal(startNode, added, equal, removed, changed);
    }

    private void compareTreesInternal(Node startNode, List<Node> added, List<Node> equal, List<Node> removed, List<Node[]> changed) {
        Node node;
        int i;
        if (this.equals(startNode)) {
            equal.add(this);
        } else {
            changed.add(new Node[]{this, startNode});
        }
        ArrayList<Node[]> concurrentNodes = new ArrayList<Node[]>();
        ArrayList<Node> newNodes = new ArrayList<Node>();
        ArrayList<Node> deletedNodes = new ArrayList<Node>();
        this.compareSubNodes(startNode, concurrentNodes, newNodes, deletedNodes);
        for (i = newNodes.size() - 1; i >= 0; --i) {
            node = (Node)newNodes.get(i);
            added.addAll(node.flatten().toCollection());
        }
        for (i = deletedNodes.size() - 1; i >= 0; --i) {
            node = (Node)deletedNodes.get(i);
            removed.addAll(node.flatten().toCollection());
        }
        for (i = concurrentNodes.size() - 1; i >= 0; --i) {
            Node[] nodes = (Node[])concurrentNodes.get(i);
            Node thisNode = nodes[0];
            Node otherNode = nodes[1];
            thisNode.compareTrees(otherNode, added, equal, removed, changed);
        }
    }

    private void compareSubNodes(Node startNode, List<Node[]> concurrentNodes, List<Node> newNodes, List<Node> deletedNodes) {
        HashMap<String, Integer> nameToIndex = new HashMap<String, Integer>();
        int size = this.children.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.children.get(i);
            String nodeName = node.name;
            if (nameToIndex.containsKey(nodeName)) continue;
            int j = i;
            int k = -1;
            while (true) {
                if ((k = startNode.children.indexOf(k + 1, nodeName)) < 0) {
                    deletedNodes.add(node);
                    while ((j = this.children.indexOf(j + 1, nodeName)) >= 0) {
                        deletedNodes.add(this.children.get(j));
                    }
                    break;
                }
                Node otherNode = startNode.children.get(k);
                concurrentNodes.add(new Node[]{node, otherNode});
                j = this.children.indexOf(j + 1, nodeName);
                if (j < 0) {
                    k = startNode.children.indexOf(k + 1, nodeName);
                    break;
                }
                node = this.getChild(j);
            }
            nameToIndex.put(nodeName, k < 0 ? null : new Integer(k));
        }
        int otherSize = startNode.children.size();
        for (int i = 0; i < otherSize; ++i) {
            Node otherNode = startNode.children.get(i);
            String nodeName = otherNode.name;
            Integer pos = (Integer)nameToIndex.get(nodeName);
            if (!(pos == null ? !nameToIndex.containsKey(nodeName) : i >= pos)) continue;
            newNodes.add(otherNode);
        }
    }

    protected void mergeNode(Node otherNode) {
        if (otherNode == null) {
            throw new NullPointerException("otherNode");
        }
        if (this.name == null && otherNode.name != null || this.name != null && !this.name.equals(otherNode.name)) {
            throw new IllegalArgumentException("Other node has different name, expecting '" + this.name + "' but has '" + otherNode.name + "'.");
        }
        if (this.properties != null && otherNode.properties != null) {
            this.properties.putAll(otherNode.properties);
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Node) {
            Node other = (Node)o;
            return (this.key != null ? this.key.equals(other.key) : other.key == null) && (this.name != null ? this.name.equals(other.name) : other.name == null) && (this.properties != null ? this.properties.equals(other.properties) : other.properties == null);
        }
        return false;
    }

    public int hashCode() {
        return (this.key != null ? this.key.hashCode() : 0) ^ (this.name != null ? this.name.hashCode() : 100) ^ (this.properties != null ? this.properties.hashCode() : 1000);
    }

    public Object clone() {
        try {
            Node copy = (Node)super.clone();
            if (this.properties != null) {
                copy.properties = (Properties)this.properties.clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public String toString() {
        this.checkIntegrity();
        return this.toString("");
    }

    protected String toString(String indent) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.nodeToString());
        for (int i = 0; i < this.children.size(); ++i) {
            result.append('\n').append(indent).append("!--");
            result.append(this.children.get(i).toString(indent + "   "));
        }
        return result.toString();
    }

    protected String nodeToString() {
        return this.name + " [" + this.key + "] " + this.properties;
    }
}

