/*
 * Decompiled with CFR 0.152.
 */
package com.sap.vmc.util.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

@Deprecated
public class NodePath
implements Serializable,
Cloneable,
Comparable<NodePath> {
    private static final long serialVersionUID = 7816175858966412680L;
    public static final String PATH_SEPARATOR = "/";
    private List<String> elements = new ArrayList<String>();
    private boolean absolute;
    private String pathAsString;

    public NodePath getSubPath(int index) {
        NodePath path = new NodePath();
        int size = this.elements.size();
        for (int i = index; i < size; ++i) {
            path.add(this.get(i));
        }
        return path;
    }

    public NodePath getSubPath(int startIndex, int endIndex) {
        NodePath path = new NodePath();
        int lastIndex = this.elements.size() - 1;
        lastIndex = endIndex > lastIndex ? lastIndex : endIndex;
        for (int i = startIndex; i <= lastIndex; ++i) {
            path.add(this.get(i));
        }
        return path;
    }

    public NodePath add(String name) {
        this.elements.add(name);
        this.pathAsString = null;
        return this;
    }

    public NodePath add(int position, String name) {
        if (position < this.elements.size()) {
            this.elements.add(position, name);
        } else {
            this.elements.add(name);
        }
        this.pathAsString = null;
        return this;
    }

    public NodePath add(int position, NodePath path) {
        int sizeElements = this.elements.size();
        int sizePath = path.size();
        if (position < sizeElements) {
            int i;
            ArrayList<String> result = new ArrayList<String>(this.elements.size() + path.size());
            for (i = 0; i < position; ++i) {
                result.add(this.elements.get(i));
            }
            for (i = 0; i < sizePath; ++i) {
                result.add(path.get(i));
            }
            for (i = position; i < sizeElements; ++i) {
                result.add(this.elements.get(i));
            }
            this.elements = result;
        } else {
            this.add(path);
        }
        this.pathAsString = null;
        return this;
    }

    public String get(int index) {
        return this.elements.get(index);
    }

    public int size() {
        return this.elements.size();
    }

    public static NodePath parse(String pathToParse) {
        NodePath path = new NodePath();
        String pathToParseModified = pathToParse;
        if (pathToParse.startsWith(PATH_SEPARATOR)) {
            path.setAbsolute(true);
            pathToParseModified = pathToParse.substring(1);
        } else {
            path.setAbsolute(false);
        }
        StringTokenizer st = new StringTokenizer(pathToParseModified, PATH_SEPARATOR);
        while (st.hasMoreTokens()) {
            path.add(st.nextToken());
        }
        return path;
    }

    public NodePath add(NodePath path) {
        int size = path.size();
        for (int i = 0; i < size; ++i) {
            this.elements.add(path.get(i));
        }
        this.pathAsString = null;
        return this;
    }

    public void clear() {
        this.pathAsString = null;
        this.elements.clear();
    }

    public String toString() {
        if (this.pathAsString == null) {
            StringBuffer result = new StringBuffer();
            if (this.absolute) {
                result.append('/');
            }
            int size = this.elements.size();
            for (int i = 0; i < size - 1; ++i) {
                result.append(this.get(i));
                result.append(PATH_SEPARATOR);
            }
            if (size > 0) {
                result.append(this.get(size - 1));
            }
            this.pathAsString = result.toString();
        }
        return this.pathAsString;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof NodePath) {
            return this.equals((NodePath)o);
        }
        return false;
    }

    public boolean equals(NodePath path) {
        if (path == null) {
            return false;
        }
        if (path == this) {
            return true;
        }
        if (path.size() == this.size() && path.absolute == this.absolute) {
            int sizeThis = this.size();
            for (int i = 0; i < sizeThis; ++i) {
                if (this.get(i).equals(path.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public NodePath getPrefix(int position) {
        return this.getSubPath(0, position);
    }

    public NodePath getSuffix(int position) {
        return this.getSubPath(position, this.size());
    }

    public Object clone() {
        NodePath copy = new NodePath();
        copy.add(this);
        copy.setAbsolute(this.absolute);
        return copy;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    @Override
    public int compareTo(NodePath other) {
        return this.toString().compareTo(other.toString());
    }
}

