/*
 * Decompiled with CFR 0.152.
 */
package com.sap.vmc.util.diag;

import com.sap.vmc.util.diag.DiagBufVisitor;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.EmptyStackException;
import java.util.Stack;

@Deprecated
public class DiagBufReader {
    private ByteArrayInputStream inBytes;
    private DataInputStream inData;
    private Stack<StackEntry> nodeStack;
    private int indexInNode;
    private int totalSize;

    public DiagBufReader(byte[] byteArray) throws IOException {
        this.inBytes = new ByteArrayInputStream(byteArray);
        this.nodeStack = new Stack();
        this.inData = new DataInputStream(this.inBytes);
        int version = this.inData.readInt();
        DiagBufReader.checkInt("version", version, 1979711490);
        this.totalSize = this.inData.readInt();
        DiagBufReader.checkInt("size", this.totalSize, byteArray.length);
        this.indexInNode = 1;
        this.readNodeStart("MAIN");
    }

    public long readLong() throws IOException {
        DiagBufReader.checkIndex(this.indexInNode--);
        int tag = this.inData.readInt();
        DiagBufReader.checkInt("type", tag, 0x6C000000);
        return this.inData.readLong();
    }

    public double readDouble() throws IOException {
        DiagBufReader.checkIndex(this.indexInNode--);
        int tag = this.inData.readInt();
        DiagBufReader.checkInt("type", tag, 0x64000000);
        return this.inData.readDouble();
    }

    public int readInt() throws IOException {
        DiagBufReader.checkIndex(this.indexInNode--);
        int tag = this.inData.readInt();
        DiagBufReader.checkInt("type", tag, 0x69000000);
        return this.inData.readInt();
    }

    public float readFloat() throws IOException {
        DiagBufReader.checkIndex(this.indexInNode--);
        int tag = this.inData.readInt();
        DiagBufReader.checkInt("type", tag, 0x66000000);
        return this.inData.readFloat();
    }

    public short readShort() throws IOException {
        DiagBufReader.checkIndex(this.indexInNode--);
        int tagAndValue = this.inData.readInt();
        DiagBufReader.checkInt("type", tagAndValue & 0xFF000000, 0x73000000);
        return (short)(tagAndValue & 0xFFFFFF);
    }

    public boolean readBoolean() throws IOException {
        DiagBufReader.checkIndex(this.indexInNode--);
        int tagAndValue = this.inData.readInt();
        DiagBufReader.checkInt("type", tagAndValue & 0xFF000000, 0x62000000);
        return (tagAndValue & 0xFFFFFF) != 0;
    }

    public byte[] readByteArray() throws IOException {
        DiagBufReader.checkIndex(this.indexInNode--);
        int tagAndValue = this.inData.readInt();
        DiagBufReader.checkInt("type", tagAndValue & 0xFF000000, 0x42000000);
        int length = tagAndValue & 0xFFFFFF;
        byte[] byteArray = new byte[length];
        if (this.inData.read(byteArray) != length) {
            throw new IOException("cannot read from buffer");
        }
        this.skipPadding(length);
        return byteArray;
    }

    public String readString() throws IOException {
        int position = this.totalSize - this.inBytes.available();
        DiagBufReader.checkIndex(this.indexInNode--);
        int tag = this.inData.readShort() << 16;
        DiagBufReader.checkInt("type", tag & 0xFF000000, 0x53000000);
        String string = this.inData.readUTF();
        DiagBufReader.checkInt("null", this.inData.readByte(), 0);
        this.skipPadding(this.totalSize - this.inBytes.available() - position);
        return string;
    }

    public int readNodeStart(String type) throws IOException {
        DiagBufReader.checkIndex(this.indexInNode--);
        int tagAndValue = this.inData.readInt();
        DiagBufReader.checkInt("type", tagAndValue & 0xFF000000, 0x4E000000);
        int currentIndexInNode = this.indexInNode;
        this.indexInNode = tagAndValue & 0xFFFFFF;
        String foundType = this.readString();
        DiagBufReader.checkString("node", foundType, type);
        this.nodeStack.push(new StackEntry(type, currentIndexInNode));
        return this.indexInNode;
    }

    public void readNodeEnd(String type) throws IOException {
        StackEntry stackEntry;
        try {
            stackEntry = this.nodeStack.pop();
        }
        catch (EmptyStackException e) {
            throw new IllegalArgumentException("stack is empty");
        }
        if (!type.equals(stackEntry.type)) {
            throw new IllegalArgumentException("unexpected node type '" + type + "', expecting '" + stackEntry.type + "'");
        }
        if (this.indexInNode != 0) {
            throw new IOException("node has '" + this.indexInNode + "' elements left");
        }
        this.indexInNode = stackEntry.indexInNode;
    }

    public void close() throws IOException {
        this.readNodeEnd("MAIN");
        if (this.inBytes.available() != 0) {
            throw new IOException("extra bytes in buffer after MAIN node");
        }
        this.inData.close();
        this.inBytes.close();
    }

    public void acceptVisitor(DiagBufVisitor visitor) {
        try {
            int nodesPushed = 0;
            while (this.indexInNode != 0 || nodesPushed != 0) {
                String type;
                int tag = this.peekTag();
                switch (tag) {
                    case 0x4E000000: {
                        type = this.peekNodeStart();
                        int size = this.readNodeStart(type);
                        visitor.visitNodeStart(type, size);
                        ++nodesPushed;
                        break;
                    }
                    case 0x53000000: {
                        visitor.visitString(this.readString());
                        break;
                    }
                    case 0x6C000000: {
                        visitor.visitLong(this.readLong());
                        break;
                    }
                    case 0x64000000: {
                        visitor.visitDouble(this.readDouble());
                        break;
                    }
                    case 0x69000000: {
                        visitor.visitInt(this.readInt());
                        break;
                    }
                    case 0x66000000: {
                        visitor.visitFloat(this.readFloat());
                        break;
                    }
                    case 0x73000000: {
                        visitor.visitShort(this.readShort());
                        break;
                    }
                    case 0x62000000: {
                        visitor.visitBoolean(this.readBoolean());
                        break;
                    }
                    case 0x42000000: {
                        visitor.visitByteArray(this.readByteArray());
                        break;
                    }
                    default: {
                        throw new IOException("unexpected type '" + DiagBufReader.typeName(tag) + "'");
                    }
                }
                while (this.indexInNode == 0 && nodesPushed != 0) {
                    type = this.peekNodeEnd();
                    this.readNodeEnd(type);
                    visitor.visitNodeEnd(type);
                    --nodesPushed;
                }
            }
        }
        catch (IOException e) {
            visitor.visitIOException(e);
        }
    }

    public static void dumpByteArray(byte[] bytes, String header, String prefix, PrintStream p) {
        char[] lineHexBuf = new char[48];
        char[] lineCharBuf = new char[16];
        if (bytes == null) {
            p.println(prefix + header + "(null)");
            return;
        }
        String outputString = prefix + header + "[" + bytes.length + "]";
        int numLines = bytes.length / 16 + (bytes.length % 16 != 0 ? 1 : 0);
        for (int line = 0; line < numLines; ++line) {
            for (int i = 0; i < lineHexBuf.length; ++i) {
                lineHexBuf[i] = 32;
            }
            for (int j = 0; j < lineCharBuf.length; ++j) {
                lineCharBuf[j] = 32;
            }
            int numCols = line < numLines - 1 ? 16 : (bytes.length % 16 != 0 ? bytes.length % 16 : 16);
            for (int col = 0; col < numCols; ++col) {
                int currentByte = bytes[16 * line + col] & 0xFF;
                String byteString = Integer.toHexString(currentByte);
                if (byteString.length() == 1) {
                    byteString = "0" + byteString;
                }
                lineHexBuf[3 * col] = byteString.charAt(0);
                lineHexBuf[3 * col + 1] = byteString.charAt(1);
                lineCharBuf[1 * col] = currentByte >= 32 && currentByte <= 126 ? (int)currentByte : 46;
            }
            outputString = outputString + "\n" + prefix + "  " + new String(lineHexBuf) + "| " + new String(lineCharBuf);
        }
        p.println(outputString);
    }

    private int peekTag() throws IOException {
        DiagBufReader.checkIndex(this.indexInNode);
        this.inData.mark(4);
        int tag = this.inData.readInt() & 0xFF000000;
        this.inData.reset();
        return tag;
    }

    private String peekNodeStart() throws IOException {
        DiagBufReader.checkIndex(this.indexInNode);
        this.inData.mark(this.inBytes.available());
        int tag = this.inData.readInt() & 0xFF000000;
        DiagBufReader.checkInt("type", tag, 0x4E000000);
        ++this.indexInNode;
        String type = this.readString();
        this.inData.reset();
        return type;
    }

    private String peekNodeEnd() throws IOException {
        try {
            return this.nodeStack.peek().type;
        }
        catch (EmptyStackException e) {
            throw new IOException("stack is empty");
        }
    }

    private static void checkInt(String name, int found, int expected) throws IOException {
        if (found != expected) {
            if (name.equals("type")) {
                throw new IOException(name + " mismatch, found '" + DiagBufReader.typeName(found) + "', expecting '" + DiagBufReader.typeName(expected) + "'");
            }
            throw new IOException(name + " mismatch, found '" + found + "', expecting '" + expected + "'");
        }
    }

    private static void checkString(String name, String found, String expected) throws IOException {
        if (!found.equals(expected)) {
            throw new IOException(name + " mismatch, found '" + found + "', expecting '" + expected + "'");
        }
    }

    private static void checkIndex(int indexInNode) throws IOException {
        if (indexInNode < 1) {
            throw new IOException("end of node reached");
        }
    }

    private void skipPadding(int length) throws IOException {
        int skip = length;
        while ((skip++ & 3) != 0) {
            DiagBufReader.checkInt("padding", this.inData.readByte(), -70);
        }
    }

    private static String typeName(int type) {
        switch (type) {
            case 0x76000000: {
                return "VERSION";
            }
            case 0x4E000000: {
                return "NODE";
            }
            case 0x53000000: {
                return "STRING";
            }
            case 0x6C000000: {
                return "LONG";
            }
            case 0x64000000: {
                return "DOUBLE";
            }
            case 0x69000000: {
                return "INT";
            }
            case 0x66000000: {
                return "FLOAT";
            }
            case 0x73000000: {
                return "SHORT";
            }
            case 0x62000000: {
                return "BOOLEAN";
            }
            case 0x42000000: {
                return "BYTEARRAY";
            }
        }
        return Integer.toString(type) + " (unknown)";
    }

    private static class StackEntry {
        String type;
        int indexInNode;

        public StackEntry(String type, int indexInNode) {
            this.type = type;
            this.indexInNode = indexInNode;
        }
    }
}

