/*
 * Decompiled with CFR 0.152.
 */
package com.sap.vmc.util.diag;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.EmptyStackException;
import java.util.Stack;

@Deprecated
public class DiagBufWriter {
    private static final int DEFAULT_SIZE = 128;
    private PatchableByteArrayOutputStream outBytes;
    private DataOutputStream outData;
    private Stack<StackEntry> nodeStack;
    private int indexInNode = 0;
    private int totalSizePosition;

    public DiagBufWriter() {
        this(128);
    }

    public DiagBufWriter(int size) {
        this.outBytes = new PatchableByteArrayOutputStream(size);
        this.nodeStack = new Stack();
        this.outData = new DataOutputStream(this.outBytes);
        try {
            this.outData.writeInt(1979711490);
            this.totalSizePosition = this.outBytes.getPosition();
            this.outData.writeInt(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writeNodeStart("MAIN");
    }

    public void writeLong(long value) {
        try {
            this.outData.writeInt(0x6C000000);
            this.outData.writeLong(value);
            ++this.indexInNode;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeDouble(double value) {
        try {
            this.outData.writeInt(0x64000000);
            this.outData.writeDouble(value);
            ++this.indexInNode;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeInt(int value) {
        try {
            this.outData.writeInt(0x69000000);
            this.outData.writeInt(value);
            ++this.indexInNode;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeFloat(float value) {
        try {
            this.outData.writeInt(0x66000000);
            this.outData.writeFloat(value);
            ++this.indexInNode;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeShort(short value) {
        try {
            this.outData.writeInt(0x73000000 | value);
            ++this.indexInNode;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeBoolean(boolean value) {
        try {
            this.outData.writeInt(0x62000000 | (value ? 1 : 0));
            ++this.indexInNode;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeByteArray(byte[] value) {
        if ((value.length & 0xFFFFFF) != value.length) {
            throw new IllegalArgumentException("length '" + value.length + "', exceeds max length'" + 0xFFFFFF + "'");
        }
        try {
            this.outData.writeInt(0x42000000 | value.length);
            this.outData.write(value);
            this.insertPadding(value.length);
            ++this.indexInNode;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeString(String value) {
        String valueNotNull = value == null ? "" : value;
        try {
            int position = this.outBytes.getPosition();
            this.outData.writeShort(21248);
            this.outData.writeUTF(valueNotNull);
            this.outData.writeByte(0);
            this.insertPadding(this.outBytes.getPosition() - position);
            ++this.indexInNode;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeNodeStart(String type) {
        try {
            this.nodeStack.push(new StackEntry(type, this.outBytes.getPosition(), this.indexInNode));
            this.outData.writeInt(0x4E000000);
            this.indexInNode = 0;
            this.writeString(type);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeNodeEnd(String type) {
        StackEntry stackEntry;
        try {
            stackEntry = this.nodeStack.pop();
        }
        catch (EmptyStackException e) {
            throw new IllegalArgumentException("stack is empty");
        }
        if (!type.equals(stackEntry.type)) {
            throw new IllegalArgumentException("unexpected node type '" + type + "', expecting '" + stackEntry.type + "'");
        }
        if ((this.indexInNode & 0xFFFFFF) != this.indexInNode) {
            throw new IllegalArgumentException("node length '" + this.indexInNode + "' exceeds max length '" + 0xFFFFFF + "'");
        }
        this.outBytes.patchInt(stackEntry.position, 0x4E000000 | this.indexInNode);
        this.indexInNode = stackEntry.indexInNode;
        ++this.indexInNode;
    }

    public int getLength() {
        return this.outData.size();
    }

    public byte[] close() {
        this.writeNodeEnd("MAIN");
        this.outBytes.patchInt(this.totalSizePosition, this.outBytes.getPosition());
        byte[] buffer = this.outBytes.toByteArray();
        try {
            this.outData.close();
            this.outBytes.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    private void insertPadding(int length) {
        try {
            int skip = length;
            while ((skip++ & 3) != 0) {
                this.outData.writeByte(-70);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class StackEntry {
        String type;
        int position;
        int indexInNode;

        public StackEntry(String type, int position, int indexInNode) {
            this.type = type;
            this.position = position;
            this.indexInNode = indexInNode;
        }
    }

    private static class PatchableByteArrayOutputStream
    extends ByteArrayOutputStream {
        public PatchableByteArrayOutputStream(int size) {
            super(size);
        }

        public void patchInt(int position, int value) {
            int p = position;
            this.buf[p++] = (byte)(value >>> 24 & 0xFF);
            this.buf[p++] = (byte)(value >>> 16 & 0xFF);
            this.buf[p++] = (byte)(value >>> 8 & 0xFF);
            this.buf[p++] = (byte)(value >>> 0 & 0xFF);
        }

        public int getPosition() {
            return this.size();
        }
    }
}

