/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.ConstantPool;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Fixups;
import com.sun.java.util.jar.pack.Package;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Attribute
implements Comparable<Attribute> {
    Layout def;
    byte[] bytes;
    Object fixups;
    private static final Map<List<Attribute>, List<Attribute>> canonLists = new HashMap<List<Attribute>, List<Attribute>>();
    private static final Map<Layout, Attribute> attributes = new HashMap<Layout, Attribute>();
    private static final Map<Layout, Attribute> standardDefs;
    static final byte EK_INT = 1;
    static final byte EK_BCI = 2;
    static final byte EK_BCO = 3;
    static final byte EK_FLAG = 4;
    static final byte EK_REPL = 5;
    static final byte EK_REF = 6;
    static final byte EK_UN = 7;
    static final byte EK_CASE = 8;
    static final byte EK_CALL = 9;
    static final byte EK_CBLE = 10;
    static final byte EF_SIGN = 1;
    static final byte EF_DELTA = 2;
    static final byte EF_NULL = 4;
    static final byte EF_BACK = 8;
    static final int NO_BAND_INDEX = -1;

    public String name() {
        return this.def.name();
    }

    public Layout layout() {
        return this.def;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public int size() {
        return this.bytes.length;
    }

    public ConstantPool.Entry getNameRef() {
        return this.def.getNameRef();
    }

    private Attribute(Attribute old) {
        this.def = old.def;
        this.bytes = old.bytes;
        this.fixups = old.fixups;
    }

    public Attribute(Layout def, byte[] bytes, Object fixups) {
        this.def = def;
        this.bytes = bytes;
        this.fixups = fixups;
        Fixups.setBytes(fixups, bytes);
    }

    public Attribute(Layout def, byte[] bytes) {
        this(def, bytes, null);
    }

    public Attribute addContent(byte[] bytes, Object fixups) {
        assert (this.isCanonical());
        if (bytes.length == 0 && fixups == null) {
            return this;
        }
        Attribute res = new Attribute(this);
        res.bytes = bytes;
        res.fixups = fixups;
        Fixups.setBytes(fixups, bytes);
        return res;
    }

    public Attribute addContent(byte[] bytes) {
        return this.addContent(bytes, null);
    }

    public void finishRefs(ConstantPool.Index ix) {
        if (this.fixups != null) {
            Fixups.finishRefs(this.fixups, this.bytes, ix);
            this.fixups = null;
        }
    }

    public boolean isCanonical() {
        return this == this.def.canon;
    }

    @Override
    public int compareTo(Attribute that) {
        return this.def.compareTo(that.def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Attribute> getCanonList(List<Attribute> al) {
        Map<List<Attribute>, List<Attribute>> map = canonLists;
        synchronized (map) {
            List<Attribute> cl = canonLists.get(al);
            if (cl == null) {
                cl = new ArrayList<Attribute>(al.size());
                cl.addAll(al);
                cl = Collections.unmodifiableList(cl);
                canonLists.put(al, cl);
            }
            return cl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Attribute find(int ctype, String name, String layout) {
        Layout key = Layout.makeKey(ctype, name, layout);
        Map<Layout, Attribute> map = attributes;
        synchronized (map) {
            Attribute a = attributes.get(key);
            if (a == null) {
                a = new Layout(ctype, name, layout).canonicalInstance();
                attributes.put(key, a);
            }
            return a;
        }
    }

    public static Layout keyForLookup(int ctype, String name) {
        return Layout.makeKey(ctype, name);
    }

    public static Attribute lookup(Map<Layout, Attribute> defs, int ctype, String name) {
        if (defs == null) {
            defs = standardDefs;
        }
        return defs.get(Layout.makeKey(ctype, name));
    }

    public static Attribute define(Map<Layout, Attribute> defs, int ctype, String name, String layout) {
        Attribute a = Attribute.find(ctype, name, layout);
        defs.put(Layout.makeKey(ctype, name), a);
        return a;
    }

    public static String contextName(int ctype) {
        switch (ctype) {
            case 0: {
                return "class";
            }
            case 1: {
                return "field";
            }
            case 2: {
                return "method";
            }
            case 3: {
                return "code";
            }
        }
        return null;
    }

    void visitRefs(Holder holder, int mode, final Collection<ConstantPool.Entry> refs) {
        if (mode == 0) {
            refs.add(this.getNameRef());
        }
        if (this.bytes.length == 0) {
            return;
        }
        if (!this.def.hasRefs) {
            return;
        }
        if (this.fixups != null) {
            Fixups.visitRefs(this.fixups, refs);
            return;
        }
        this.def.parse(holder, this.bytes, 0, this.bytes.length, new ValueStream(){

            @Override
            public void putInt(int bandIndex, int value) {
            }

            @Override
            public void putRef(int bandIndex, ConstantPool.Entry ref) {
                refs.add(ref);
            }

            @Override
            public int encodeBCI(int bci) {
                return bci;
            }
        });
    }

    public void parse(Holder holder, byte[] bytes, int pos, int len, ValueStream out) {
        this.def.parse(holder, bytes, pos, len, out);
    }

    public Object unparse(ValueStream in, ByteArrayOutputStream out) {
        return this.def.unparse(in, out);
    }

    public String toString() {
        return this.def + "{" + (this.bytes == null ? -1 : this.size()) + "}" + (this.fixups == null ? "" : this.fixups.toString());
    }

    public static String normalizeLayoutString(String layout) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        int len = layout.length();
        while (i < len) {
            char ch;
            if ((ch = layout.charAt(i++)) <= ' ') continue;
            if (ch == '#') {
                int end1 = layout.indexOf(10, i);
                int end2 = layout.indexOf(13, i);
                if (end1 < 0) {
                    end1 = len;
                }
                if (end2 < 0) {
                    end2 = len;
                }
                i = Math.min(end1, end2);
                continue;
            }
            if (ch == '\\') {
                buf.append((int)layout.charAt(i++));
                continue;
            }
            if (ch == '0' && layout.startsWith("0x", i - 1)) {
                char dig;
                int end;
                int start = i - 1;
                for (end = start + 2; end < len && ((dig = layout.charAt(end)) >= '0' && dig <= '9' || dig >= 'a' && dig <= 'f'); ++end) {
                }
                if (end > start) {
                    String num = layout.substring(start, end);
                    buf.append(Integer.decode(num));
                    i = end;
                    continue;
                }
                buf.append(ch);
                continue;
            }
            buf.append(ch);
        }
        String result = buf.toString();
        return result;
    }

    static Layout.Element[] tokenizeLayout(Layout self, int curCble, String layout) {
        ArrayList<Layout.Element> col = new ArrayList<Layout.Element>(layout.length());
        Attribute.tokenizeLayout(self, curCble, layout, col);
        Layout.Element[] res = new Layout.Element[col.size()];
        col.toArray(res);
        return res;
    }

    /*
     * Unable to fully structure code
     */
    static void tokenizeLayout(Layout self, int curCble, String layout, List<Layout.Element> col) {
        prevBCI = false;
        len = layout.length();
        i = 0;
        block36: while (i < len) {
            start = i;
            e = self.new Layout.Element();
            block0 : switch (layout.charAt(i++)) {
                case 'B': 
                case 'H': 
                case 'I': 
                case 'V': {
                    kind = 1;
                    --i;
                    i = Attribute.tokenizeUInt(e, layout, i);
                    break;
                }
                case 'S': {
                    kind = 1;
                    --i;
                    i = Attribute.tokenizeSInt(e, layout, i);
                    break;
                }
                case 'P': {
                    kind = 2;
                    if (layout.charAt(i++) == 'O') {
                        e.flags = (byte)(e.flags | 2);
                        if (!prevBCI) {
                            i = -i;
                            continue block36;
                        }
                        ++i;
                    }
                    --i;
                    i = Attribute.tokenizeUInt(e, layout, i);
                    break;
                }
                case 'O': {
                    kind = 3;
                    e.flags = (byte)(e.flags | 2);
                    if (!prevBCI) {
                        i = -i;
                        continue block36;
                    }
                    i = Attribute.tokenizeSInt(e, layout, i);
                    break;
                }
                case 'F': {
                    kind = 4;
                    i = Attribute.tokenizeUInt(e, layout, i);
                    break;
                }
                case 'N': {
                    kind = 5;
                    i = Attribute.tokenizeUInt(e, layout, i);
                    if (layout.charAt(i++) != '[') {
                        i = -i;
                        continue block36;
                    }
                    body = i;
                    i = Attribute.skipBody(layout, body);
                    e.body = Attribute.tokenizeLayout(self, curCble, layout.substring(body, i++));
                    break;
                }
                case 'T': {
                    kind = 7;
                    i = Attribute.tokenizeSInt(e, layout, i);
                    cases = new ArrayList<Layout.Element>();
                    block37: while (true) {
                        if (layout.charAt(i++) != '(') {
                            i = -i;
                            break;
                        }
                        beg = i;
                        i = layout.indexOf(41, i);
                        cstr = layout.substring(beg, i++);
                        cstrlen = cstr.length();
                        if (layout.charAt(i++) != '[') {
                            i = -i;
                            break;
                        }
                        if (layout.charAt(i) == ']') {
                            body = i;
                        } else {
                            body = i;
                            i = Attribute.skipBody(layout, body);
                        }
                        cbody = Attribute.tokenizeLayout(self, curCble, layout.substring(body, i++));
                        if (cstrlen == 0) {
                            ce = self.new Layout.Element();
                            ce.body = cbody;
                            ce.kind = (byte)8;
                            ce.removeBand();
                            cases.add(ce);
                            break;
                        }
                        firstCaseNum = true;
                        cp = 0;
                        while (true) {
                            if ((endp = cstr.indexOf(44, cp)) < 0) {
                                endp = cstrlen;
                            }
                            if ((cstr1 = cstr.substring(cp, endp)).isEmpty()) {
                                cstr1 = "empty";
                            }
                            if ((dash = Attribute.findCaseDash(cstr1, 0)) >= 0) {
                                value0 = Attribute.parseIntBefore(cstr1, dash);
                                if (value0 >= (value1 = Attribute.parseIntAfter(cstr1, dash))) {
                                    i = -i;
                                    continue block37;
                                }
                            } else {
                                value0 = value1 = Integer.parseInt(cstr1);
                            }
                            while (true) {
                                ce = self.new Layout.Element();
                                ce.body = cbody;
                                ce.kind = (byte)8;
                                ce.removeBand();
                                if (!firstCaseNum) {
                                    ce.flags = (byte)(ce.flags | 8);
                                }
                                firstCaseNum = false;
                                ce.value = value0;
                                cases.add(ce);
                                if (value0 == value1) break;
                                ++value0;
                            }
                            if (endp != cstrlen) ** break;
                            continue block37;
                            cp = endp + 1;
                        }
                        break;
                    }
                    e.body = new Layout.Element[cases.size()];
                    cases.toArray(e.body);
                    e.kind = (byte)kind;
                    for (j = 0; j < e.body.length - 1; ++j) {
                        ce = e.body[j];
                        if (Attribute.matchCase(e, ce.value) == ce) continue;
                        i = -i;
                        break block0;
                    }
                    break;
                }
                case '(': {
                    kind = 9;
                    e.removeBand();
                    i = layout.indexOf(41, i);
                    cstr = layout.substring(start + 1, i++);
                    offset = Integer.parseInt(cstr);
                    target = curCble + offset;
                    if (!(offset + "").equals(cstr) || self.elems == null || target < 0 || target >= self.elems.length) {
                        i = -i;
                        continue block36;
                    }
                    ce = self.elems[target];
                    if (!Attribute.$assertionsDisabled && ce.kind != 10) {
                        throw new AssertionError();
                    }
                    e.value = target;
                    e.body = new Layout.Element[]{ce};
                    if (offset > 0) break;
                    e.flags = (byte)(e.flags | 8);
                    ce.flags = (byte)(ce.flags | 8);
                    break;
                }
                case 'K': {
                    kind = 6;
                    switch (layout.charAt(i++)) {
                        case 'I': {
                            e.refKind = (byte)3;
                            break block0;
                        }
                        case 'J': {
                            e.refKind = (byte)5;
                            break block0;
                        }
                        case 'F': {
                            e.refKind = (byte)4;
                            break block0;
                        }
                        case 'D': {
                            e.refKind = (byte)6;
                            break block0;
                        }
                        case 'S': {
                            e.refKind = (byte)8;
                            break block0;
                        }
                        case 'Q': {
                            e.refKind = (byte)53;
                            break block0;
                        }
                        case 'M': {
                            e.refKind = (byte)15;
                            break block0;
                        }
                        case 'T': {
                            e.refKind = (byte)16;
                            break block0;
                        }
                        case 'L': {
                            e.refKind = (byte)51;
                            break block0;
                        }
                    }
                    i = -i;
                    continue block36;
                }
                case 'R': {
                    kind = 6;
                    switch (layout.charAt(i++)) {
                        case 'C': {
                            e.refKind = (byte)7;
                            break block0;
                        }
                        case 'S': {
                            e.refKind = (byte)13;
                            break block0;
                        }
                        case 'D': {
                            e.refKind = (byte)12;
                            break block0;
                        }
                        case 'F': {
                            e.refKind = (byte)9;
                            break block0;
                        }
                        case 'M': {
                            e.refKind = (byte)10;
                            break block0;
                        }
                        case 'I': {
                            e.refKind = (byte)11;
                            break block0;
                        }
                        case 'U': {
                            e.refKind = 1;
                            break block0;
                        }
                        case 'Q': {
                            e.refKind = (byte)50;
                            break block0;
                        }
                        case 'Y': {
                            e.refKind = (byte)18;
                            break block0;
                        }
                        case 'B': {
                            e.refKind = (byte)17;
                            break block0;
                        }
                        case 'N': {
                            e.refKind = (byte)52;
                            break block0;
                        }
                    }
                    i = -i;
                    continue block36;
                }
                default: {
                    i = -i;
                    continue block36;
                }
            }
            if (kind == 6) {
                if (layout.charAt(i++) == 'N') {
                    e.flags = (byte)(e.flags | 4);
                    ++i;
                }
                --i;
                i = Attribute.tokenizeUInt(e, layout, i);
                self.hasRefs = true;
            }
            prevBCI = kind == 2;
            e.kind = (byte)kind;
            e.layout = layout.substring(start, i);
            col.add(e);
        }
    }

    static String[] splitBodies(String layout) {
        ArrayList<String> bodies = new ArrayList<String>();
        for (int i = 0; i < layout.length(); ++i) {
            if (layout.charAt(i++) != '[') {
                layout.charAt(-i);
            }
            int body = i;
            i = Attribute.skipBody(layout, body);
            bodies.add(layout.substring(body, i));
        }
        String[] res = new String[bodies.size()];
        bodies.toArray(res);
        return res;
    }

    private static int skipBody(String layout, int i) {
        assert (layout.charAt(i - 1) == '[');
        if (layout.charAt(i) == ']') {
            return -i;
        }
        int depth = 1;
        while (depth > 0) {
            switch (layout.charAt(i++)) {
                case '[': {
                    ++depth;
                    break;
                }
                case ']': {
                    --depth;
                }
            }
        }
        assert (layout.charAt(--i) == ']');
        return i;
    }

    private static int tokenizeUInt(Layout.Element e, String layout, int i) {
        switch (layout.charAt(i++)) {
            case 'V': {
                e.len = 0;
                break;
            }
            case 'B': {
                e.len = 1;
                break;
            }
            case 'H': {
                e.len = (byte)2;
                break;
            }
            case 'I': {
                e.len = (byte)4;
                break;
            }
            default: {
                return -i;
            }
        }
        return i;
    }

    private static int tokenizeSInt(Layout.Element e, String layout, int i) {
        if (layout.charAt(i) == 'S') {
            e.flags = (byte)(e.flags | 1);
            ++i;
        }
        return Attribute.tokenizeUInt(e, layout, i);
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    static int findCaseDash(String layout, int fromIndex) {
        if (fromIndex <= 0) {
            fromIndex = 1;
        }
        int lastDash = layout.length() - 2;
        int dash;
        while ((dash = layout.indexOf(45, fromIndex)) >= 0 && dash <= lastDash) {
            if (Attribute.isDigit(layout.charAt(dash - 1))) {
                char afterDash = layout.charAt(dash + 1);
                if (afterDash == '-' && dash + 2 < layout.length()) {
                    afterDash = layout.charAt(dash + 2);
                }
                if (Attribute.isDigit(afterDash)) {
                    return dash;
                }
            }
            fromIndex = dash + 1;
        }
        return -1;
    }

    static int parseIntBefore(String layout, int dash) {
        int end;
        int beg;
        for (beg = end = dash; beg > 0 && Attribute.isDigit(layout.charAt(beg - 1)); --beg) {
        }
        if (beg == end) {
            return Integer.parseInt("empty");
        }
        if (beg >= 1 && layout.charAt(beg - 1) == '-') {
            --beg;
        }
        assert (beg == 0 || !Attribute.isDigit(layout.charAt(beg - 1)));
        return Integer.parseInt(layout.substring(beg, end));
    }

    static int parseIntAfter(String layout, int dash) {
        int beg = dash + 1;
        int end = beg;
        int limit = layout.length();
        if (end < limit && layout.charAt(end) == '-') {
            ++end;
        }
        while (end < limit && Attribute.isDigit(layout.charAt(end))) {
            ++end;
        }
        if (beg == end) {
            return Integer.parseInt("empty");
        }
        return Integer.parseInt(layout.substring(beg, end));
    }

    static String expandCaseDashNotation(String layout) {
        int dash = Attribute.findCaseDash(layout, 0);
        if (dash < 0) {
            return layout;
        }
        StringBuilder result = new StringBuilder(layout.length() * 3);
        int sofar = 0;
        do {
            result.append(layout.substring(sofar, dash));
            sofar = dash + 1;
            int value0 = Attribute.parseIntBefore(layout, dash);
            int value1 = Attribute.parseIntAfter(layout, dash);
            assert (value0 < value1);
            result.append(",");
            for (int i = value0 + 1; i < value1; ++i) {
                result.append(i);
                result.append(",");
            }
        } while ((dash = Attribute.findCaseDash(layout, sofar)) >= 0);
        result.append(layout.substring(sofar));
        return result.toString();
    }

    static int parseUsing(Layout.Element[] elems, Holder holder, byte[] bytes, int pos, int len, ValueStream out) {
        int prevBCI = 0;
        int prevRBCI = 0;
        int end = pos + len;
        int[] buf = new int[]{0};
        block10: for (int i = 0; i < elems.length; ++i) {
            Layout.Element e = elems[i];
            int bandIndex = e.bandIndex;
            switch (e.kind) {
                case 1: {
                    pos = Attribute.parseInt(e, bytes, pos, buf);
                    int value = buf[0];
                    out.putInt(bandIndex, value);
                    continue block10;
                }
                case 2: {
                    pos = Attribute.parseInt(e, bytes, pos, buf);
                    int BCI = buf[0];
                    int RBCI = out.encodeBCI(BCI);
                    int value = !e.flagTest((byte)2) ? RBCI : RBCI - prevRBCI;
                    prevBCI = BCI;
                    prevRBCI = RBCI;
                    out.putInt(bandIndex, value);
                    continue block10;
                }
                case 3: {
                    assert (e.flagTest((byte)2));
                    pos = Attribute.parseInt(e, bytes, pos, buf);
                    int BCI = prevBCI + buf[0];
                    int RBCI = out.encodeBCI(BCI);
                    int value = RBCI - prevRBCI;
                    prevBCI = BCI;
                    prevRBCI = RBCI;
                    out.putInt(bandIndex, value);
                    continue block10;
                }
                case 4: {
                    pos = Attribute.parseInt(e, bytes, pos, buf);
                    int value = buf[0];
                    out.putInt(bandIndex, value);
                    continue block10;
                }
                case 5: {
                    pos = Attribute.parseInt(e, bytes, pos, buf);
                    int value = buf[0];
                    out.putInt(bandIndex, value);
                    for (int j = 0; j < value; ++j) {
                        pos = Attribute.parseUsing(e.body, holder, bytes, pos, end - pos, out);
                    }
                    continue block10;
                }
                case 7: {
                    pos = Attribute.parseInt(e, bytes, pos, buf);
                    int value = buf[0];
                    out.putInt(bandIndex, value);
                    Layout.Element ce = Attribute.matchCase(e, value);
                    pos = Attribute.parseUsing(ce.body, holder, bytes, pos, end - pos, out);
                    continue block10;
                }
                case 9: {
                    assert (e.body.length == 1);
                    assert (e.body[0].kind == 10);
                    if (e.flagTest((byte)8)) {
                        out.noteBackCall(e.value);
                    }
                    pos = Attribute.parseUsing(e.body[0].body, holder, bytes, pos, end - pos, out);
                    continue block10;
                }
                case 6: {
                    ConstantPool.Entry globalRef;
                    pos = Attribute.parseInt(e, bytes, pos, buf);
                    int localRef = buf[0];
                    if (localRef == 0) {
                        globalRef = null;
                    } else {
                        String got;
                        ConstantPool.Entry[] cpMap = holder.getCPMap();
                        globalRef = localRef >= 0 && localRef < cpMap.length ? cpMap[localRef] : null;
                        byte tag = e.refKind;
                        if (globalRef != null && tag == 13 && globalRef.getTag() == 1) {
                            String typeName = globalRef.stringValue();
                            globalRef = ConstantPool.getSignatureEntry(typeName);
                        }
                        String string = got = globalRef == null ? "invalid CP index" : "type=" + ConstantPool.tagName(globalRef.tag);
                        if (globalRef == null || !globalRef.tagMatches(tag)) {
                            throw new IllegalArgumentException("Bad constant, expected type=" + ConstantPool.tagName(tag) + " got " + got);
                        }
                    }
                    out.putRef(bandIndex, globalRef);
                    continue block10;
                }
                default: {
                    assert (false);
                    continue block10;
                }
            }
        }
        return pos;
    }

    static Layout.Element matchCase(Layout.Element e, int value) {
        assert (e.kind == 7);
        int lastj = e.body.length - 1;
        for (int j = 0; j < lastj; ++j) {
            Layout.Element ce = e.body[j];
            assert (ce.kind == 8);
            if (value != ce.value) continue;
            return ce;
        }
        return e.body[lastj];
    }

    private static int parseInt(Layout.Element e, byte[] bytes, int pos, int[] buf) {
        int loBits;
        int value = 0;
        int bitPos = loBits = e.len * 8;
        while ((bitPos -= 8) >= 0) {
            value += (bytes[pos++] & 0xFF) << bitPos;
        }
        if (loBits < 32 && e.flagTest((byte)1)) {
            int hiBits = 32 - loBits;
            value = value << hiBits >> hiBits;
        }
        buf[0] = value;
        return pos;
    }

    static void unparseUsing(Layout.Element[] elems, Object[] fixups, ValueStream in, ByteArrayOutputStream out) {
        int prevBCI = 0;
        int prevRBCI = 0;
        block10: for (int i = 0; i < elems.length; ++i) {
            Layout.Element e = elems[i];
            int bandIndex = e.bandIndex;
            switch (e.kind) {
                case 1: {
                    int value = in.getInt(bandIndex);
                    Attribute.unparseInt(e, value, out);
                    continue block10;
                }
                case 2: {
                    int value = in.getInt(bandIndex);
                    int RBCI = !e.flagTest((byte)2) ? value : prevRBCI + value;
                    assert (prevBCI == in.decodeBCI(prevRBCI));
                    int BCI = in.decodeBCI(RBCI);
                    Attribute.unparseInt(e, BCI, out);
                    prevBCI = BCI;
                    prevRBCI = RBCI;
                    continue block10;
                }
                case 3: {
                    int value = in.getInt(bandIndex);
                    assert (e.flagTest((byte)2));
                    assert (prevBCI == in.decodeBCI(prevRBCI));
                    int RBCI = prevRBCI + value;
                    int BCI = in.decodeBCI(RBCI);
                    Attribute.unparseInt(e, BCI - prevBCI, out);
                    prevBCI = BCI;
                    prevRBCI = RBCI;
                    continue block10;
                }
                case 4: {
                    int value = in.getInt(bandIndex);
                    Attribute.unparseInt(e, value, out);
                    continue block10;
                }
                case 5: {
                    int value = in.getInt(bandIndex);
                    Attribute.unparseInt(e, value, out);
                    for (int j = 0; j < value; ++j) {
                        Attribute.unparseUsing(e.body, fixups, in, out);
                    }
                    continue block10;
                }
                case 7: {
                    int value = in.getInt(bandIndex);
                    Attribute.unparseInt(e, value, out);
                    Layout.Element ce = Attribute.matchCase(e, value);
                    Attribute.unparseUsing(ce.body, fixups, in, out);
                    continue block10;
                }
                case 9: {
                    assert (e.body.length == 1);
                    assert (e.body[0].kind == 10);
                    Attribute.unparseUsing(e.body[0].body, fixups, in, out);
                    continue block10;
                }
                case 6: {
                    int localRef;
                    ConstantPool.Entry globalRef = in.getRef(bandIndex);
                    if (globalRef != null) {
                        fixups[0] = Fixups.addRefWithLoc(fixups[0], out.size(), globalRef);
                        localRef = 0;
                    } else {
                        localRef = 0;
                    }
                    Attribute.unparseInt(e, localRef, out);
                    continue block10;
                }
                default: {
                    assert (false);
                    continue block10;
                }
            }
        }
    }

    private static void unparseInt(Layout.Element e, int value, ByteArrayOutputStream out) {
        int loBits = e.len * 8;
        if (loBits == 0) {
            return;
        }
        if (loBits < 32) {
            int hiBits = 32 - loBits;
            int codedValue = e.flagTest((byte)1) ? value << hiBits >> hiBits : value << hiBits >>> hiBits;
            if (codedValue != value) {
                throw new InternalError("cannot code in " + e.len + " bytes: " + value);
            }
        }
        int bitPos = loBits;
        while ((bitPos -= 8) >= 0) {
            out.write((byte)(value >>> bitPos));
        }
    }

    static {
        Map<Layout, Attribute> sd = standardDefs = new HashMap<Layout, Attribute>();
        Attribute.define(sd, 0, "Signature", "RSH");
        Attribute.define(sd, 0, "Synthetic", "");
        Attribute.define(sd, 0, "Deprecated", "");
        Attribute.define(sd, 0, "SourceFile", "RUH");
        Attribute.define(sd, 0, "EnclosingMethod", "RCHRDNH");
        Attribute.define(sd, 0, "InnerClasses", "NH[RCHRCNHRUNHFH]");
        Attribute.define(sd, 0, "BootstrapMethods", "NH[RMHNH[KLH]]");
        Attribute.define(sd, 1, "Signature", "RSH");
        Attribute.define(sd, 1, "Synthetic", "");
        Attribute.define(sd, 1, "Deprecated", "");
        Attribute.define(sd, 1, "ConstantValue", "KQH");
        Attribute.define(sd, 2, "Signature", "RSH");
        Attribute.define(sd, 2, "Synthetic", "");
        Attribute.define(sd, 2, "Deprecated", "");
        Attribute.define(sd, 2, "Exceptions", "NH[RCH]");
        Attribute.define(sd, 2, "MethodParameters", "NB[RUNHFH]");
        Attribute.define(sd, 3, "StackMapTable", "[NH[(1)]][TB(64-127)[(2)](247)[(1)(2)](248-251)[(1)](252)[(1)(2)](253)[(1)(2)(2)](254)[(1)(2)(2)(2)](255)[(1)NH[(2)]NH[(2)]]()[]][H][TB(7)[RCH](8)[PH]()[]]");
        Attribute.define(sd, 3, "LineNumberTable", "NH[PHH]");
        Attribute.define(sd, 3, "LocalVariableTable", "NH[PHOHRUHRSHH]");
        Attribute.define(sd, 3, "LocalVariableTypeTable", "NH[PHOHRUHRSHH]");
        String[] mdLayouts = new String[]{Attribute.normalizeLayoutString("\n  # parameter_annotations :=\n  [ NB[(1)] ]     # forward call to annotations"), Attribute.normalizeLayoutString("\n  # annotations :=\n  [ NH[(1)] ]     # forward call to annotation\n  "), Attribute.normalizeLayoutString("\n  # annotation :=\n  [RSH\n    NH[RUH (1)]   # forward call to value\n    ]"), Attribute.normalizeLayoutString("\n  # value :=\n  [TB # Callable 2 encodes one tagged value.\n    (\\B,\\C,\\I,\\S,\\Z)[KIH]\n    (\\D)[KDH]\n    (\\F)[KFH]\n    (\\J)[KJH]\n    (\\c)[RSH]\n    (\\e)[RSH RUH]\n    (\\s)[RUH]\n    (\\[)[NH[(0)]] # backward self-call to value\n    (\\@)[RSH NH[RUH (0)]] # backward self-call to value\n    ()[] ]")};
        String[] typeLayouts = new String[]{Attribute.normalizeLayoutString("\n # type-annotations :=\n  [ NH[(1)(2)(3)] ]     # forward call to type-annotations"), Attribute.normalizeLayoutString("\n  # type-annotation :=\n  [TB\n    (0-1) [B] # {CLASS, METHOD}_TYPE_PARAMETER\n    (16) [FH] # CLASS_EXTENDS\n    (17-18) [BB] # {CLASS, METHOD}_TYPE_PARAMETER_BOUND\n    (19-21) [] # FIELD, METHOD_RETURN, METHOD_RECEIVER\n    (22) [B] # METHOD_FORMAL_PARAMETER\n    (23) [H] # THROWS\n    (64-65) [NH[PHOHH]] # LOCAL_VARIABLE, RESOURCE_VARIABLE\n    (66) [H] # EXCEPTION_PARAMETER\n    (67-70) [PH] # INSTANCEOF, NEW, {CONSTRUCTOR, METHOD}_REFERENCE_RECEIVER\n    (71-75) [PHB] # CAST, {CONSTRUCTOR,METHOD}_INVOCATION_TYPE_ARGUMENT, {CONSTRUCTOR, METHOD}_REFERENCE_TYPE_ARGUMENT\n    ()[] ]"), Attribute.normalizeLayoutString("\n # type-path\n [ NB[BB] ]")};
        Map<Layout, Attribute> sd2 = standardDefs;
        String defaultLayout = mdLayouts[3];
        String annotationsLayout = mdLayouts[1] + mdLayouts[2] + mdLayouts[3];
        String paramsLayout = mdLayouts[0] + annotationsLayout;
        String typesLayout = typeLayouts[0] + typeLayouts[1] + typeLayouts[2] + mdLayouts[2] + mdLayouts[3];
        for (int ctype = 0; ctype < 4; ++ctype) {
            if (ctype != 3) {
                Attribute.define(sd2, ctype, "RuntimeVisibleAnnotations", annotationsLayout);
                Attribute.define(sd2, ctype, "RuntimeInvisibleAnnotations", annotationsLayout);
                if (ctype == 2) {
                    Attribute.define(sd2, ctype, "RuntimeVisibleParameterAnnotations", paramsLayout);
                    Attribute.define(sd2, ctype, "RuntimeInvisibleParameterAnnotations", paramsLayout);
                    Attribute.define(sd2, ctype, "AnnotationDefault", defaultLayout);
                }
            }
            Attribute.define(sd2, ctype, "RuntimeVisibleTypeAnnotations", typesLayout);
            Attribute.define(sd2, ctype, "RuntimeInvisibleTypeAnnotations", typesLayout);
        }
        assert (Attribute.expandCaseDashNotation("1-5").equals("1,2,3,4,5"));
        assert (Attribute.expandCaseDashNotation("-2--1").equals("-2,-1"));
        assert (Attribute.expandCaseDashNotation("-2-1").equals("-2,-1,0,1"));
        assert (Attribute.expandCaseDashNotation("-1-0").equals("-1,0"));
    }

    public static class FormatException
    extends IOException {
        private static final long serialVersionUID = -2542243830788066513L;
        private int ctype;
        private String name;
        String layout;

        public FormatException(String message, int ctype, String name, String layout) {
            super(Constants.ATTR_CONTEXT_NAME[ctype] + " attribute \"" + name + "\"" + (message == null ? "" : ": " + message));
            this.ctype = ctype;
            this.name = name;
            this.layout = layout;
        }

        public FormatException(String message, int ctype, String name) {
            this(message, ctype, name, null);
        }
    }

    public static class Layout
    implements Comparable<Layout> {
        int ctype;
        String name;
        boolean hasRefs;
        String layout;
        int bandCount;
        Element[] elems;
        Attribute canon;
        private static final Element[] noElems = new Element[0];

        public int ctype() {
            return this.ctype;
        }

        public String name() {
            return this.name;
        }

        public String layout() {
            return this.layout;
        }

        public Attribute canonicalInstance() {
            return this.canon;
        }

        public ConstantPool.Entry getNameRef() {
            return ConstantPool.getUtf8Entry(this.name());
        }

        public boolean isEmpty() {
            return this.layout.isEmpty();
        }

        public Layout(int ctype, String name, String layout) {
            this.ctype = ctype;
            this.name = name.intern();
            this.layout = layout.intern();
            assert (ctype < 4);
            boolean hasCallables = layout.startsWith("[");
            try {
                if (!hasCallables) {
                    this.elems = Attribute.tokenizeLayout(this, -1, layout);
                } else {
                    Element ce;
                    int i;
                    String[] bodies = Attribute.splitBodies(layout);
                    Element[] lelems = new Element[bodies.length];
                    this.elems = lelems;
                    for (i = 0; i < lelems.length; ++i) {
                        ce = new Element();
                        ce.kind = (byte)10;
                        ce.removeBand();
                        ce.bandIndex = -1;
                        ce.layout = bodies[i];
                        lelems[i] = ce;
                    }
                    for (i = 0; i < lelems.length; ++i) {
                        ce = lelems[i];
                        ce.body = Attribute.tokenizeLayout(this, i, bodies[i]);
                    }
                }
            }
            catch (StringIndexOutOfBoundsException ee) {
                throw new RuntimeException("Bad attribute layout: " + layout, ee);
            }
            this.canon = new Attribute(this, Constants.noBytes);
        }

        private Layout() {
        }

        static Layout makeKey(int ctype, String name, String layout) {
            Layout def = new Layout();
            def.ctype = ctype;
            def.name = name.intern();
            def.layout = layout.intern();
            assert (ctype < 4);
            return def;
        }

        static Layout makeKey(int ctype, String name) {
            return Layout.makeKey(ctype, name, "");
        }

        public Attribute addContent(byte[] bytes, Object fixups) {
            return this.canon.addContent(bytes, fixups);
        }

        public Attribute addContent(byte[] bytes) {
            return this.canon.addContent(bytes, null);
        }

        public boolean equals(Object x) {
            return x != null && x.getClass() == Layout.class && this.equals((Layout)x);
        }

        public boolean equals(Layout that) {
            return this.name.equals(that.name) && this.layout.equals(that.layout) && this.ctype == that.ctype;
        }

        public int hashCode() {
            return ((17 + this.name.hashCode()) * 37 + this.layout.hashCode()) * 37 + this.ctype;
        }

        @Override
        public int compareTo(Layout that) {
            int r = this.name.compareTo(that.name);
            if (r != 0) {
                return r;
            }
            r = this.layout.compareTo(that.layout);
            if (r != 0) {
                return r;
            }
            return this.ctype - that.ctype;
        }

        public String toString() {
            String str = Attribute.contextName(this.ctype) + "." + this.name + "[" + this.layout + "]";
            assert ((str = this.stringForDebug()) != null);
            return str;
        }

        private String stringForDebug() {
            return Attribute.contextName(this.ctype) + "." + this.name + Arrays.asList(this.elems);
        }

        public boolean hasCallables() {
            return this.elems.length > 0 && this.elems[0].kind == 10;
        }

        public Element[] getCallables() {
            if (this.hasCallables()) {
                Element[] nelems = Arrays.copyOf(this.elems, this.elems.length);
                return nelems;
            }
            return noElems;
        }

        public Element[] getEntryPoint() {
            if (this.hasCallables()) {
                return this.elems[0].body;
            }
            Element[] nelems = Arrays.copyOf(this.elems, this.elems.length);
            return nelems;
        }

        public void parse(Holder holder, byte[] bytes, int pos, int len, ValueStream out) {
            int end = Attribute.parseUsing(this.getEntryPoint(), holder, bytes, pos, len, out);
            if (end != pos + len) {
                throw new InternalError("layout parsed " + (end - pos) + " out of " + len + " bytes");
            }
        }

        public Object unparse(ValueStream in, ByteArrayOutputStream out) {
            Object[] fixups = new Object[]{null};
            Attribute.unparseUsing(this.getEntryPoint(), fixups, in, out);
            return fixups[0];
        }

        public String layoutForClassVersion(Package.Version vers) {
            if (vers.lessThan(Constants.JAVA6_MAX_CLASS_VERSION)) {
                return Attribute.expandCaseDashNotation(this.layout);
            }
            return this.layout;
        }

        public class Element {
            String layout;
            byte flags;
            byte kind;
            byte len;
            byte refKind;
            int bandIndex;
            int value;
            Element[] body;

            boolean flagTest(byte mask) {
                return (this.flags & mask) != 0;
            }

            Element() {
                this.bandIndex = Layout.this.bandCount++;
            }

            void removeBand() {
                --Layout.this.bandCount;
                assert (this.bandIndex == Layout.this.bandCount);
                this.bandIndex = -1;
            }

            public boolean hasBand() {
                return this.bandIndex >= 0;
            }

            public String toString() {
                String str = this.layout;
                assert ((str = this.stringForDebug()) != null);
                return str;
            }

            private String stringForDebug() {
                Element[] lbody = this.body;
                switch (this.kind) {
                    case 9: {
                        lbody = null;
                        break;
                    }
                    case 8: {
                        if (!this.flagTest((byte)8)) break;
                        lbody = null;
                    }
                }
                return this.layout + (!this.hasBand() ? "" : "#" + this.bandIndex) + "<" + (this.flags == 0 ? "" : "" + this.flags) + this.kind + this.len + (this.refKind == 0 ? "" : "" + this.refKind) + ">" + (this.value == 0 ? "" : "(" + this.value + ")") + (lbody == null ? "" : "" + Arrays.asList(lbody));
            }
        }
    }

    public static abstract class ValueStream {
        public int getInt(int bandIndex) {
            throw this.undef();
        }

        public void putInt(int bandIndex, int value) {
            throw this.undef();
        }

        public ConstantPool.Entry getRef(int bandIndex) {
            throw this.undef();
        }

        public void putRef(int bandIndex, ConstantPool.Entry ref) {
            throw this.undef();
        }

        public int decodeBCI(int bciCode) {
            throw this.undef();
        }

        public int encodeBCI(int bci) {
            throw this.undef();
        }

        public void noteBackCall(int whichCallable) {
        }

        private RuntimeException undef() {
            return new UnsupportedOperationException("ValueStream method");
        }
    }

    public static abstract class Holder {
        protected int flags;
        protected List<Attribute> attributes;
        static final List<Attribute> noAttributes = Arrays.asList(new Attribute[0]);

        protected abstract ConstantPool.Entry[] getCPMap();

        public int attributeSize() {
            return this.attributes == null ? 0 : this.attributes.size();
        }

        public void trimToSize() {
            if (this.attributes == null) {
                return;
            }
            if (this.attributes.isEmpty()) {
                this.attributes = null;
                return;
            }
            if (this.attributes instanceof ArrayList) {
                ArrayList al = (ArrayList)this.attributes;
                al.trimToSize();
                boolean allCanon = true;
                for (Attribute a : al) {
                    if (!a.isCanonical()) {
                        allCanon = false;
                    }
                    if (a.fixups == null) continue;
                    assert (!a.isCanonical());
                    a.fixups = Fixups.trimToSize(a.fixups);
                }
                if (allCanon) {
                    this.attributes = Attribute.getCanonList(al);
                }
            }
        }

        public void addAttribute(Attribute a) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<Attribute>(3);
            } else if (!(this.attributes instanceof ArrayList)) {
                this.attributes = new ArrayList<Attribute>(this.attributes);
            }
            this.attributes.add(a);
        }

        public Attribute removeAttribute(Attribute a) {
            if (this.attributes == null) {
                return null;
            }
            if (!this.attributes.contains(a)) {
                return null;
            }
            if (!(this.attributes instanceof ArrayList)) {
                this.attributes = new ArrayList<Attribute>(this.attributes);
            }
            this.attributes.remove(a);
            return a;
        }

        public Attribute getAttribute(int n) {
            return this.attributes.get(n);
        }

        protected void visitRefs(int mode, Collection<ConstantPool.Entry> refs) {
            if (this.attributes == null) {
                return;
            }
            for (Attribute a : this.attributes) {
                a.visitRefs(this, mode, refs);
            }
        }

        public List<Attribute> getAttributes() {
            if (this.attributes == null) {
                return noAttributes;
            }
            return this.attributes;
        }

        public void setAttributes(List<Attribute> attrList) {
            this.attributes = attrList.isEmpty() ? null : attrList;
        }

        public Attribute getAttribute(String attrName) {
            if (this.attributes == null) {
                return null;
            }
            for (Attribute a : this.attributes) {
                if (!a.name().equals(attrName)) continue;
                return a;
            }
            return null;
        }

        public Attribute getAttribute(Layout attrDef) {
            if (this.attributes == null) {
                return null;
            }
            for (Attribute a : this.attributes) {
                if (a.layout() != attrDef) continue;
                return a;
            }
            return null;
        }

        public Attribute removeAttribute(String attrName) {
            return this.removeAttribute(this.getAttribute(attrName));
        }

        public Attribute removeAttribute(Layout attrDef) {
            return this.removeAttribute(this.getAttribute(attrDef));
        }

        public void strip(String attrName) {
            this.removeAttribute(this.getAttribute(attrName));
        }
    }
}

