/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Enumerated
implements Serializable {
    protected int value;

    public Enumerated() throws IllegalArgumentException {
        Enumeration<Integer> e = this.getIntTable().keys();
        if (!e.hasMoreElements()) {
            throw new IllegalArgumentException();
        }
        this.value = e.nextElement();
    }

    public Enumerated(int valueIndex) throws IllegalArgumentException {
        if (this.getIntTable().get(new Integer(valueIndex)) == null) {
            throw new IllegalArgumentException();
        }
        this.value = valueIndex;
    }

    public Enumerated(Integer valueIndex) throws IllegalArgumentException {
        if (this.getIntTable().get(valueIndex) == null) {
            throw new IllegalArgumentException();
        }
        this.value = valueIndex;
    }

    public Enumerated(String valueString) throws IllegalArgumentException {
        Integer index = this.getStringTable().get(valueString);
        if (index == null) {
            throw new IllegalArgumentException();
        }
        this.value = index;
    }

    public int intValue() {
        return this.value;
    }

    public Enumeration<Integer> valueIndexes() {
        return this.getIntTable().keys();
    }

    public Enumeration<String> valueStrings() {
        return this.getStringTable().keys();
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.value == ((Enumerated)obj).value;
    }

    public int hashCode() {
        String hashString = this.getClass().getName() + String.valueOf(this.value);
        return hashString.hashCode();
    }

    public String toString() {
        return this.getIntTable().get(new Integer(this.value));
    }

    protected abstract Hashtable<Integer, String> getIntTable();

    protected abstract Hashtable<String, Integer> getStringTable();
}

