/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.IPAcl;

import com.sun.jmx.snmp.IPAcl.AclEntryImpl;
import com.sun.jmx.snmp.IPAcl.OwnerImpl;
import com.sun.jmx.snmp.IPAcl.PrincipalImpl;
import java.io.Serializable;
import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Vector;

class AclImpl
extends OwnerImpl
implements Acl,
Serializable {
    private static final long serialVersionUID = -2250957591085270029L;
    private Vector<AclEntry> entryList = new Vector();
    private String aclName = null;

    public AclImpl(PrincipalImpl owner, String name) {
        super(owner);
        this.aclName = name;
    }

    @Override
    public void setName(Principal caller, String name) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        this.aclName = name;
    }

    @Override
    public String getName() {
        return this.aclName;
    }

    @Override
    public boolean addEntry(Principal caller, AclEntry entry) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        if (this.entryList.contains(entry)) {
            return false;
        }
        this.entryList.addElement(entry);
        return true;
    }

    @Override
    public boolean removeEntry(Principal caller, AclEntry entry) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        return this.entryList.removeElement(entry);
    }

    public void removeAll(Principal caller) throws NotOwnerException {
        if (!this.isOwner(caller)) {
            throw new NotOwnerException();
        }
        this.entryList.removeAllElements();
    }

    @Override
    public Enumeration<Permission> getPermissions(Principal user) {
        Vector empty = new Vector();
        Enumeration<AclEntry> e = this.entryList.elements();
        while (e.hasMoreElements()) {
            AclEntry ent = e.nextElement();
            if (!ent.getPrincipal().equals(user)) continue;
            return ent.permissions();
        }
        return empty.elements();
    }

    @Override
    public Enumeration<AclEntry> entries() {
        return this.entryList.elements();
    }

    @Override
    public boolean checkPermission(Principal user, Permission perm) {
        Enumeration<AclEntry> e = this.entryList.elements();
        while (e.hasMoreElements()) {
            AclEntry ent = e.nextElement();
            if (!ent.getPrincipal().equals(user) || !ent.checkPermission(perm)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPermission(Principal user, String community, Permission perm) {
        Enumeration<AclEntry> e = this.entryList.elements();
        while (e.hasMoreElements()) {
            AclEntryImpl ent = (AclEntryImpl)e.nextElement();
            if (!ent.getPrincipal().equals(user) || !ent.checkPermission(perm) || !ent.checkCommunity(community)) continue;
            return true;
        }
        return false;
    }

    public boolean checkCommunity(String community) {
        Enumeration<AclEntry> e = this.entryList.elements();
        while (e.hasMoreElements()) {
            AclEntryImpl ent = (AclEntryImpl)e.nextElement();
            if (!ent.checkCommunity(community)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "AclImpl: " + this.getName();
    }
}

