/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.Enumerated;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;

public class SnmpInt
extends SnmpValue {
    private static final long serialVersionUID = -7163624758070343373L;
    static final String name = "Integer32";
    protected long value = 0L;

    public SnmpInt(int v) throws IllegalArgumentException {
        if (!this.isInitValueValid(v)) {
            throw new IllegalArgumentException();
        }
        this.value = v;
    }

    public SnmpInt(Integer v) throws IllegalArgumentException {
        this((int)v);
    }

    public SnmpInt(long v) throws IllegalArgumentException {
        if (!this.isInitValueValid(v)) {
            throw new IllegalArgumentException();
        }
        this.value = v;
    }

    public SnmpInt(Long v) throws IllegalArgumentException {
        this((long)v);
    }

    public SnmpInt(Enumerated v) throws IllegalArgumentException {
        this(v.intValue());
    }

    public SnmpInt(boolean v) {
        this.value = v ? 1L : 2L;
    }

    public long longValue() {
        return this.value;
    }

    public Long toLong() {
        return new Long(this.value);
    }

    public int intValue() {
        return (int)this.value;
    }

    public Integer toInteger() {
        return new Integer((int)this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public SnmpOid toOid() {
        return new SnmpOid(this.value);
    }

    public static SnmpOid toOid(long[] index, int start) throws SnmpStatusException {
        try {
            return new SnmpOid(index[start]);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SnmpStatusException(2);
        }
    }

    public static int nextOid(long[] index, int start) throws SnmpStatusException {
        if (start >= index.length) {
            throw new SnmpStatusException(2);
        }
        return start + 1;
    }

    public static void appendToOid(SnmpOid source, SnmpOid dest) {
        if (source.getLength() != 1) {
            throw new IllegalArgumentException();
        }
        dest.append(source);
    }

    @Override
    public final synchronized SnmpValue duplicate() {
        return (SnmpValue)this.clone();
    }

    public final synchronized Object clone() {
        SnmpInt newclone = null;
        try {
            newclone = (SnmpInt)super.clone();
            newclone.value = this.value;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
        return newclone;
    }

    @Override
    public String getTypeName() {
        return name;
    }

    boolean isInitValueValid(int v) {
        return v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE;
    }

    boolean isInitValueValid(long v) {
        return v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE;
    }
}

