/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.BerDecoder;
import com.sun.jmx.snmp.BerEncoder;
import com.sun.jmx.snmp.BerException;
import com.sun.jmx.snmp.SnmpCounter;
import com.sun.jmx.snmp.SnmpCounter64;
import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpGauge;
import com.sun.jmx.snmp.SnmpInt;
import com.sun.jmx.snmp.SnmpIpAddress;
import com.sun.jmx.snmp.SnmpNull;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpOpaque;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpSecurityParameters;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpString;
import com.sun.jmx.snmp.SnmpTimeticks;
import com.sun.jmx.snmp.SnmpTooBigException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.SnmpVarBind;
import java.net.InetAddress;
import java.util.Vector;

public abstract class SnmpMsg
implements SnmpDefinitions {
    public int version = 0;
    public byte[] data = null;
    public int dataLength = 0;
    public InetAddress address = null;
    public int port = 0;
    public SnmpSecurityParameters securityParameters = null;

    public static int getProtocolVersion(byte[] data) throws SnmpStatusException {
        int version = 0;
        BerDecoder bdec = null;
        try {
            bdec = new BerDecoder(data);
            bdec.openSequence();
            version = bdec.fetchInteger();
        }
        catch (BerException x) {
            throw new SnmpStatusException("Invalid encoding");
        }
        try {
            bdec.closeSequence();
        }
        catch (BerException berException) {
            // empty catch block
        }
        return version;
    }

    public abstract int getRequestId(byte[] var1) throws SnmpStatusException;

    public abstract int encodeMessage(byte[] var1) throws SnmpTooBigException;

    public abstract void decodeMessage(byte[] var1, int var2) throws SnmpStatusException;

    public abstract void encodeSnmpPdu(SnmpPdu var1, int var2) throws SnmpStatusException, SnmpTooBigException;

    public abstract SnmpPdu decodeSnmpPdu() throws SnmpStatusException;

    public static String dumpHexBuffer(byte[] b, int offset, int len) {
        StringBuffer buf = new StringBuffer(len << 1);
        int k = 1;
        int flen = offset + len;
        for (int i = offset; i < flen; ++i) {
            int j = b[i] & 0xFF;
            buf.append(Character.forDigit(j >>> 4, 16));
            buf.append(Character.forDigit(j & 0xF, 16));
            if (++k % 16 == 0) {
                buf.append('\n');
                k = 1;
                continue;
            }
            buf.append(' ');
        }
        return buf.toString();
    }

    public String printMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append("Version: ");
        sb.append(this.version);
        sb.append("\n");
        if (this.data == null) {
            sb.append("Data: null");
        } else {
            sb.append("Data: {\n");
            sb.append(SnmpMsg.dumpHexBuffer(this.data, 0, this.dataLength));
            sb.append("\n}\n");
        }
        return sb.toString();
    }

    public void encodeVarBindList(BerEncoder benc, SnmpVarBind[] varBindList) throws SnmpStatusException, SnmpTooBigException {
        int encodedVarBindCount = 0;
        try {
            benc.openSequence();
            if (varBindList != null) {
                for (int i = varBindList.length - 1; i >= 0; --i) {
                    SnmpVarBind bind = varBindList[i];
                    if (bind == null) continue;
                    benc.openSequence();
                    this.encodeVarBindValue(benc, bind.value);
                    benc.putOid(bind.oid.longValue());
                    benc.closeSequence();
                    ++encodedVarBindCount;
                }
            }
            benc.closeSequence();
        }
        catch (ArrayIndexOutOfBoundsException x) {
            throw new SnmpTooBigException(encodedVarBindCount);
        }
    }

    void encodeVarBindValue(BerEncoder benc, SnmpValue v) throws SnmpStatusException {
        if (v == null) {
            benc.putNull();
        } else if (v instanceof SnmpIpAddress) {
            benc.putOctetString(((SnmpIpAddress)v).byteValue(), 64);
        } else if (v instanceof SnmpCounter) {
            benc.putInteger(((SnmpCounter)v).longValue(), 65);
        } else if (v instanceof SnmpGauge) {
            benc.putInteger(((SnmpGauge)v).longValue(), 66);
        } else if (v instanceof SnmpTimeticks) {
            benc.putInteger(((SnmpTimeticks)v).longValue(), 67);
        } else if (v instanceof SnmpOpaque) {
            benc.putOctetString(((SnmpOpaque)v).byteValue(), 68);
        } else if (v instanceof SnmpInt) {
            benc.putInteger(((SnmpInt)v).intValue());
        } else if (v instanceof SnmpString) {
            benc.putOctetString(((SnmpString)v).byteValue());
        } else if (v instanceof SnmpOid) {
            benc.putOid(((SnmpOid)v).longValue());
        } else if (v instanceof SnmpCounter64) {
            if (this.version == 0) {
                throw new SnmpStatusException("Invalid value for SNMP v1 : " + v);
            }
            benc.putInteger(((SnmpCounter64)v).longValue(), 70);
        } else if (v instanceof SnmpNull) {
            int tag = ((SnmpNull)v).getTag();
            if (this.version == 0 && tag != 5) {
                throw new SnmpStatusException("Invalid value for SNMP v1 : " + v);
            }
            if (this.version == 1 && tag != 5 && tag != 128 && tag != 129 && tag != 130) {
                throw new SnmpStatusException("Invalid value " + v);
            }
            benc.putNull(tag);
        } else {
            throw new SnmpStatusException("Invalid value " + v);
        }
    }

    public SnmpVarBind[] decodeVarBindList(BerDecoder bdec) throws BerException {
        bdec.openSequence();
        Vector<SnmpVarBind> tmp = new Vector<SnmpVarBind>();
        while (bdec.cannotCloseSequence()) {
            SnmpVarBind bind = new SnmpVarBind();
            bdec.openSequence();
            bind.oid = new SnmpOid(bdec.fetchOid());
            bind.setSnmpValue(this.decodeVarBindValue(bdec));
            bdec.closeSequence();
            tmp.addElement(bind);
        }
        bdec.closeSequence();
        Object[] varBindList = new SnmpVarBind[tmp.size()];
        tmp.copyInto(varBindList);
        return varBindList;
    }

    SnmpValue decodeVarBindValue(BerDecoder bdec) throws BerException {
        SnmpValue result = null;
        int tag = bdec.getTag();
        switch (tag) {
            case 2: {
                try {
                    result = new SnmpInt(bdec.fetchInteger());
                    break;
                }
                catch (RuntimeException r) {
                    throw new BerException();
                }
            }
            case 4: {
                try {
                    result = new SnmpString(bdec.fetchOctetString());
                    break;
                }
                catch (RuntimeException r) {
                    throw new BerException();
                }
            }
            case 6: {
                try {
                    result = new SnmpOid(bdec.fetchOid());
                    break;
                }
                catch (RuntimeException r) {
                    throw new BerException();
                }
            }
            case 5: {
                bdec.fetchNull();
                try {
                    result = new SnmpNull();
                    break;
                }
                catch (RuntimeException r) {
                    throw new BerException();
                }
            }
            case 64: {
                try {
                    result = new SnmpIpAddress(bdec.fetchOctetString(tag));
                    break;
                }
                catch (RuntimeException r) {
                    throw new BerException();
                }
            }
            case 65: {
                try {
                    result = new SnmpCounter(bdec.fetchIntegerAsLong(tag));
                    break;
                }
                catch (RuntimeException r) {
                    throw new BerException();
                }
            }
            case 66: {
                try {
                    result = new SnmpGauge(bdec.fetchIntegerAsLong(tag));
                    break;
                }
                catch (RuntimeException r) {
                    throw new BerException();
                }
            }
            case 67: {
                try {
                    result = new SnmpTimeticks(bdec.fetchIntegerAsLong(tag));
                    break;
                }
                catch (RuntimeException r) {
                    throw new BerException();
                }
            }
            case 68: {
                try {
                    result = new SnmpOpaque(bdec.fetchOctetString(tag));
                    break;
                }
                catch (RuntimeException r) {
                    throw new BerException();
                }
            }
            case 70: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                try {
                    result = new SnmpCounter64(bdec.fetchIntegerAsLong(tag));
                    break;
                }
                catch (RuntimeException r) {
                    throw new BerException();
                }
            }
            case 128: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                bdec.fetchNull(tag);
                result = SnmpVarBind.noSuchObject;
                break;
            }
            case 129: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                bdec.fetchNull(tag);
                result = SnmpVarBind.noSuchInstance;
                break;
            }
            case 130: {
                if (this.version == 0) {
                    throw new BerException(1);
                }
                bdec.fetchNull(tag);
                result = SnmpVarBind.endOfMibView;
                break;
            }
            default: {
                throw new BerException();
            }
        }
        return result;
    }
}

