/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.mbeanserver.Util;
import com.sun.jmx.snmp.SnmpOidDatabase;
import com.sun.jmx.snmp.SnmpOidRecord;
import com.sun.jmx.snmp.SnmpOidTable;
import com.sun.jmx.snmp.SnmpStatusException;
import java.util.Vector;

public class SnmpOidDatabaseSupport
implements SnmpOidDatabase {
    private Vector<SnmpOidTable> tables = new Vector();

    public SnmpOidDatabaseSupport() {
    }

    public SnmpOidDatabaseSupport(SnmpOidTable table) {
        this.tables.addElement(table);
    }

    @Override
    public void add(SnmpOidTable table) {
        if (!this.tables.contains(table)) {
            this.tables.addElement(table);
        }
    }

    @Override
    public void remove(SnmpOidTable table) throws SnmpStatusException {
        if (!this.tables.contains(table)) {
            throw new SnmpStatusException("The specified SnmpOidTable does not exist in this SnmpOidDatabase");
        }
        this.tables.removeElement(table);
    }

    @Override
    public SnmpOidRecord resolveVarName(String name) throws SnmpStatusException {
        for (int i = 0; i < this.tables.size(); ++i) {
            try {
                return this.tables.elementAt(i).resolveVarName(name);
            }
            catch (SnmpStatusException e) {
                if (i != this.tables.size() - 1) continue;
                throw new SnmpStatusException(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public SnmpOidRecord resolveVarOid(String oid) throws SnmpStatusException {
        for (int i = 0; i < this.tables.size(); ++i) {
            try {
                return this.tables.elementAt(i).resolveVarOid(oid);
            }
            catch (SnmpStatusException e) {
                if (i != this.tables.size() - 1) continue;
                throw new SnmpStatusException(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public Vector<?> getAllEntries() {
        Vector res = new Vector();
        for (int i = 0; i < this.tables.size(); ++i) {
            Vector tmp = (Vector)Util.cast(this.tables.elementAt(i).getAllEntries());
            if (tmp == null) continue;
            for (int ii = 0; ii < tmp.size(); ++ii) {
                res.addElement(tmp.elementAt(ii));
            }
        }
        return res;
    }

    @Override
    public void removeAll() {
        this.tables.removeAllElements();
    }
}

