/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpOidRecord;
import com.sun.jmx.snmp.SnmpOidTable;
import com.sun.jmx.snmp.SnmpStatusException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Vector;
import java.util.logging.Level;

public class SnmpOidTableSupport
implements SnmpOidTable {
    private Hashtable<String, SnmpOidRecord> oidStore = new Hashtable();
    private String myName;

    public SnmpOidTableSupport(String name) {
        this.myName = name;
    }

    @Override
    public SnmpOidRecord resolveVarName(String name) throws SnmpStatusException {
        SnmpOidRecord var = this.oidStore.get(name);
        if (var != null) {
            return var;
        }
        throw new SnmpStatusException("Variable name <" + name + "> not found in Oid repository");
    }

    @Override
    public SnmpOidRecord resolveVarOid(String oid) throws SnmpStatusException {
        int index = oid.indexOf(46);
        if (index < 0) {
            throw new SnmpStatusException("Variable oid <" + oid + "> not found in Oid repository");
        }
        if (index == 0) {
            oid = oid.substring(1, oid.length());
        }
        Enumeration<SnmpOidRecord> list = this.oidStore.elements();
        while (list.hasMoreElements()) {
            SnmpOidRecord element = list.nextElement();
            if (!element.getOid().equals(oid)) continue;
            return element;
        }
        throw new SnmpStatusException("Variable oid <" + oid + "> not found in Oid repository");
    }

    public Vector<SnmpOidRecord> getAllEntries() {
        Vector<SnmpOidRecord> elementsVector = new Vector<SnmpOidRecord>();
        Enumeration<SnmpOidRecord> e = this.oidStore.elements();
        while (e.hasMoreElements()) {
            elementsVector.addElement(e.nextElement());
        }
        return elementsVector;
    }

    public synchronized void loadMib(SnmpOidRecord[] mibs) {
        try {
            int i = 0;
            while (true) {
                SnmpOidRecord s = mibs[i];
                if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpOidTableSupport.class.getName(), "loadMib", "Load " + s.getName());
                }
                this.oidStore.put(s.getName(), s);
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SnmpOidTableSupport)) {
            return false;
        }
        SnmpOidTableSupport val = (SnmpOidTableSupport)object;
        return this.myName.equals(val.getName());
    }

    public int hashCode() {
        return Objects.hashCode(this.myName);
    }

    public String getName() {
        return this.myName;
    }
}

