/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpParams;
import com.sun.jmx.snmp.SnmpStatusException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Objects;

public class SnmpParameters
extends SnmpParams
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1822462497931733790L;
    static final String defaultRdCommunity = "public";
    private int _protocolVersion = 0;
    private String _readCommunity;
    private String _writeCommunity;
    private String _informCommunity;

    public SnmpParameters() {
        this._readCommunity = defaultRdCommunity;
        this._informCommunity = defaultRdCommunity;
    }

    public SnmpParameters(String rdc, String wrc) {
        this._readCommunity = rdc;
        this._writeCommunity = wrc;
        this._informCommunity = defaultRdCommunity;
    }

    public SnmpParameters(String rdc, String wrc, String inform) {
        this._readCommunity = rdc;
        this._writeCommunity = wrc;
        this._informCommunity = inform;
    }

    public String getRdCommunity() {
        return this._readCommunity;
    }

    public synchronized void setRdCommunity(String read) {
        this._readCommunity = read == null ? defaultRdCommunity : read;
    }

    public String getWrCommunity() {
        return this._writeCommunity;
    }

    public void setWrCommunity(String write) {
        this._writeCommunity = write;
    }

    public String getInformCommunity() {
        return this._informCommunity;
    }

    public void setInformCommunity(String inform) {
        this._informCommunity = inform == null ? defaultRdCommunity : inform;
    }

    @Override
    public boolean allowSnmpSets() {
        return this._writeCommunity != null;
    }

    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof SnmpParameters)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        SnmpParameters param = (SnmpParameters)obj;
        return this._protocolVersion == param._protocolVersion && this._readCommunity.equals(param._readCommunity);
    }

    public synchronized int hashCode() {
        return this._protocolVersion * 31 ^ Objects.hashCode(this._readCommunity);
    }

    public synchronized Object clone() {
        SnmpParameters par = null;
        try {
            par = (SnmpParameters)super.clone();
            par._readCommunity = this._readCommunity;
            par._writeCommunity = this._writeCommunity;
            par._informCommunity = this._informCommunity;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return par;
    }

    public byte[] encodeAuthentication(int snmpCmd) throws SnmpStatusException {
        try {
            if (snmpCmd == 163) {
                return this._writeCommunity.getBytes("8859_1");
            }
            if (snmpCmd == 166) {
                return this._informCommunity.getBytes("8859_1");
            }
            return this._readCommunity.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new SnmpStatusException(e.getMessage());
        }
    }
}

