/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpParameters;
import com.sun.jmx.snmp.SnmpParams;
import com.sun.jmx.snmp.SnmpPduFactory;
import com.sun.jmx.snmp.SnmpPduFactoryBER;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpPeer
implements Serializable {
    private static final long serialVersionUID = -5554565062847175999L;
    public static final int defaultSnmpRequestPktSize = 2048;
    public static final int defaultSnmpResponsePktSize = 8192;
    private int maxVarBindLimit = 25;
    private int portNum = 161;
    private int maxTries = 3;
    private int timeout = 3000;
    private SnmpPduFactory pduFactory = new SnmpPduFactoryBER();
    private long _maxrtt;
    private long _minrtt;
    private long _avgrtt;
    private SnmpParams _snmpParameter = new SnmpParameters();
    private InetAddress _devAddr = null;
    private int maxSnmpPacketSize = 2048;
    InetAddress[] _devAddrList = null;
    int _addrIndex = 0;
    private boolean customPduFactory = false;

    public SnmpPeer(String host) throws UnknownHostException {
        this(host, 161);
    }

    public SnmpPeer(InetAddress netaddr, int port) {
        this._devAddr = netaddr;
        this.portNum = port;
    }

    public SnmpPeer(InetAddress netaddr) {
        this._devAddr = netaddr;
    }

    public SnmpPeer(String host, int port) throws UnknownHostException {
        this.useIPAddress(host);
        this.portNum = port;
    }

    public final synchronized void useIPAddress(String ipaddr) throws UnknownHostException {
        this._devAddr = InetAddress.getByName(ipaddr);
    }

    public final synchronized String ipAddressInUse() {
        byte[] adr = this._devAddr.getAddress();
        return (adr[0] & 0xFF) + "." + (adr[1] & 0xFF) + "." + (adr[2] & 0xFF) + "." + (adr[3] & 0xFF);
    }

    public final synchronized void useAddressList(InetAddress[] adrList) {
        this._devAddrList = adrList != null ? (InetAddress[])adrList.clone() : null;
        this._addrIndex = 0;
        this.useNextAddress();
    }

    public final synchronized void useNextAddress() {
        if (this._devAddrList == null) {
            return;
        }
        if (this._addrIndex > this._devAddrList.length - 1) {
            this._addrIndex = 0;
        }
        this._devAddr = this._devAddrList[this._addrIndex++];
    }

    public boolean allowSnmpSets() {
        return this._snmpParameter.allowSnmpSets();
    }

    public final InetAddress[] getDestAddrList() {
        return this._devAddrList == null ? null : (InetAddress[])this._devAddrList.clone();
    }

    public final InetAddress getDestAddr() {
        return this._devAddr;
    }

    public final int getDestPort() {
        return this.portNum;
    }

    public final synchronized void setDestPort(int newPort) {
        this.portNum = newPort;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final synchronized void setTimeout(int newTimeout) {
        if (newTimeout < 0) {
            throw new IllegalArgumentException();
        }
        this.timeout = newTimeout;
    }

    public final int getMaxTries() {
        return this.maxTries;
    }

    public final synchronized void setMaxTries(int newMaxTries) {
        if (newMaxTries < 0) {
            throw new IllegalArgumentException();
        }
        this.maxTries = newMaxTries;
    }

    public final String getDevName() {
        return this.getDestAddr().getHostName();
    }

    public String toString() {
        return "Peer/Port : " + this.getDestAddr().getHostAddress() + "/" + this.getDestPort();
    }

    public final synchronized int getVarBindLimit() {
        return this.maxVarBindLimit;
    }

    public final synchronized void setVarBindLimit(int limit) {
        this.maxVarBindLimit = limit;
    }

    public void setParams(SnmpParams params) {
        this._snmpParameter = params;
    }

    public SnmpParams getParams() {
        return this._snmpParameter;
    }

    public final int getMaxSnmpPktSize() {
        return this.maxSnmpPacketSize;
    }

    public final synchronized void setMaxSnmpPktSize(int newsize) {
        this.maxSnmpPacketSize = newsize;
    }

    boolean isCustomPduFactory() {
        return this.customPduFactory;
    }

    protected void finalize() {
        this._devAddr = null;
        this._devAddrList = null;
        this._snmpParameter = null;
    }

    public long getMinRtt() {
        return this._minrtt;
    }

    public long getMaxRtt() {
        return this._maxrtt;
    }

    public long getAvgRtt() {
        return this._avgrtt;
    }

    private void updateRttStats(long tm) {
        if (this._minrtt > tm) {
            this._minrtt = tm;
        } else if (this._maxrtt < tm) {
            this._maxrtt = tm;
        } else {
            this._avgrtt = tm;
        }
    }
}

