/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpUnsignedInt;

public class SnmpTimeticks
extends SnmpUnsignedInt {
    static final String name = "TimeTicks";
    private static final long serialVersionUID = -5486435222360030630L;

    public SnmpTimeticks(int v) throws IllegalArgumentException {
        super(v);
    }

    public SnmpTimeticks(Integer v) throws IllegalArgumentException {
        super(v);
    }

    public SnmpTimeticks(long v) throws IllegalArgumentException {
        super(v > 0L ? v & 0xFFFFFFFFL : v);
    }

    public SnmpTimeticks(Long v) throws IllegalArgumentException {
        this((long)v);
    }

    public static final String printTimeTicks(long timeticks) {
        StringBuffer buf = new StringBuffer();
        int days = (int)((timeticks /= 100L) / 86400L);
        int hours = (int)((timeticks %= 86400L) / 3600L);
        int minutes = (int)((timeticks %= 3600L) / 60L);
        int seconds = (int)(timeticks % 60L);
        if (days == 0) {
            buf.append(hours + ":" + minutes + ":" + seconds);
            return buf.toString();
        }
        if (days == 1) {
            buf.append("1 day ");
        } else {
            buf.append(days + " days ");
        }
        buf.append(hours + ":" + minutes + ":" + seconds);
        return buf.toString();
    }

    @Override
    public final String toString() {
        return SnmpTimeticks.printTimeTicks(this.value);
    }

    @Override
    public final String getTypeName() {
        return name;
    }
}

