/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.Timestamp;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpVarBindList
extends Vector<SnmpVarBind> {
    private static final long serialVersionUID = -7203997794636430321L;
    public String identity = "VarBindList ";
    Timestamp timestamp;

    public SnmpVarBindList() {
        super(5, 5);
    }

    public SnmpVarBindList(int initialCapacity) {
        super(initialCapacity);
    }

    public SnmpVarBindList(String name) {
        super(5, 5);
        this.identity = name;
    }

    public SnmpVarBindList(SnmpVarBindList list) {
        super(list.size(), 5);
        list.copyInto(this.elementData);
        this.elementCount = list.size();
    }

    public SnmpVarBindList(Vector<SnmpVarBind> list) {
        super(list.size(), 5);
        Enumeration<SnmpVarBind> e = list.elements();
        while (e.hasMoreElements()) {
            SnmpVarBind varBind = e.nextElement();
            this.addElement(varBind.clone());
        }
    }

    public SnmpVarBindList(String name, Vector<SnmpVarBind> list) {
        this(list);
        this.identity = name;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp tstamp) {
        this.timestamp = tstamp;
    }

    public final synchronized SnmpVarBind getVarBindAt(int pos) {
        return (SnmpVarBind)this.elementAt(pos);
    }

    public synchronized int getVarBindCount() {
        return this.size();
    }

    public synchronized Enumeration<SnmpVarBind> getVarBindList() {
        return this.elements();
    }

    public final synchronized void setVarBindList(Vector<SnmpVarBind> list) {
        this.setVarBindList(list, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setVarBindList(Vector<SnmpVarBind> list, boolean copy) {
        Vector<SnmpVarBind> vector = list;
        synchronized (vector) {
            int max = list.size();
            this.setSize(max);
            list.copyInto(this.elementData);
            if (copy) {
                for (int i = 0; i < max; ++i) {
                    SnmpVarBind avar = (SnmpVarBind)this.elementData[i];
                    this.elementData[i] = avar.clone();
                }
            }
        }
    }

    public synchronized void addVarBindList(SnmpVarBindList list) {
        this.ensureCapacity(list.size() + this.size());
        for (int i = 0; i < list.size(); ++i) {
            this.addElement(list.getVarBindAt(i));
        }
    }

    public synchronized boolean removeVarBindList(SnmpVarBindList list) {
        boolean result = true;
        for (int i = 0; i < list.size(); ++i) {
            result = this.removeElement(list.getVarBindAt(i));
        }
        return result;
    }

    public final synchronized void replaceVarBind(SnmpVarBind var, int pos) {
        this.setElementAt(var, pos);
    }

    public final synchronized void addVarBind(String[] list, String inst) throws SnmpStatusException {
        for (int i = 0; i < list.length; ++i) {
            SnmpVarBind avar = new SnmpVarBind(list[i]);
            avar.addInstance(inst);
            this.addElement(avar);
        }
    }

    public synchronized boolean removeVarBind(String[] list, String inst) throws SnmpStatusException {
        boolean result = true;
        for (int i = 0; i < list.length; ++i) {
            SnmpVarBind avar = new SnmpVarBind(list[i]);
            avar.addInstance(inst);
            int indexOid = this.indexOfOid(avar);
            try {
                this.removeElementAt(indexOid);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                result = false;
            }
        }
        return result;
    }

    public synchronized void addVarBind(String[] list) throws SnmpStatusException {
        this.addVarBind(list, null);
    }

    public synchronized boolean removeVarBind(String[] list) throws SnmpStatusException {
        return this.removeVarBind(list, null);
    }

    public synchronized void addVarBind(String name) throws SnmpStatusException {
        SnmpVarBind avar = new SnmpVarBind(name);
        this.addVarBind(avar);
    }

    public synchronized boolean removeVarBind(String name) throws SnmpStatusException {
        SnmpVarBind avar = new SnmpVarBind(name);
        int indexOid = this.indexOfOid(avar);
        try {
            this.removeElementAt(indexOid);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public synchronized void addVarBind(SnmpVarBind var) {
        this.addElement(var);
    }

    public synchronized boolean removeVarBind(SnmpVarBind var) {
        return this.removeElement(var);
    }

    public synchronized void addInstance(String inst) throws SnmpStatusException {
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            ((SnmpVarBind)this.elementData[i]).addInstance(inst);
        }
    }

    public final synchronized void concat(Vector<SnmpVarBind> list) {
        this.ensureCapacity(this.size() + list.size());
        Enumeration<SnmpVarBind> e = list.elements();
        while (e.hasMoreElements()) {
            this.addElement(e.nextElement());
        }
    }

    public synchronized boolean checkForValidValues() {
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            SnmpVarBind avar = (SnmpVarBind)this.elementData[i];
            if (avar.isValidValue()) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean checkForUnspecifiedValue() {
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            SnmpVarBind avar = (SnmpVarBind)this.elementData[i];
            if (!avar.isUnspecifiedValue()) continue;
            return true;
        }
        return false;
    }

    public synchronized SnmpVarBindList splitAt(int pos) {
        SnmpVarBindList splitVb = null;
        if (pos > this.elementCount) {
            return splitVb;
        }
        splitVb = new SnmpVarBindList();
        int max = this.size();
        for (int i = pos; i < max; ++i) {
            splitVb.addElement((SnmpVarBind)this.elementData[i]);
        }
        this.elementCount = pos;
        this.trimToSize();
        return splitVb;
    }

    public synchronized int indexOfOid(SnmpVarBind var, int min, int max) {
        SnmpOid oidarg = var.getOid();
        for (int i = min; i < max; ++i) {
            SnmpVarBind avar = (SnmpVarBind)this.elementData[i];
            if (!oidarg.equals(avar.getOid())) continue;
            return i;
        }
        return -1;
    }

    public synchronized int indexOfOid(SnmpVarBind var) {
        return this.indexOfOid(var, 0, this.size());
    }

    public synchronized int indexOfOid(SnmpOid oid) {
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            SnmpVarBind avar = (SnmpVarBind)this.elementData[i];
            if (!oid.equals(avar.getOid())) continue;
            return i;
        }
        return -1;
    }

    public synchronized SnmpVarBindList cloneWithValue() {
        SnmpVarBindList newvb = new SnmpVarBindList();
        newvb.setTimestamp(this.getTimestamp());
        newvb.ensureCapacity(this.size());
        for (int i = 0; i < this.size(); ++i) {
            SnmpVarBind avar = (SnmpVarBind)this.elementData[i];
            newvb.addElement(avar.clone());
        }
        return newvb;
    }

    public synchronized SnmpVarBindList cloneWithoutValue() {
        SnmpVarBindList newvb = new SnmpVarBindList();
        int max = this.size();
        newvb.ensureCapacity(max);
        for (int i = 0; i < max; ++i) {
            SnmpVarBind avar = (SnmpVarBind)this.elementData[i];
            newvb.addElement((SnmpVarBind)avar.cloneWithoutValue());
        }
        return newvb;
    }

    @Override
    public synchronized SnmpVarBindList clone() {
        return this.cloneWithValue();
    }

    public synchronized Vector<SnmpVarBind> toVector(boolean copy) {
        int count = this.elementCount;
        if (!copy) {
            return new Vector<SnmpVarBind>(this);
        }
        Vector<SnmpVarBind> result = new Vector<SnmpVarBind>(count, 5);
        for (int i = 0; i < count; ++i) {
            SnmpVarBind avar = (SnmpVarBind)this.elementData[i];
            result.addElement(avar.clone());
        }
        return result;
    }

    public String oidListToString() {
        StringBuilder s = new StringBuilder(300);
        for (int i = 0; i < this.elementCount; ++i) {
            SnmpVarBind avar = (SnmpVarBind)this.elementData[i];
            s.append(avar.getOid().toString()).append("\n");
        }
        return s.toString();
    }

    public synchronized String varBindListToString() {
        StringBuilder s = new StringBuilder(300);
        for (int i = 0; i < this.elementCount; ++i) {
            s.append(this.elementData[i].toString()).append("\n");
        }
        return s.toString();
    }

    protected void finalize() {
        this.removeAllElements();
    }
}

