/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SnmpErrorHandlerAgent
extends SnmpMibAgent
implements Serializable {
    private static final long serialVersionUID = 7751082923508885650L;

    @Override
    public void init() throws IllegalAccessException {
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    @Override
    public long[] getRootOid() {
        return null;
    }

    @Override
    public void get(SnmpMibRequest inRequest) throws SnmpStatusException {
        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpErrorHandlerAgent.class.getName(), "get", "Get in Exception");
        if (inRequest.getVersion() == 0) {
            throw new SnmpStatusException(2);
        }
        Enumeration<SnmpVarBind> l = inRequest.getElements();
        while (l.hasMoreElements()) {
            SnmpVarBind varbind = l.nextElement();
            varbind.setNoSuchObject();
        }
    }

    @Override
    public void check(SnmpMibRequest inRequest) throws SnmpStatusException {
        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpErrorHandlerAgent.class.getName(), "check", "Check in Exception");
        throw new SnmpStatusException(17);
    }

    @Override
    public void set(SnmpMibRequest inRequest) throws SnmpStatusException {
        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpErrorHandlerAgent.class.getName(), "set", "Set in Exception, CANNOT be called");
        throw new SnmpStatusException(17);
    }

    @Override
    public void getNext(SnmpMibRequest inRequest) throws SnmpStatusException {
        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpErrorHandlerAgent.class.getName(), "getNext", "GetNext in Exception");
        if (inRequest.getVersion() == 0) {
            throw new SnmpStatusException(2);
        }
        Enumeration<SnmpVarBind> l = inRequest.getElements();
        while (l.hasMoreElements()) {
            SnmpVarBind varbind = l.nextElement();
            varbind.setEndOfMibView();
        }
    }

    @Override
    public void getBulk(SnmpMibRequest inRequest, int nonRepeat, int maxRepeat) throws SnmpStatusException {
        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpErrorHandlerAgent.class.getName(), "getBulk", "GetBulk in Exception");
        if (inRequest.getVersion() == 0) {
            throw new SnmpStatusException(5, 0);
        }
        Enumeration<SnmpVarBind> l = inRequest.getElements();
        while (l.hasMoreElements()) {
            SnmpVarBind varbind = l.nextElement();
            varbind.setEndOfMibView();
        }
    }
}

