/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.AcmChecker;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.agent.SnmpMibNode;
import com.sun.jmx.snmp.agent.SnmpMibOid;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import com.sun.jmx.snmp.agent.SnmpMibRequestImpl;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.agent.SnmpRequestTree;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public abstract class SnmpMib
extends SnmpMibAgent
implements Serializable {
    protected SnmpMibOid root = new SnmpMibOid();
    private transient long[] rootOid = null;

    protected String getGroupOid(String groupName, String defaultOid) {
        return defaultOid;
    }

    protected ObjectName getGroupObjectName(String name, String oid, String defaultName) throws MalformedObjectNameException {
        return new ObjectName(defaultName);
    }

    protected void registerGroupNode(String groupName, String groupOid, ObjectName groupObjName, SnmpMibNode node, Object group, MBeanServer server) throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, IllegalAccessException {
        this.root.registerNode(groupOid, node);
        if (server != null && groupObjName != null && group != null) {
            server.registerMBean(group, groupObjName);
        }
    }

    public abstract void registerTableMeta(String var1, SnmpMibTable var2);

    public abstract SnmpMibTable getRegisteredTableMeta(String var1);

    @Override
    public void get(SnmpMibRequest req) throws SnmpStatusException {
        int reqType = 160;
        SnmpRequestTree handlers = this.getHandlers(req, false, false, 160);
        SnmpRequestTree.Handler h = null;
        SnmpMibNode meta = null;
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "get", "Processing handlers for GET... ");
        }
        Enumeration<SnmpRequestTree.Handler> eh = handlers.getHandlers();
        while (eh.hasMoreElements()) {
            h = eh.nextElement();
            meta = handlers.getMetaNode(h);
            int depth = handlers.getOidDepth(h);
            Enumeration<SnmpMibSubRequest> rqs = handlers.getSubRequests(h);
            while (rqs.hasMoreElements()) {
                meta.get(rqs.nextElement(), depth);
            }
        }
    }

    @Override
    public void set(SnmpMibRequest req) throws SnmpStatusException {
        SnmpRequestTree handlers = null;
        if (req instanceof SnmpMibRequestImpl) {
            handlers = ((SnmpMibRequestImpl)req).getRequestTree();
        }
        int reqType = 163;
        if (handlers == null) {
            handlers = this.getHandlers(req, false, true, 163);
        }
        handlers.switchCreationFlag(false);
        handlers.setPduType(163);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "set", "Processing handlers for SET... ");
        }
        Enumeration<SnmpRequestTree.Handler> eh = handlers.getHandlers();
        while (eh.hasMoreElements()) {
            SnmpRequestTree.Handler h = eh.nextElement();
            SnmpMibNode meta = handlers.getMetaNode(h);
            int depth = handlers.getOidDepth(h);
            Enumeration<SnmpMibSubRequest> rqs = handlers.getSubRequests(h);
            while (rqs.hasMoreElements()) {
                meta.set(rqs.nextElement(), depth);
            }
        }
    }

    @Override
    public void check(SnmpMibRequest req) throws SnmpStatusException {
        int reqType = 253;
        SnmpRequestTree handlers = this.getHandlers(req, true, true, 253);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "check", "Processing handlers for CHECK... ");
        }
        Enumeration<SnmpRequestTree.Handler> eh = handlers.getHandlers();
        while (eh.hasMoreElements()) {
            SnmpRequestTree.Handler h = eh.nextElement();
            SnmpMibNode meta = handlers.getMetaNode(h);
            int depth = handlers.getOidDepth(h);
            Enumeration<SnmpMibSubRequest> rqs = handlers.getSubRequests(h);
            while (rqs.hasMoreElements()) {
                meta.check(rqs.nextElement(), depth);
            }
        }
        if (req instanceof SnmpMibRequestImpl) {
            ((SnmpMibRequestImpl)req).setRequestTree(handlers);
        }
    }

    @Override
    public void getNext(SnmpMibRequest req) throws SnmpStatusException {
        SnmpRequestTree handlers = this.getGetNextHandlers(req);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "getNext", "Processing handlers for GET-NEXT... ");
        }
        Enumeration<SnmpRequestTree.Handler> eh = handlers.getHandlers();
        while (eh.hasMoreElements()) {
            SnmpRequestTree.Handler h = eh.nextElement();
            SnmpMibNode meta = handlers.getMetaNode(h);
            int depth = handlers.getOidDepth(h);
            Enumeration<SnmpMibSubRequest> rqs = handlers.getSubRequests(h);
            while (rqs.hasMoreElements()) {
                meta.get(rqs.nextElement(), depth);
            }
        }
    }

    @Override
    public void getBulk(SnmpMibRequest req, int nonRepeat, int maxRepeat) throws SnmpStatusException {
        this.getBulkWithGetNext(req, nonRepeat, maxRepeat);
    }

    @Override
    public long[] getRootOid() {
        if (this.rootOid == null) {
            Vector<Integer> list = new Vector<Integer>(10);
            this.root.getRootOid(list);
            this.rootOid = new long[list.size()];
            int i = 0;
            Enumeration<Integer> e = list.elements();
            while (e.hasMoreElements()) {
                Integer val = e.nextElement();
                this.rootOid[i++] = val.longValue();
            }
        }
        return (long[])this.rootOid.clone();
    }

    private SnmpRequestTree getHandlers(SnmpMibRequest req, boolean createflag, boolean atomic, int type) throws SnmpStatusException {
        SnmpRequestTree handlers = new SnmpRequestTree(req, createflag, type);
        int index = 0;
        int ver = req.getVersion();
        Enumeration<SnmpVarBind> e = req.getElements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = e.nextElement();
            try {
                this.root.findHandlingNode(var, var.oid.longValue(false), 0, handlers);
            }
            catch (SnmpStatusException x) {
                int status;
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "getHandlers", "Couldn't find a handling node for " + var.oid.toString());
                }
                if (ver == 0) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "getHandlers", "\tV1: Throwing exception");
                    }
                    SnmpStatusException sse = new SnmpStatusException(x, index + 1);
                    sse.initCause(x);
                    throw sse;
                }
                if (type == 253 || type == 163) {
                    status = SnmpRequestTree.mapSetException(x.getStatus(), ver);
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "getHandlers", "\tSET: Throwing exception");
                    }
                    SnmpStatusException sse = new SnmpStatusException(status, index + 1);
                    sse.initCause(x);
                    throw sse;
                }
                if (atomic) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "getHandlers", "\tATOMIC: Throwing exception");
                    }
                    SnmpStatusException sse = new SnmpStatusException(x, index + 1);
                    sse.initCause(x);
                    throw sse;
                }
                status = SnmpRequestTree.mapGetException(x.getStatus(), ver);
                if (status == 224) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "getHandlers", "\tGET: Registering noSuchInstance");
                    }
                    var.value = SnmpVarBind.noSuchInstance;
                }
                if (status == 225) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "getHandlers", "\tGET: Registering noSuchObject");
                    }
                    var.value = SnmpVarBind.noSuchObject;
                }
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "getHandlers", "\tGET: Registering global error: " + status);
                }
                SnmpStatusException sse = new SnmpStatusException(status, index + 1);
                sse.initCause(x);
                throw sse;
            }
            ++index;
        }
        return handlers;
    }

    private SnmpRequestTree getGetNextHandlers(SnmpMibRequest req) throws SnmpStatusException {
        SnmpRequestTree handlers = new SnmpRequestTree(req, false, 161);
        handlers.setGetNextFlag();
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "getGetNextHandlers", "Received MIB request : " + req);
        }
        AcmChecker checker = new AcmChecker(req);
        int index = 0;
        SnmpVarBind var = null;
        int ver = req.getVersion();
        Object original = null;
        Enumeration<SnmpVarBind> e = req.getElements();
        while (e.hasMoreElements()) {
            var = e.nextElement();
            try {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "getGetNextHandlers", " Next OID of : " + var.oid);
                }
                SnmpOid result = new SnmpOid(this.root.findNextHandlingNode(var, var.oid.longValue(false), 0, 0, handlers, checker));
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "getGetNextHandlers", " is : " + result);
                }
                var.oid = result;
            }
            catch (SnmpStatusException x) {
                if (ver == 0) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "getGetNextHandlers", "\tThrowing exception " + x.toString());
                    }
                    throw new SnmpStatusException(x, index + 1);
                }
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpMib.class.getName(), "getGetNextHandlers", "Exception : " + x.getStatus());
                }
                var.setSnmpValue(SnmpVarBind.endOfMibView);
            }
            ++index;
        }
        return handlers;
    }
}

