/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.AcmChecker;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpRequestTree;
import java.io.Serializable;
import java.util.Vector;

public abstract class SnmpMibNode
implements Serializable {
    protected int[] varList;

    public long getNextVarId(long id, Object userData) throws SnmpStatusException {
        return SnmpMibNode.getNextIdentifier(this.varList, id);
    }

    public long getNextVarId(long id, Object userData, int pduVersion) throws SnmpStatusException {
        long varid = id;
        while (this.skipVariable(varid = this.getNextVarId(varid, userData), userData, pduVersion)) {
        }
        return varid;
    }

    protected boolean skipVariable(long id, Object userData, int pduVersion) {
        return false;
    }

    void findHandlingNode(SnmpVarBind varbind, long[] oid, int depth, SnmpRequestTree handlers) throws SnmpStatusException {
        throw new SnmpStatusException(225);
    }

    long[] findNextHandlingNode(SnmpVarBind varbind, long[] oid, int pos, int depth, SnmpRequestTree handlers, AcmChecker checker) throws SnmpStatusException {
        throw new SnmpStatusException(225);
    }

    public abstract void get(SnmpMibSubRequest var1, int var2) throws SnmpStatusException;

    public abstract void set(SnmpMibSubRequest var1, int var2) throws SnmpStatusException;

    public abstract void check(SnmpMibSubRequest var1, int var2) throws SnmpStatusException;

    public static void sort(int[] array) {
        SnmpMibNode.QuickSort(array, 0, array.length - 1);
    }

    public void getRootOid(Vector<Integer> result) {
    }

    static void QuickSort(int[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                SnmpMibNode.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                SnmpMibNode.QuickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                SnmpMibNode.QuickSort(a, lo, hi0);
            }
        }
    }

    protected static final int getNextIdentifier(int[] table, long value) throws SnmpStatusException {
        int[] a = table;
        int val = (int)value;
        if (a == null) {
            throw new SnmpStatusException(225);
        }
        int low = 0;
        int max = a.length;
        int curr = low + (max - low) / 2;
        int elmt = 0;
        if (max < 1) {
            throw new SnmpStatusException(225);
        }
        if (a[max - 1] <= val) {
            throw new SnmpStatusException(225);
        }
        while (low <= max) {
            elmt = a[curr];
            if (val == elmt) {
                return a[++curr];
            }
            if (elmt < val) {
                low = curr + 1;
            } else {
                max = curr - 1;
            }
            curr = low + (max - low) / 2;
        }
        return a[curr];
    }

    private static final void swap(int[] a, int i, int j) {
        int T2 = a[i];
        a[i] = a[j];
        a[j] = T2;
    }
}

