/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.AcmChecker;
import com.sun.jmx.snmp.agent.SnmpMibGroup;
import com.sun.jmx.snmp.agent.SnmpMibNode;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpRequestTree;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class SnmpMibOid
extends SnmpMibNode
implements Serializable {
    private static final long serialVersionUID = 5012254771107446812L;
    private NonSyncVector<SnmpMibNode> children = new NonSyncVector(1);
    private int nbChildren = 0;

    @Override
    public void get(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        Enumeration<SnmpVarBind> e = req.getElements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = e.nextElement();
            SnmpStatusException x = new SnmpStatusException(225);
            req.registerGetException(var, x);
        }
    }

    @Override
    public void set(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        Enumeration<SnmpVarBind> e = req.getElements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = e.nextElement();
            SnmpStatusException x = new SnmpStatusException(6);
            req.registerSetException(var, x);
        }
    }

    @Override
    public void check(SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        Enumeration<SnmpVarBind> e = req.getElements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = e.nextElement();
            SnmpStatusException x = new SnmpStatusException(6);
            req.registerCheckException(var, x);
        }
    }

    @Override
    void findHandlingNode(SnmpVarBind varbind, long[] oid, int depth, SnmpRequestTree handlers) throws SnmpStatusException {
        int length = oid.length;
        Object node = null;
        if (handlers == null) {
            throw new SnmpStatusException(5);
        }
        if (depth > length) {
            throw new SnmpStatusException(225);
        }
        if (depth == length) {
            throw new SnmpStatusException(224);
        }
        SnmpMibNode child = this.getChild(oid[depth]);
        if (child == null) {
            handlers.add(this, depth, varbind);
        } else {
            child.findHandlingNode(varbind, oid, depth + 1, handlers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long[] findNextHandlingNode(SnmpVarBind varbind, long[] oid, int pos, int depth, SnmpRequestTree handlers, AcmChecker checker) throws SnmpStatusException {
        int length = oid.length;
        Object node = null;
        long[] result = null;
        if (handlers == null) {
            throw new SnmpStatusException(225);
        }
        Object data = handlers.getUserData();
        int pduVersion = handlers.getRequestPduVersion();
        if (pos >= length) {
            long[] newOid = new long[]{this.getNextVarId(-1L, data, pduVersion)};
            result = this.findNextHandlingNode(varbind, newOid, 0, depth, handlers, checker);
            return result;
        }
        long[] newOid = new long[1];
        long index = oid[pos];
        while (true) {
            try {
                SnmpMibNode child = this.getChild(index);
                if (child == null) {
                    throw new SnmpStatusException(225);
                }
                checker.add(depth, index);
                try {
                    result = child.findNextHandlingNode(varbind, oid, pos + 1, depth + 1, handlers, checker);
                }
                finally {
                    checker.remove(depth);
                }
                result[depth] = index;
                return result;
            }
            catch (SnmpStatusException e) {
                newOid[0] = index = this.getNextVarId(index, data, pduVersion);
                pos = 1;
                oid = newOid;
                continue;
            }
            break;
        }
    }

    @Override
    public void getRootOid(Vector<Integer> result) {
        if (this.nbChildren != 1) {
            return;
        }
        result.addElement(this.varList[0]);
        ((SnmpMibNode)this.children.firstElement()).getRootOid(result);
    }

    public void registerNode(String oidString, SnmpMibNode node) throws IllegalAccessException {
        SnmpOid oid = new SnmpOid(oidString);
        this.registerNode(oid.longValue(), 0, node);
    }

    void registerNode(long[] oid, int cursor, SnmpMibNode node) throws IllegalAccessException {
        if (cursor >= oid.length) {
            throw new IllegalAccessException();
        }
        long var = oid[cursor];
        int pos = this.retrieveIndex(var);
        if (pos == this.nbChildren) {
            ++this.nbChildren;
            this.varList = new int[this.nbChildren];
            this.varList[0] = (int)var;
            pos = 0;
            if (cursor + 1 == oid.length) {
                this.children.insertElementAt(node, pos);
                return;
            }
            SnmpMibOid child = new SnmpMibOid();
            this.children.insertElementAt(child, pos);
            child.registerNode(oid, cursor + 1, node);
            return;
        }
        if (pos == -1) {
            int[] tmp = new int[this.nbChildren + 1];
            tmp[this.nbChildren] = (int)var;
            System.arraycopy(this.varList, 0, tmp, 0, this.nbChildren);
            this.varList = tmp;
            ++this.nbChildren;
            SnmpMibNode.sort(this.varList);
            int newPos = this.retrieveIndex(var);
            this.varList[newPos] = (int)var;
            if (cursor + 1 == oid.length) {
                this.children.insertElementAt(node, newPos);
                return;
            }
            SnmpMibOid child = new SnmpMibOid();
            this.children.insertElementAt(child, newPos);
            child.registerNode(oid, cursor + 1, node);
        } else {
            SnmpMibNode child = (SnmpMibNode)this.children.elementAt(pos);
            if (cursor + 1 == oid.length) {
                if (child == node) {
                    return;
                }
                if (child != null && node != null) {
                    if (node instanceof SnmpMibGroup) {
                        ((SnmpMibOid)child).exportChildren((SnmpMibOid)node);
                        this.children.setElementAt(node, pos);
                        return;
                    }
                    if (node instanceof SnmpMibOid && child instanceof SnmpMibGroup) {
                        ((SnmpMibOid)node).exportChildren((SnmpMibOid)child);
                        return;
                    }
                    if (node instanceof SnmpMibOid) {
                        ((SnmpMibOid)child).exportChildren((SnmpMibOid)node);
                        this.children.setElementAt(node, pos);
                        return;
                    }
                }
                this.children.setElementAt(node, pos);
            } else {
                if (child == null) {
                    throw new IllegalAccessException();
                }
                ((SnmpMibOid)child).registerNode(oid, cursor + 1, node);
            }
        }
    }

    void exportChildren(SnmpMibOid brother) throws IllegalAccessException {
        if (brother == null) {
            return;
        }
        long[] oid = new long[1];
        for (int i = 0; i < this.nbChildren; ++i) {
            SnmpMibNode child = (SnmpMibNode)this.children.elementAt(i);
            if (child == null) continue;
            oid[0] = this.varList[i];
            brother.registerNode(oid, 0, child);
        }
    }

    SnmpMibNode getChild(long id) throws SnmpStatusException {
        int pos = this.getInsertAt(id);
        if (pos >= this.nbChildren) {
            throw new SnmpStatusException(225);
        }
        if (this.varList[pos] != (int)id) {
            throw new SnmpStatusException(225);
        }
        SnmpMibNode child = null;
        try {
            child = this.children.elementAtNonSync(pos);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(225);
        }
        if (child == null) {
            throw new SnmpStatusException(224);
        }
        return child;
    }

    private int retrieveIndex(long val) {
        int low = 0;
        int cursor = (int)val;
        if (this.varList == null || this.varList.length < 1) {
            return this.nbChildren;
        }
        int max = this.varList.length - 1;
        int curr = low + (max - low) / 2;
        while (low <= max) {
            int elmt = this.varList[curr];
            if (cursor == elmt) {
                return curr;
            }
            if (elmt < cursor) {
                low = curr + 1;
            } else {
                max = curr - 1;
            }
            curr = low + (max - low) / 2;
        }
        return -1;
    }

    private int getInsertAt(long val) {
        int low = 0;
        int index = (int)val;
        if (this.varList == null) {
            return -1;
        }
        int max = this.varList.length - 1;
        int curr = low + (max - low) / 2;
        while (low <= max) {
            int elmt = this.varList[curr];
            if (index == elmt) {
                return curr;
            }
            if (elmt < index) {
                low = curr + 1;
            } else {
                max = curr - 1;
            }
            curr = low + (max - low) / 2;
        }
        return curr;
    }

    class NonSyncVector<E>
    extends Vector<E> {
        public NonSyncVector(int size) {
            super(size);
        }

        final void addNonSyncElement(E obj) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = obj;
        }

        final E elementAtNonSync(int index) {
            return (E)this.elementData[index];
        }
    }
}

