/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.SnmpMibNode;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.logging.Level;

final class SnmpRequestTree {
    private Hashtable<Object, Handler> hashtable = null;
    private SnmpMibRequest request = null;
    private int version = 0;
    private boolean creationflag = false;
    private boolean getnextflag = false;
    private int type = 0;
    private boolean setreqflag = false;

    SnmpRequestTree(SnmpMibRequest req, boolean creationflag, int pdutype) {
        this.request = req;
        this.version = req.getVersion();
        this.creationflag = creationflag;
        this.hashtable = new Hashtable();
        this.setPduType(pdutype);
    }

    public static int mapSetException(int errorStatus, int version) throws SnmpStatusException {
        int errorCode = errorStatus;
        if (version == 0) {
            return errorCode;
        }
        int mappedErrorCode = errorCode;
        if (errorCode == 225) {
            mappedErrorCode = 17;
        } else if (errorCode == 224) {
            mappedErrorCode = 17;
        }
        return mappedErrorCode;
    }

    public static int mapGetException(int errorStatus, int version) throws SnmpStatusException {
        int errorCode = errorStatus;
        if (version == 0) {
            return errorCode;
        }
        int mappedErrorCode = errorCode;
        if (errorCode == 225) {
            mappedErrorCode = errorCode;
        } else if (errorCode == 224) {
            mappedErrorCode = errorCode;
        } else if (errorCode == 6) {
            mappedErrorCode = 224;
        } else if (errorCode == 18) {
            mappedErrorCode = 224;
        } else if (errorCode >= 7 && errorCode <= 12) {
            mappedErrorCode = 224;
        } else if (errorCode == 4) {
            mappedErrorCode = 224;
        } else if (errorCode != 16 && errorCode != 5) {
            mappedErrorCode = 225;
        }
        return mappedErrorCode;
    }

    public Object getUserData() {
        return this.request.getUserData();
    }

    public boolean isCreationAllowed() {
        return this.creationflag;
    }

    public boolean isSetRequest() {
        return this.setreqflag;
    }

    public int getVersion() {
        return this.version;
    }

    public int getRequestPduVersion() {
        return this.request.getRequestPduVersion();
    }

    public SnmpMibNode getMetaNode(Handler handler) {
        return handler.meta;
    }

    public int getOidDepth(Handler handler) {
        return handler.depth;
    }

    public Enumeration<SnmpMibSubRequest> getSubRequests(Handler handler) {
        return new Enum(this, handler);
    }

    public Enumeration<Handler> getHandlers() {
        return this.hashtable.elements();
    }

    public void add(SnmpMibNode meta, int depth, SnmpVarBind varbind) throws SnmpStatusException {
        this.registerNode(meta, depth, null, varbind, false, null);
    }

    public void add(SnmpMibNode meta, int depth, SnmpOid entryoid, SnmpVarBind varbind, boolean isnew) throws SnmpStatusException {
        this.registerNode(meta, depth, entryoid, varbind, isnew, null);
    }

    public void add(SnmpMibNode meta, int depth, SnmpOid entryoid, SnmpVarBind varbind, boolean isnew, SnmpVarBind statusvb) throws SnmpStatusException {
        this.registerNode(meta, depth, entryoid, varbind, isnew, statusvb);
    }

    void setPduType(int pduType) {
        this.type = pduType;
        this.setreqflag = pduType == 253 || pduType == 163;
    }

    void setGetNextFlag() {
        this.getnextflag = true;
    }

    void switchCreationFlag(boolean flag) {
        this.creationflag = flag;
    }

    SnmpMibSubRequest getSubRequest(Handler handler) {
        if (handler == null) {
            return null;
        }
        return new SnmpMibSubRequestImpl(this.request, handler.getSubList(), null, false, this.getnextflag, null);
    }

    SnmpMibSubRequest getSubRequest(Handler handler, SnmpOid oid) {
        if (handler == null) {
            return null;
        }
        int pos = handler.getEntryPos(oid);
        if (pos == -1) {
            return null;
        }
        return new SnmpMibSubRequestImpl(this.request, handler.getEntrySubList(pos), handler.getEntryOid(pos), handler.isNewEntry(pos), this.getnextflag, handler.getRowStatusVarBind(pos));
    }

    SnmpMibSubRequest getSubRequest(Handler handler, int entry) {
        if (handler == null) {
            return null;
        }
        return new SnmpMibSubRequestImpl(this.request, handler.getEntrySubList(entry), handler.getEntryOid(entry), handler.isNewEntry(entry), this.getnextflag, handler.getRowStatusVarBind(entry));
    }

    private void put(Object key, Handler handler) {
        if (handler == null) {
            return;
        }
        if (key == null) {
            return;
        }
        if (this.hashtable == null) {
            this.hashtable = new Hashtable();
        }
        this.hashtable.put(key, handler);
    }

    private Handler get(Object key) {
        if (key == null) {
            return null;
        }
        if (this.hashtable == null) {
            return null;
        }
        return this.hashtable.get(key);
    }

    private static int findOid(SnmpOid[] oids, int count, SnmpOid oid) {
        int size = count;
        int low = 0;
        int max = size - 1;
        int curr = low + (max - low) / 2;
        while (low <= max) {
            SnmpOid pos = oids[curr];
            int comp = oid.compareTo(pos);
            if (comp == 0) {
                return curr;
            }
            if (oid.equals(pos)) {
                return curr;
            }
            if (comp > 0) {
                low = curr + 1;
            } else {
                max = curr - 1;
            }
            curr = low + (max - low) / 2;
        }
        return -1;
    }

    private static int getInsertionPoint(SnmpOid[] oids, int count, SnmpOid oid) {
        SnmpOid[] localoids = oids;
        int size = count;
        int low = 0;
        int max = size - 1;
        int curr = low + (max - low) / 2;
        while (low <= max) {
            SnmpOid pos = localoids[curr];
            int comp = oid.compareTo(pos);
            if (comp == 0) {
                return curr;
            }
            if (comp > 0) {
                low = curr + 1;
            } else {
                max = curr - 1;
            }
            curr = low + (max - low) / 2;
        }
        return curr;
    }

    private void registerNode(SnmpMibNode meta, int depth, SnmpOid entryoid, SnmpVarBind varbind, boolean isnew, SnmpVarBind statusvb) throws SnmpStatusException {
        if (meta == null) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpRequestTree.class.getName(), "registerNode", "meta-node is null!");
            return;
        }
        if (varbind == null) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpRequestTree.class.getName(), "registerNode", "varbind is null!");
            return;
        }
        SnmpMibNode key = meta;
        Handler handler = this.get(key);
        if (handler == null) {
            handler = new Handler(this.type);
            handler.meta = meta;
            handler.depth = depth;
            this.put(key, handler);
        }
        if (entryoid == null) {
            handler.addVarbind(varbind);
        } else {
            handler.addVarbind(varbind, entryoid, isnew, statusvb);
        }
    }

    static final class Handler {
        SnmpMibNode meta;
        int depth;
        Vector<SnmpVarBind> sublist;
        SnmpOid[] entryoids = null;
        Vector<SnmpVarBind>[] entrylists = null;
        boolean[] isentrynew = null;
        SnmpVarBind[] rowstatus = null;
        int entrycount = 0;
        int entrysize = 0;
        final int type;
        private static final int Delta = 10;

        public Handler(int pduType) {
            this.type = pduType;
        }

        public void addVarbind(SnmpVarBind varbind) {
            if (this.sublist == null) {
                this.sublist = new Vector();
            }
            this.sublist.addElement(varbind);
        }

        void add(int pos, SnmpOid oid, Vector<SnmpVarBind> v, boolean isnew, SnmpVarBind statusvb) {
            if (this.entryoids == null) {
                this.entryoids = new SnmpOid[10];
                this.entrylists = new Vector[10];
                this.isentrynew = new boolean[10];
                this.rowstatus = new SnmpVarBind[10];
                this.entrysize = 10;
                pos = 0;
            } else if (pos >= this.entrysize || this.entrycount == this.entrysize) {
                SnmpOid[] olde = this.entryoids;
                Vector<SnmpVarBind>[] oldl = this.entrylists;
                boolean[] oldn = this.isentrynew;
                SnmpVarBind[] oldr = this.rowstatus;
                this.entrysize += 10;
                this.entryoids = new SnmpOid[this.entrysize];
                this.entrylists = new Vector[this.entrysize];
                this.isentrynew = new boolean[this.entrysize];
                this.rowstatus = new SnmpVarBind[this.entrysize];
                if (pos > this.entrycount) {
                    pos = this.entrycount;
                }
                if (pos < 0) {
                    pos = 0;
                }
                int l1 = pos;
                int l2 = this.entrycount - pos;
                if (l1 > 0) {
                    System.arraycopy(olde, 0, this.entryoids, 0, l1);
                    System.arraycopy(oldl, 0, this.entrylists, 0, l1);
                    System.arraycopy(oldn, 0, this.isentrynew, 0, l1);
                    System.arraycopy(oldr, 0, this.rowstatus, 0, l1);
                }
                if (l2 > 0) {
                    int l3 = l1 + 1;
                    System.arraycopy(olde, l1, this.entryoids, l3, l2);
                    System.arraycopy(oldl, l1, this.entrylists, l3, l2);
                    System.arraycopy(oldn, l1, this.isentrynew, l3, l2);
                    System.arraycopy(oldr, l1, this.rowstatus, l3, l2);
                }
            } else if (pos < this.entrycount) {
                int l1 = pos + 1;
                int l2 = this.entrycount - pos;
                System.arraycopy(this.entryoids, pos, this.entryoids, l1, l2);
                System.arraycopy(this.entrylists, pos, this.entrylists, l1, l2);
                System.arraycopy(this.isentrynew, pos, this.isentrynew, l1, l2);
                System.arraycopy(this.rowstatus, pos, this.rowstatus, l1, l2);
            }
            this.entryoids[pos] = oid;
            this.entrylists[pos] = v;
            this.isentrynew[pos] = isnew;
            this.rowstatus[pos] = statusvb;
            ++this.entrycount;
        }

        public void addVarbind(SnmpVarBind varbind, SnmpOid entryoid, boolean isnew, SnmpVarBind statusvb) throws SnmpStatusException {
            Vector<SnmpVarBind> v = null;
            SnmpVarBind rs = statusvb;
            if (this.entryoids == null) {
                v = new Vector<SnmpVarBind>();
                this.add(0, entryoid, v, isnew, rs);
            } else {
                int pos = SnmpRequestTree.getInsertionPoint(this.entryoids, this.entrycount, entryoid);
                if (pos > -1 && pos < this.entrycount && entryoid.compareTo(this.entryoids[pos]) == 0) {
                    v = this.entrylists[pos];
                    rs = this.rowstatus[pos];
                } else {
                    v = new Vector();
                    this.add(pos, entryoid, v, isnew, rs);
                }
                if (statusvb != null) {
                    if (rs != null && rs != statusvb && (this.type == 253 || this.type == 163)) {
                        throw new SnmpStatusException(12);
                    }
                    this.rowstatus[pos] = statusvb;
                }
            }
            if (statusvb != varbind) {
                v.addElement(varbind);
            }
        }

        public int getSubReqCount() {
            int count = 0;
            if (this.sublist != null) {
                ++count;
            }
            if (this.entryoids != null) {
                count += this.entrycount;
            }
            return count;
        }

        public Vector<SnmpVarBind> getSubList() {
            return this.sublist;
        }

        public int getEntryPos(SnmpOid entryoid) {
            return SnmpRequestTree.findOid(this.entryoids, this.entrycount, entryoid);
        }

        public SnmpOid getEntryOid(int pos) {
            if (this.entryoids == null) {
                return null;
            }
            if (pos == -1 || pos >= this.entrycount) {
                return null;
            }
            return this.entryoids[pos];
        }

        public boolean isNewEntry(int pos) {
            if (this.entryoids == null) {
                return false;
            }
            if (pos == -1 || pos >= this.entrycount) {
                return false;
            }
            return this.isentrynew[pos];
        }

        public SnmpVarBind getRowStatusVarBind(int pos) {
            if (this.entryoids == null) {
                return null;
            }
            if (pos == -1 || pos >= this.entrycount) {
                return null;
            }
            return this.rowstatus[pos];
        }

        public Vector<SnmpVarBind> getEntrySubList(int pos) {
            if (this.entrylists == null) {
                return null;
            }
            if (pos == -1 || pos >= this.entrycount) {
                return null;
            }
            return this.entrylists[pos];
        }

        public Iterator<SnmpOid> getEntryOids() {
            if (this.entryoids == null) {
                return null;
            }
            return Arrays.asList(this.entryoids).iterator();
        }

        public int getEntryCount() {
            if (this.entryoids == null) {
                return 0;
            }
            return this.entrycount;
        }
    }

    static final class SnmpMibSubRequestImpl
    implements SnmpMibSubRequest {
        private final Vector<SnmpVarBind> varbinds;
        private final SnmpMibRequest global;
        private final int version;
        private final boolean isnew;
        private final SnmpOid entryoid;
        private final boolean getnextflag;
        private final SnmpVarBind statusvb;

        SnmpMibSubRequestImpl(SnmpMibRequest global, Vector<SnmpVarBind> sublist, SnmpOid entryoid, boolean isnew, boolean getnextflag, SnmpVarBind rs) {
            this.global = global;
            this.varbinds = sublist;
            this.version = global.getVersion();
            this.entryoid = entryoid;
            this.isnew = isnew;
            this.getnextflag = getnextflag;
            this.statusvb = rs;
        }

        @Override
        public Enumeration<SnmpVarBind> getElements() {
            return this.varbinds.elements();
        }

        @Override
        public Vector<SnmpVarBind> getSubList() {
            return this.varbinds;
        }

        @Override
        public final int getSize() {
            if (this.varbinds == null) {
                return 0;
            }
            return this.varbinds.size();
        }

        @Override
        public void addVarBind(SnmpVarBind varbind) {
            this.varbinds.addElement(varbind);
            this.global.addVarBind(varbind);
        }

        @Override
        public boolean isNewEntry() {
            return this.isnew;
        }

        @Override
        public SnmpOid getEntryOid() {
            return this.entryoid;
        }

        @Override
        public int getVarIndex(SnmpVarBind varbind) {
            if (varbind == null) {
                return 0;
            }
            return this.global.getVarIndex(varbind);
        }

        @Override
        public Object getUserData() {
            return this.global.getUserData();
        }

        @Override
        public void registerGetException(SnmpVarBind var, SnmpStatusException exception) throws SnmpStatusException {
            if (this.version == 0) {
                throw new SnmpStatusException(exception, this.getVarIndex(var) + 1);
            }
            if (var == null) {
                throw exception;
            }
            if (this.getnextflag) {
                var.value = SnmpVarBind.endOfMibView;
                return;
            }
            int errorCode = SnmpRequestTree.mapGetException(exception.getStatus(), this.version);
            if (errorCode == 225) {
                var.value = SnmpVarBind.noSuchObject;
            } else if (errorCode == 224) {
                var.value = SnmpVarBind.noSuchInstance;
            } else {
                throw new SnmpStatusException(errorCode, this.getVarIndex(var) + 1);
            }
        }

        @Override
        public void registerSetException(SnmpVarBind var, SnmpStatusException exception) throws SnmpStatusException {
            if (this.version == 0) {
                throw new SnmpStatusException(exception, this.getVarIndex(var) + 1);
            }
            throw new SnmpStatusException(15, this.getVarIndex(var) + 1);
        }

        @Override
        public void registerCheckException(SnmpVarBind var, SnmpStatusException exception) throws SnmpStatusException {
            int mappedErrorCode;
            int errorCode = exception.getStatus();
            if (errorCode != (mappedErrorCode = SnmpRequestTree.mapSetException(errorCode, this.version))) {
                throw new SnmpStatusException(mappedErrorCode, this.getVarIndex(var) + 1);
            }
            throw new SnmpStatusException(exception, this.getVarIndex(var) + 1);
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        @Override
        public SnmpVarBind getRowStatusVarBind() {
            return this.statusvb;
        }

        @Override
        public SnmpPdu getPdu() {
            return this.global.getPdu();
        }

        @Override
        public int getRequestPduVersion() {
            return this.global.getRequestPduVersion();
        }

        @Override
        public SnmpEngine getEngine() {
            return this.global.getEngine();
        }

        @Override
        public String getPrincipal() {
            return this.global.getPrincipal();
        }

        @Override
        public int getSecurityLevel() {
            return this.global.getSecurityLevel();
        }

        @Override
        public int getSecurityModel() {
            return this.global.getSecurityModel();
        }

        @Override
        public byte[] getContextName() {
            return this.global.getContextName();
        }

        @Override
        public byte[] getAccessContextName() {
            return this.global.getAccessContextName();
        }
    }

    static final class Enum
    implements Enumeration<SnmpMibSubRequest> {
        private final Handler handler;
        private final SnmpRequestTree hlist;
        private int entry = 0;
        private int iter = 0;
        private int size = 0;

        Enum(SnmpRequestTree hlist, Handler h) {
            this.handler = h;
            this.hlist = hlist;
            this.size = h.getSubReqCount();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter < this.size;
        }

        @Override
        public SnmpMibSubRequest nextElement() throws NoSuchElementException {
            if (this.iter == 0 && this.handler.sublist != null) {
                ++this.iter;
                return this.hlist.getSubRequest(this.handler);
            }
            ++this.iter;
            if (this.iter > this.size) {
                throw new NoSuchElementException();
            }
            SnmpMibSubRequest result = this.hlist.getSubRequest(this.handler, this.entry);
            ++this.entry;
            return result;
        }
    }
}

