/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpStandardMetaServer;
import java.io.Serializable;
import java.util.Enumeration;

public class SnmpStandardObjectServer
implements Serializable {
    private static final long serialVersionUID = -4641068116505308488L;

    public void get(SnmpStandardMetaServer meta, SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        Object data = req.getUserData();
        Enumeration<SnmpVarBind> e = req.getElements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = e.nextElement();
            try {
                long id = var.oid.getOidArc(depth);
                var.value = meta.get(id, data);
            }
            catch (SnmpStatusException x) {
                req.registerGetException(var, x);
            }
        }
    }

    public void set(SnmpStandardMetaServer meta, SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        Object data = req.getUserData();
        Enumeration<SnmpVarBind> e = req.getElements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = e.nextElement();
            try {
                long id = var.oid.getOidArc(depth);
                var.value = meta.set(var.value, id, data);
            }
            catch (SnmpStatusException x) {
                req.registerSetException(var, x);
            }
        }
    }

    public void check(SnmpStandardMetaServer meta, SnmpMibSubRequest req, int depth) throws SnmpStatusException {
        Object data = req.getUserData();
        Enumeration<SnmpVarBind> e = req.getElements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = e.nextElement();
            try {
                long id = var.oid.getOidArc(depth);
                meta.check(var.value, id, data);
            }
            catch (SnmpStatusException x) {
                req.registerCheckException(var, x);
            }
        }
    }
}

