/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpIndex;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.agent.SnmpTableCallbackHandler;
import com.sun.jmx.snmp.agent.SnmpTableEntryFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public abstract class SnmpTableSupport
implements SnmpTableEntryFactory,
SnmpTableCallbackHandler,
Serializable {
    protected List<Object> entries;
    protected SnmpMibTable meta;
    protected SnmpMib theMib;
    private boolean registrationRequired = false;

    protected SnmpTableSupport(SnmpMib mib) {
        this.theMib = mib;
        this.meta = this.getRegisteredTableMeta(mib);
        this.bindWithTableMeta();
        this.entries = this.allocateTable();
    }

    @Override
    public abstract void createNewEntry(SnmpMibSubRequest var1, SnmpOid var2, int var3, SnmpMibTable var4) throws SnmpStatusException;

    public Object getEntry(int pos) {
        if (this.entries == null) {
            return null;
        }
        return this.entries.get(pos);
    }

    public int getSize() {
        return this.meta.getSize();
    }

    public void setCreationEnabled(boolean remoteCreationFlag) {
        this.meta.setCreationEnabled(remoteCreationFlag);
    }

    public boolean isCreationEnabled() {
        return this.meta.isCreationEnabled();
    }

    public boolean isRegistrationRequired() {
        return this.registrationRequired;
    }

    public SnmpIndex buildSnmpIndex(SnmpOid rowOid) throws SnmpStatusException {
        return this.buildSnmpIndex(rowOid.longValue(false), 0);
    }

    public abstract SnmpOid buildOidFromIndex(SnmpIndex var1) throws SnmpStatusException;

    public abstract ObjectName buildNameFromIndex(SnmpIndex var1) throws SnmpStatusException;

    @Override
    public void addEntryCb(int pos, SnmpOid row, ObjectName name, Object entry, SnmpMibTable meta) throws SnmpStatusException {
        try {
            if (this.entries != null) {
                this.entries.add(pos, entry);
            }
        }
        catch (Exception e) {
            throw new SnmpStatusException(2);
        }
    }

    @Override
    public void removeEntryCb(int pos, SnmpOid row, ObjectName name, Object entry, SnmpMibTable meta) throws SnmpStatusException {
        try {
            if (this.entries != null) {
                this.entries.remove(pos);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.meta.addNotificationListener(listener, filter, handback);
    }

    public synchronized void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.meta.removeNotificationListener(listener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.meta.getNotificationInfo();
    }

    protected abstract SnmpIndex buildSnmpIndex(long[] var1, int var2) throws SnmpStatusException;

    protected abstract SnmpMibTable getRegisteredTableMeta(SnmpMib var1);

    protected List<Object> allocateTable() {
        return new ArrayList<Object>();
    }

    protected void addEntry(SnmpIndex index, Object entry) throws SnmpStatusException {
        SnmpOid oid = this.buildOidFromIndex(index);
        ObjectName name = null;
        if (this.isRegistrationRequired()) {
            name = this.buildNameFromIndex(index);
        }
        this.meta.addEntry(oid, name, entry);
    }

    protected void addEntry(SnmpIndex index, ObjectName name, Object entry) throws SnmpStatusException {
        SnmpOid oid = this.buildOidFromIndex(index);
        this.meta.addEntry(oid, name, entry);
    }

    protected void removeEntry(SnmpIndex index, Object entry) throws SnmpStatusException {
        SnmpOid oid = this.buildOidFromIndex(index);
        this.meta.removeEntry(oid, entry);
    }

    protected Object[] getBasicEntries() {
        if (this.entries == null) {
            return null;
        }
        Object[] array = new Object[this.entries.size()];
        this.entries.toArray(array);
        return array;
    }

    protected void bindWithTableMeta() {
        if (this.meta == null) {
            return;
        }
        this.registrationRequired = this.meta.isRegistrationRequired();
        this.meta.registerEntryFactory(this);
    }
}

