/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.daemon.ClientHandler;
import com.sun.jmx.snmp.daemon.CommunicationException;
import com.sun.jmx.snmp.daemon.CommunicatorServerMBean;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.AttributeChangeNotification;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.MBeanServerForwarder;

public abstract class CommunicatorServer
implements Runnable,
MBeanRegistration,
NotificationBroadcaster,
CommunicatorServerMBean {
    public static final int ONLINE = 0;
    public static final int OFFLINE = 1;
    public static final int STOPPING = 2;
    public static final int STARTING = 3;
    public static final int SNMP_TYPE = 4;
    volatile transient int state = 1;
    ObjectName objectName;
    MBeanServer topMBS;
    MBeanServer bottomMBS;
    transient String dbgTag = null;
    int maxActiveClientCount = 1;
    transient int servedClientCount = 0;
    String host = null;
    int port = -1;
    private transient Object stateLock = new Object();
    private transient Vector<ClientHandler> clientHandlerVector = new Vector();
    private transient Thread mainThread = null;
    private volatile boolean stopRequested = false;
    private boolean interrupted = false;
    private transient Exception startException = null;
    private transient long notifCount = 0L;
    private transient NotificationBroadcasterSupport notifBroadcaster = new NotificationBroadcasterSupport();
    private transient MBeanNotificationInfo[] notifInfos = null;

    public CommunicatorServer(int connectorType) throws IllegalArgumentException {
        switch (connectorType) {
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid connector Type");
            }
        }
        this.dbgTag = this.makeDebugTag();
    }

    protected Thread createMainThread() {
        return new Thread((Runnable)this, this.makeThreadName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long timeout) throws CommunicationException, InterruptedException {
        boolean start;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 2) {
                this.waitState(1, 60000L);
            }
            boolean bl = start = this.state == 1;
            if (start) {
                this.changeState(3);
                this.stopRequested = false;
                this.interrupted = false;
                this.startException = null;
            }
        }
        if (!start) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "start", "Connector is not OFFLINE");
            }
            return;
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "start", "--> Start connector ");
        }
        this.mainThread = this.createMainThread();
        this.mainThread.start();
        if (timeout > 0L) {
            this.waitForStart(timeout);
        }
    }

    @Override
    public void start() {
        block2: {
            try {
                this.start(0L);
            }
            catch (InterruptedException x) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) break block2;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "start", "interrupted", x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1 || this.state == 2) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "stop", "Connector is not ONLINE");
                }
                return;
            }
            this.changeState(2);
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "stop", "Interrupt main thread");
            }
            this.stopRequested = true;
            if (!this.interrupted) {
                this.interrupted = true;
                this.mainThread.interrupt();
            }
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "stop", "terminateAllClient");
        }
        this.terminateAllClient();
        object = this.stateLock;
        synchronized (object) {
            if (this.state == 3) {
                this.changeState(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean waitState(int wantedState, long timeOut) {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitState", wantedState + "(0on,1off,2st) TO=" + timeOut + " ; current state = " + this.getStateString());
        }
        long endTime = 0L;
        if (timeOut > 0L) {
            endTime = System.currentTimeMillis() + timeOut;
        }
        Object object = this.stateLock;
        synchronized (object) {
            while (this.state != wantedState) {
                if (timeOut < 0L) {
                    if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) return false;
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitState", "timeOut < 0, return without wait");
                    return false;
                }
                try {
                    if (timeOut > 0L) {
                        long toWait = endTime - System.currentTimeMillis();
                        if (toWait <= 0L) {
                            if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) return false;
                            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitState", "timed out");
                            return false;
                        }
                        this.stateLock.wait(toWait);
                        continue;
                    }
                    this.stateLock.wait();
                }
                catch (InterruptedException e) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitState", "wait interrupted");
                    }
                    if (this.state != wantedState) return false;
                    return true;
                }
            }
            if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) return true;
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitState", "returning in desired state");
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForStart(long timeout) throws CommunicationException, InterruptedException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitForStart", "Timeout=" + timeout + " ; current state = " + this.getStateString());
        }
        long startTime = System.currentTimeMillis();
        Object object = this.stateLock;
        synchronized (object) {
            while (this.state == 3) {
                long elapsed = System.currentTimeMillis() - startTime;
                long remainingTime = timeout - elapsed;
                if (remainingTime < 0L) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitForStart", "timeout < 0, return without wait");
                    }
                    throw new InterruptedException("Timeout expired");
                }
                try {
                    this.stateLock.wait(remainingTime);
                }
                catch (InterruptedException e) {
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitForStart", "wait interrupted");
                    }
                    if (this.state == 0) continue;
                    throw e;
                }
            }
            if (this.state == 0) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitForStart", "started");
                }
                return;
            }
            if (this.startException instanceof CommunicationException) {
                throw (CommunicationException)this.startException;
            }
            if (this.startException instanceof InterruptedException) {
                throw (InterruptedException)this.startException;
            }
            if (this.startException != null) {
                throw new CommunicationException(this.startException, "Failed to start: " + this.startException);
            }
            throw new CommunicationException("Failed to start: state is " + CommunicatorServer.getStringForState(this.state));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    @Override
    public String getStateString() {
        return CommunicatorServer.getStringForState(this.state);
    }

    @Override
    public String getHost() {
        try {
            this.host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.host = "Unknown host";
        }
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPort() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPort(int port) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 3) {
                throw new IllegalStateException("Stop server before carrying out this operation");
            }
            this.port = port;
            this.dbgTag = this.makeDebugTag();
        }
    }

    @Override
    public abstract String getProtocol();

    int getServedClientCount() {
        return this.servedClientCount;
    }

    int getActiveClientCount() {
        int result = this.clientHandlerVector.size();
        return result;
    }

    int getMaxActiveClientCount() {
        return this.maxActiveClientCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxActiveClientCount(int c) throws IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 3) {
                throw new IllegalStateException("Stop server before carrying out this operation");
            }
            this.maxActiveClientCount = c;
        }
    }

    void notifyClientHandlerCreated(ClientHandler h) {
        this.clientHandlerVector.addElement(h);
    }

    synchronized void notifyClientHandlerDeleted(ClientHandler h) {
        this.clientHandlerVector.removeElement(h);
        this.notifyAll();
    }

    protected int getBindTries() {
        return 50;
    }

    protected long getBindSleepTime() {
        return 100L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int i = 0;
        boolean success = false;
        try {
            int bindRetries = this.getBindTries();
            long sleepTime = this.getBindSleepTime();
            while (i < bindRetries && !success) {
                try {
                    this.doBind();
                    success = true;
                }
                catch (CommunicationException ce) {
                    ++i;
                    Thread.sleep(sleepTime);
                }
            }
            if (!success) {
                this.doBind();
            }
        }
        catch (Exception x) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "run", "Got unexpected exception", x);
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.startException = x;
                this.changeState(1);
            }
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "run", "State is OFFLINE");
            }
            this.doError(x);
            return;
        }
        try {
            this.changeState(0);
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "run", "State is ONLINE");
            }
            while (!this.stopRequested) {
                ++this.servedClientCount;
                this.doReceive();
                this.waitIfTooManyClients();
                this.doProcess();
            }
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "run", "Stop has been requested");
            }
        }
        catch (InterruptedException x) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "run", "Interrupt caught");
            }
            this.changeState(2);
        }
        catch (Exception x) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "run", "Got unexpected exception", x);
            }
            this.changeState(2);
        }
        finally {
            Object x = this.stateLock;
            synchronized (x) {
                this.interrupted = true;
                Thread.interrupted();
            }
            try {
                this.doUnbind();
                this.waitClientTermination();
                this.changeState(1);
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "run", "State is OFFLINE");
                }
            }
            catch (Exception x2) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "run", "Got unexpected exception", x2);
                }
                this.changeState(1);
            }
        }
    }

    protected abstract void doError(Exception var1) throws CommunicationException;

    protected abstract void doBind() throws CommunicationException, InterruptedException;

    protected abstract void doReceive() throws CommunicationException, InterruptedException;

    protected abstract void doProcess() throws CommunicationException, InterruptedException;

    protected abstract void doUnbind() throws CommunicationException, InterruptedException;

    public synchronized MBeanServer getMBeanServer() {
        return this.topMBS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMBeanServer(MBeanServer newMBS) throws IllegalArgumentException, IllegalStateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 0 || this.state == 3) {
                throw new IllegalStateException("Stop server before carrying out this operation");
            }
        }
        String error = "MBeanServer argument must be MBean server where this server is registered, or an MBeanServerForwarder leading to that server";
        Vector<MBeanServer> seenMBS = new Vector<MBeanServer>();
        MBeanServer mbs = newMBS;
        while (mbs != this.bottomMBS) {
            if (!(mbs instanceof MBeanServerForwarder)) {
                throw new IllegalArgumentException("MBeanServer argument must be MBean server where this server is registered, or an MBeanServerForwarder leading to that server");
            }
            if (seenMBS.contains(mbs)) {
                throw new IllegalArgumentException("MBeanServerForwarder loop");
            }
            seenMBS.addElement(mbs);
            mbs = ((MBeanServerForwarder)mbs).getMBeanServer();
        }
        this.topMBS = newMBS;
    }

    ObjectName getObjectName() {
        return this.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeState(int newState) {
        int oldState;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == newState) {
                return;
            }
            oldState = this.state;
            this.state = newState;
            this.stateLock.notifyAll();
        }
        this.sendStateChangeNotification(oldState, newState);
    }

    String makeDebugTag() {
        return "CommunicatorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    String makeThreadName() {
        String result = this.objectName == null ? "CommunicatorServer" : this.objectName.toString();
        return result;
    }

    private synchronized void waitIfTooManyClients() throws InterruptedException {
        while (this.getActiveClientCount() >= this.maxActiveClientCount) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitIfTooManyClients", "Waiting for a client to terminate");
            }
            this.wait();
        }
    }

    private void waitClientTermination() {
        int s = this.clientHandlerVector.size();
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER) && s >= 1) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitClientTermination", "waiting for " + s + " clients to terminate");
        }
        while (!this.clientHandlerVector.isEmpty()) {
            try {
                this.clientHandlerVector.firstElement().join();
            }
            catch (NoSuchElementException x) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitClientTermination", "No elements left", x);
            }
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER) && s >= 1) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "waitClientTermination", "Ok, let's go...");
        }
    }

    private void terminateAllClient() {
        ClientHandler[] handlers;
        int s = this.clientHandlerVector.size();
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER) && s >= 1) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "terminateAllClient", "Interrupting " + s + " clients");
        }
        for (ClientHandler h : handlers = this.clientHandlerVector.toArray(new ClientHandler[0])) {
            try {
                h.interrupt();
            }
            catch (Exception x) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, this.dbgTag, "terminateAllClient", "Failed to interrupt pending request. Ignore the exception.", x);
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.stateLock = new Object();
        this.state = 1;
        this.stopRequested = false;
        this.servedClientCount = 0;
        this.clientHandlerVector = new Vector();
        this.mainThread = null;
        this.notifCount = 0L;
        this.notifInfos = null;
        this.notifBroadcaster = new NotificationBroadcasterSupport();
        this.dbgTag = this.makeDebugTag();
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "addNotificationListener", "Adding listener " + listener + " with filter " + filter + " and handback " + handback);
        }
        this.notifBroadcaster.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "removeNotificationListener", "Removing listener " + listener);
        }
        this.notifBroadcaster.removeNotificationListener(listener);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.notifInfos == null) {
            this.notifInfos = new MBeanNotificationInfo[1];
            String[] notifTypes = new String[]{"jmx.attribute.change"};
            this.notifInfos[0] = new MBeanNotificationInfo(notifTypes, AttributeChangeNotification.class.getName(), "Sent to notify that the value of the State attribute of this CommunicatorServer instance has changed.");
        }
        return (MBeanNotificationInfo[])this.notifInfos.clone();
    }

    private void sendStateChangeNotification(int oldState, int newState) {
        String oldStateString = CommunicatorServer.getStringForState(oldState);
        String newStateString = CommunicatorServer.getStringForState(newState);
        String message = new StringBuffer().append(this.dbgTag).append(" The value of attribute State has changed from ").append(oldState).append(" (").append(oldStateString).append(") to ").append(newState).append(" (").append(newStateString).append(").").toString();
        ++this.notifCount;
        AttributeChangeNotification notif = new AttributeChangeNotification(this, this.notifCount, System.currentTimeMillis(), message, "State", "int", new Integer(oldState), new Integer(newState));
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, this.dbgTag, "sendStateChangeNotification", "Sending AttributeChangeNotification #" + this.notifCount + " with message: " + message);
        }
        this.notifBroadcaster.sendNotification(notif);
    }

    private static String getStringForState(int s) {
        switch (s) {
            case 0: {
                return "ONLINE";
            }
            case 3: {
                return "STARTING";
            }
            case 1: {
                return "OFFLINE";
            }
            case 2: {
                return "STOPPING";
            }
        }
        return "UNDEFINED";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.objectName = name;
        CommunicatorServer communicatorServer = this;
        synchronized (communicatorServer) {
            if (this.bottomMBS != null) {
                throw new IllegalArgumentException("connector already registered in an MBean server");
            }
            this.topMBS = this.bottomMBS = server;
        }
        this.dbgTag = this.makeDebugTag();
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            CommunicatorServer communicatorServer = this;
            synchronized (communicatorServer) {
                this.bottomMBS = null;
                this.topMBS = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preDeregister() throws Exception {
        CommunicatorServer communicatorServer = this;
        synchronized (communicatorServer) {
            this.bottomMBS = null;
            this.topMBS = null;
        }
        this.objectName = null;
        int cstate = this.getState();
        if (cstate == 0 || cstate == 3) {
            this.stop();
        }
    }

    @Override
    public void postDeregister() {
    }
}

