/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpMessage;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpPduFactory;
import com.sun.jmx.snmp.SnmpPduPacket;
import com.sun.jmx.snmp.SnmpPduRequest;
import com.sun.jmx.snmp.SnmpPduRequestType;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpTooBigException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.SnmpVarBindList;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import com.sun.jmx.snmp.daemon.SnmpInformHandler;
import com.sun.jmx.snmp.daemon.SnmpRequestCounter;
import com.sun.jmx.snmp.daemon.SnmpSession;
import com.sun.jmx.snmp.daemon.SnmpSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;
import java.util.logging.Level;

public class SnmpInformRequest
implements SnmpDefinitions {
    private static SnmpRequestCounter requestCounter = new SnmpRequestCounter();
    private SnmpVarBindList varBindList = null;
    int errorStatus = 0;
    int errorIndex = 0;
    SnmpVarBind[] internalVarBind = null;
    String reason = null;
    private transient SnmpAdaptorServer adaptor;
    private transient SnmpSession informSession;
    private SnmpInformHandler callback = null;
    SnmpPdu requestPdu;
    SnmpPduRequestType responsePdu;
    private static final int stBase = 1;
    public static final int stInProgress = 1;
    public static final int stWaitingToSend = 3;
    public static final int stWaitingForReply = 5;
    public static final int stReceivedReply = 9;
    public static final int stAborted = 16;
    public static final int stTimeout = 32;
    public static final int stInternalError = 64;
    public static final int stResultsAvailable = 128;
    public static final int stNeverUsed = 256;
    private int numTries = 0;
    private int timeout = 3000;
    private int reqState = 256;
    private long prevPollTime = 0L;
    private long nextPollTime = 0L;
    private long waitTimeForResponse;
    private Date debugDate = new Date();
    private int requestId = 0;
    private int port = 0;
    private InetAddress address = null;
    private String communityString = null;

    SnmpInformRequest(SnmpSession session, SnmpAdaptorServer adp, InetAddress addr, String cs, int p, SnmpInformHandler requestCB) throws SnmpStatusException {
        this.informSession = session;
        this.adaptor = adp;
        this.address = addr;
        this.communityString = cs;
        this.port = p;
        this.callback = requestCB;
        this.informSession.addInformRequest(this);
        this.setTimeout(this.adaptor.getTimeout());
    }

    public final synchronized int getRequestId() {
        return this.requestId;
    }

    synchronized InetAddress getAddress() {
        return this.address;
    }

    public final synchronized int getRequestStatus() {
        return this.reqState;
    }

    public final synchronized boolean isAborted() {
        return (this.reqState & 0x10) == 16;
    }

    public final synchronized boolean inProgress() {
        return (this.reqState & 1) == 1;
    }

    public final synchronized boolean isResultAvailable() {
        return this.reqState == 128;
    }

    public final synchronized int getErrorStatus() {
        return this.errorStatus;
    }

    public final synchronized int getErrorIndex() {
        return this.errorIndex;
    }

    public final int getMaxTries() {
        return this.adaptor.getMaxTries();
    }

    public final synchronized int getNumTries() {
        return this.numTries;
    }

    final synchronized void setTimeout(int value) {
        this.timeout = value;
    }

    public final synchronized long getAbsNextPollTime() {
        return this.nextPollTime;
    }

    public final synchronized long getAbsMaxTimeToWait() {
        if (this.prevPollTime == 0L) {
            return System.currentTimeMillis();
        }
        return this.waitTimeForResponse;
    }

    public final synchronized SnmpVarBindList getResponseVarBindList() {
        if (this.inProgress()) {
            return null;
        }
        return this.varBindList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForCompletion(long time) {
        if (!this.inProgress()) {
            return true;
        }
        if (this.informSession.thisSessionContext()) {
            SnmpInformHandler savedCallback = this.callback;
            this.callback = null;
            this.informSession.waitForResponse(this, time);
            this.callback = savedCallback;
        } else {
            SnmpInformRequest snmpInformRequest = this;
            synchronized (snmpInformRequest) {
                SnmpInformHandler savedCallback = this.callback;
                try {
                    this.callback = null;
                    this.wait(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.callback = savedCallback;
            }
        }
        return !this.inProgress();
    }

    public final void cancelRequest() {
        this.errorStatus = 225;
        this.stopRequest();
        this.deleteRequest();
        this.notifyClient();
    }

    public final synchronized void notifyClient() {
        this.notifyAll();
    }

    protected void finalize() {
        this.callback = null;
        this.varBindList = null;
        this.internalVarBind = null;
        this.adaptor = null;
        this.informSession = null;
        this.requestPdu = null;
        this.responsePdu = null;
    }

    public static String snmpErrorToString(int errcode) {
        switch (errcode) {
            case 0: {
                return "noError";
            }
            case 1: {
                return "tooBig";
            }
            case 2: {
                return "noSuchName";
            }
            case 3: {
                return "badValue";
            }
            case 4: {
                return "readOnly";
            }
            case 5: {
                return "genErr";
            }
            case 6: {
                return "noAccess";
            }
            case 7: {
                return "wrongType";
            }
            case 8: {
                return "wrongLength";
            }
            case 9: {
                return "wrongEncoding";
            }
            case 10: {
                return "wrongValue";
            }
            case 11: {
                return "noCreation";
            }
            case 12: {
                return "inconsistentValue";
            }
            case 13: {
                return "resourceUnavailable";
            }
            case 14: {
                return "commitFailed";
            }
            case 15: {
                return "undoFailed";
            }
            case 16: {
                return "authorizationError";
            }
            case 17: {
                return "notWritable";
            }
            case 18: {
                return "inconsistentName";
            }
            case 224: {
                return "reqTimeout";
            }
            case 225: {
                return "reqAborted";
            }
            case 226: {
                return "rspDecodingError";
            }
            case 227: {
                return "reqEncodingError";
            }
            case 228: {
                return "reqPacketOverflow";
            }
            case 229: {
                return "rspEndOfTable";
            }
            case 230: {
                return "reqRefireAfterVbFix";
            }
            case 231: {
                return "reqHandleTooBig";
            }
            case 232: {
                return "reqTooBigImpossible";
            }
            case 240: {
                return "reqInternalError";
            }
            case 241: {
                return "reqSocketIOError";
            }
            case 242: {
                return "reqUnknownError";
            }
            case 243: {
                return "wrongSnmpVersion";
            }
            case 244: {
                return "snmpUnknownPrincipal";
            }
            case 245: {
                return "snmpAuthNotSupported";
            }
            case 246: {
                return "snmpPrivNotSupported";
            }
            case 249: {
                return "snmpBadSecurityLevel";
            }
            case 247: {
                return "snmpUsmBadEngineId";
            }
            case 248: {
                return "snmpUsmInvalidTimeliness";
            }
        }
        return "Unknown Error = " + errcode;
    }

    synchronized void start(SnmpVarBindList vblst) throws SnmpStatusException {
        if (this.inProgress()) {
            throw new SnmpStatusException("Inform request already in progress.");
        }
        this.setVarBindList(vblst);
        this.initializeAndFire();
    }

    private synchronized void initializeAndFire() {
        this.requestPdu = null;
        this.responsePdu = null;
        this.reason = null;
        this.startRequest(System.currentTimeMillis());
        this.setErrorStatusAndIndex(0, 0);
    }

    private synchronized void startRequest(long starttime) {
        this.nextPollTime = starttime;
        this.prevPollTime = 0L;
        this.schedulePoll();
    }

    private void schedulePoll() {
        this.numTries = 0;
        this.initNewRequest();
        this.setRequestStatus(3);
        this.informSession.getSnmpQManager().addRequest(this);
    }

    void action() {
        if (!this.inProgress()) {
            return;
        }
        while (true) {
            try {
                if (this.numTries == 0) {
                    this.invokeOnReady();
                } else if (this.numTries < this.getMaxTries()) {
                    this.invokeOnRetry();
                } else {
                    this.invokeOnTimeout();
                }
                return;
            }
            catch (OutOfMemoryError omerr) {
                ++this.numTries;
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "action", "Inform request hit out of memory situation...");
                }
                Thread.yield();
                continue;
            }
            break;
        }
    }

    private void invokeOnReady() {
        if (this.requestPdu == null) {
            this.requestPdu = this.constructPduPacket();
        }
        if (this.requestPdu != null && !this.sendPdu()) {
            this.queueResponse();
        }
    }

    private void invokeOnRetry() {
        this.invokeOnReady();
    }

    private void invokeOnTimeout() {
        this.errorStatus = 224;
        this.queueResponse();
    }

    private void queueResponse() {
        this.informSession.addResponse(this);
    }

    synchronized SnmpPdu constructPduPacket() {
        SnmpPduRequest reqpdu = null;
        Exception excep = null;
        try {
            reqpdu = new SnmpPduRequest();
            reqpdu.port = this.port;
            reqpdu.type = 166;
            reqpdu.version = 1;
            reqpdu.community = this.communityString.getBytes("8859_1");
            reqpdu.requestId = this.getRequestId();
            reqpdu.varBindList = this.internalVarBind;
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpInformRequest.class.getName(), "constructPduPacket", "Packet built");
            }
        }
        catch (Exception e) {
            excep = e;
            this.errorStatus = 242;
            this.reason = e.getMessage();
        }
        if (excep != null) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "constructPduPacket", "Got unexpected exception", excep);
            }
            reqpdu = null;
            this.queueResponse();
        }
        return reqpdu;
    }

    boolean sendPdu() {
        try {
            this.responsePdu = null;
            SnmpPduFactory pduFactory = this.adaptor.getPduFactory();
            SnmpMessage msg = (SnmpMessage)pduFactory.encodeSnmpPdu((SnmpPduPacket)this.requestPdu, this.adaptor.getBufferSize());
            if (msg == null) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "sendPdu", "pdu factory returned a null value");
                }
                throw new SnmpStatusException(242);
            }
            int maxPktSize = this.adaptor.getBufferSize();
            byte[] encoding = new byte[maxPktSize];
            int encodingLength = msg.encodeMessage(encoding);
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpInformRequest.class.getName(), "sendPdu", "Dump : \n" + msg.printMessage());
            }
            this.sendPduPacket(encoding, encodingLength);
            return true;
        }
        catch (SnmpTooBigException ar) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "sendPdu", "Got unexpected exception", ar);
            }
            this.setErrorStatusAndIndex(228, ar.getVarBindCount());
            this.requestPdu = null;
            this.reason = ar.getMessage();
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "sendPdu", "Packet Overflow while building inform request");
            }
        }
        catch (IOException ioe) {
            this.setErrorStatusAndIndex(241, 0);
            this.reason = ioe.getMessage();
        }
        catch (Exception e) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "sendPdu", "Got unexpected exception", e);
            }
            this.setErrorStatusAndIndex(242, 0);
            this.reason = e.getMessage();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendPduPacket(byte[] buffer, int length) throws IOException {
        SnmpSocket theSocket;
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpInformRequest.class.getName(), "sendPduPacket", "Send to peer. Peer/Port : " + this.address.getHostName() + "/" + this.port + ". Length = " + length + "\nDump : \n" + SnmpMessage.dumpHexBuffer(buffer, 0, length));
        }
        SnmpSocket snmpSocket = theSocket = this.informSession.getSocket();
        synchronized (snmpSocket) {
            theSocket.sendPacket(buffer, length, this.address, this.port);
            this.setRequestSentTime(System.currentTimeMillis());
        }
    }

    final void processResponse() {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpInformRequest.class.getName(), "processResponse", "errstatus = " + this.errorStatus);
        }
        if (!this.inProgress()) {
            this.responsePdu = null;
            return;
        }
        if (this.errorStatus >= 240) {
            this.handleInternalError("Internal Error...");
            return;
        }
        try {
            this.parsePduPacket(this.responsePdu);
            switch (this.errorStatus) {
                case 0: {
                    this.handleSuccess();
                    return;
                }
                case 224: {
                    this.handleTimeout();
                    return;
                }
                case 240: {
                    this.handleInternalError("Unknown internal error.  deal with it later!");
                    return;
                }
                case 231: {
                    this.setErrorStatusAndIndex(1, 0);
                    this.handleError("Cannot handle too-big situation...");
                    return;
                }
                case 230: {
                    this.initializeAndFire();
                    return;
                }
            }
            this.handleError("Error status set in packet...!!");
            return;
        }
        catch (Exception e) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "processResponse", "Got unexpected exception", e);
            }
            this.reason = e.getMessage();
            this.handleInternalError(this.reason);
            return;
        }
    }

    synchronized void parsePduPacket(SnmpPduRequestType rpdu) {
        if (rpdu == null) {
            return;
        }
        this.errorStatus = rpdu.getErrorStatus();
        this.errorIndex = rpdu.getErrorIndex();
        if (this.errorStatus == 0) {
            this.updateInternalVarBindWithResult(((SnmpPdu)((Object)rpdu)).varBindList);
            return;
        }
        if (this.errorStatus != 0) {
            --this.errorIndex;
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpInformRequest.class.getName(), "parsePduPacket", "received inform response. ErrorStatus/ErrorIndex = " + this.errorStatus + "/" + this.errorIndex);
        }
    }

    private void handleSuccess() {
        this.setRequestStatus(128);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpInformRequest.class.getName(), "handleSuccess", "Invoking user defined callback...");
        }
        this.deleteRequest();
        this.notifyClient();
        this.requestPdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollData(this, this.errorStatus, this.errorIndex, this.getVarBindList());
            }
        }
        catch (Exception e) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "handleSuccess", "Exception generated by user callback", e);
            }
        }
        catch (OutOfMemoryError ome) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "handleSuccess", "OutOfMemory Error generated by user callback", ome);
            }
            Thread.yield();
        }
    }

    private void handleTimeout() {
        this.setRequestStatus(32);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "handleTimeout", "Snmp error/index = " + SnmpInformRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking timeout user defined callback...");
        }
        this.deleteRequest();
        this.notifyClient();
        this.requestPdu = null;
        this.responsePdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollTimeout(this);
            }
        }
        catch (Exception e) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "handleTimeout", "Exception generated by user callback", e);
            }
        }
        catch (OutOfMemoryError ome) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "handleTimeout", "OutOfMemory Error generated by user callback", ome);
            }
            Thread.yield();
        }
    }

    private void handleError(String msg) {
        this.setRequestStatus(128);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "handleError", "Snmp error/index = " + SnmpInformRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking error user defined callback...\n" + this.getVarBindList());
        }
        this.deleteRequest();
        this.notifyClient();
        this.requestPdu = null;
        this.responsePdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollData(this, this.getErrorStatus(), this.getErrorIndex(), this.getVarBindList());
            }
        }
        catch (Exception e) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "handleError", "Exception generated by user callback", e);
            }
        }
        catch (OutOfMemoryError ome) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "handleError", "OutOfMemory Error generated by user callback", ome);
            }
            Thread.yield();
        }
    }

    private void handleInternalError(String msg) {
        this.setRequestStatus(64);
        if (this.reason == null) {
            this.reason = msg;
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "handleInternalError", "Snmp error/index = " + SnmpInformRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking internal error user defined callback...\n" + this.getVarBindList());
        }
        this.deleteRequest();
        this.notifyClient();
        this.requestPdu = null;
        this.responsePdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpInternalError(this, this.reason);
            }
        }
        catch (Exception e) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "handleInternalError", "Exception generated by user callback", e);
            }
        }
        catch (OutOfMemoryError ome) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpInformRequest.class.getName(), "handleInternalError", "OutOfMemory Error generated by user callback", ome);
            }
            Thread.yield();
        }
    }

    void updateInternalVarBindWithResult(SnmpVarBind[] list) {
        if (list == null || list.length == 0) {
            return;
        }
        int idx = 0;
        for (int i = 0; i < this.internalVarBind.length && idx < list.length; ++i) {
            SnmpVarBind avar = this.internalVarBind[i];
            if (avar == null) continue;
            SnmpVarBind res = list[idx];
            avar.setSnmpValue(res.getSnmpValue());
            ++idx;
        }
    }

    final void invokeOnResponse(Object resp) {
        if (resp != null) {
            if (resp instanceof SnmpPduRequestType) {
                this.responsePdu = (SnmpPduRequestType)resp;
            } else {
                return;
            }
        }
        this.setRequestStatus(9);
        this.queueResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopRequest() {
        SnmpInformRequest snmpInformRequest = this;
        synchronized (snmpInformRequest) {
            this.setRequestStatus(16);
        }
        this.informSession.getSnmpQManager().removeRequest(this);
        snmpInformRequest = this;
        synchronized (snmpInformRequest) {
            this.requestId = 0;
        }
    }

    final synchronized void deleteRequest() {
        this.informSession.removeInformRequest(this);
    }

    final synchronized SnmpVarBindList getVarBindList() {
        return this.varBindList;
    }

    final synchronized void setVarBindList(SnmpVarBindList newvblst) {
        this.varBindList = newvblst;
        if (this.internalVarBind == null || this.internalVarBind.length != this.varBindList.size()) {
            this.internalVarBind = new SnmpVarBind[this.varBindList.size()];
        }
        this.varBindList.copyInto(this.internalVarBind);
    }

    final synchronized void setErrorStatusAndIndex(int stat, int idx) {
        this.errorStatus = stat;
        this.errorIndex = idx;
    }

    final synchronized void setPrevPollTime(long prev) {
        this.prevPollTime = prev;
    }

    final void setRequestSentTime(long sendtime) {
        ++this.numTries;
        this.setPrevPollTime(sendtime);
        this.waitTimeForResponse = this.prevPollTime + (long)(this.timeout * this.numTries);
        this.setRequestStatus(5);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpInformRequest.class.getName(), "setRequestSentTime", "Inform request Successfully sent");
        }
        this.informSession.getSnmpQManager().addWaiting(this);
    }

    final synchronized void initNewRequest() {
        this.requestId = requestCounter.getNewId();
    }

    long timeRemainingForAction(long currtime) {
        switch (this.reqState) {
            case 3: {
                return this.nextPollTime - currtime;
            }
            case 5: {
                return this.waitTimeForResponse - currtime;
            }
        }
        return -1L;
    }

    static String statusDescription(int state) {
        switch (state) {
            case 3: {
                return "Waiting to send.";
            }
            case 5: {
                return "Waiting for reply.";
            }
            case 9: {
                return "Response arrived.";
            }
            case 16: {
                return "Aborted by user.";
            }
            case 32: {
                return "Timeout Occured.";
            }
            case 64: {
                return "Internal error.";
            }
            case 128: {
                return "Results available";
            }
            case 256: {
                return "Inform request in createAndWait state";
            }
        }
        return "Unknown inform request state.";
    }

    final synchronized void setRequestStatus(int reqst) {
        this.reqState = reqst;
    }

    public synchronized String toString() {
        StringBuffer s = new StringBuffer(300);
        s.append(this.tostring());
        s.append("\nPeer/Port : " + this.address.getHostName() + "/" + this.port);
        return s.toString();
    }

    private synchronized String tostring() {
        StringBuffer s = new StringBuffer("InformRequestId = " + this.requestId);
        s.append("   Status = " + SnmpInformRequest.statusDescription(this.reqState));
        s.append("  Timeout/MaxTries/NumTries = " + this.timeout * this.numTries + "/" + this.getMaxTries() + "/" + this.numTries);
        if (this.prevPollTime > 0L) {
            this.debugDate.setTime(this.prevPollTime);
            s.append("\nPrevPolled = " + this.debugDate.toString());
        } else {
            s.append("\nNeverPolled");
        }
        s.append(" / RemainingTime(millis) = " + this.timeRemainingForAction(System.currentTimeMillis()));
        return s.toString();
    }
}

