/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.daemon.SendQ;
import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpSendServer;
import com.sun.jmx.snmp.daemon.SnmpTimerServer;
import com.sun.jmx.snmp.daemon.WaitQ;
import java.io.Serializable;
import java.util.Vector;

final class SnmpQManager
implements Serializable {
    private static final long serialVersionUID = 2163709017015248264L;
    private SendQ newq = new SendQ(20, 5);
    private WaitQ waitq = new WaitQ(20, 5);
    private ThreadGroup queueThreadGroup = new ThreadGroup("Qmanager Thread Group");
    private Thread requestQThread = null;
    private Thread timerQThread = null;

    SnmpQManager() {
        this.startQThreads();
    }

    public void startQThreads() {
        if (this.timerQThread == null || !this.timerQThread.isAlive()) {
            this.timerQThread = new SnmpTimerServer(this.queueThreadGroup, this);
        }
        if (this.requestQThread == null || !this.requestQThread.isAlive()) {
            this.requestQThread = new SnmpSendServer(this.queueThreadGroup, this);
        }
    }

    public void stopQThreads() {
        ((SnmpTimerServer)this.timerQThread).isBeingDestroyed = true;
        this.waitq.isBeingDestroyed = true;
        ((SnmpSendServer)this.requestQThread).isBeingDestroyed = true;
        this.newq.isBeingDestroyed = true;
        if (this.timerQThread != null && this.timerQThread.isAlive()) {
            ((SnmpTimerServer)this.timerQThread).stopTimerServer();
        }
        this.waitq = null;
        this.timerQThread = null;
        if (this.requestQThread != null && this.requestQThread.isAlive()) {
            ((SnmpSendServer)this.requestQThread).stopSendServer();
        }
        this.newq = null;
        this.requestQThread = null;
    }

    public void addRequest(SnmpInformRequest reqc) {
        this.newq.addRequest(reqc);
    }

    public void addWaiting(SnmpInformRequest reqc) {
        this.waitq.addWaiting(reqc);
    }

    public Vector<SnmpInformRequest> getAllOutstandingRequest(long range) {
        return this.newq.getAllOutstandingRequest(range);
    }

    public SnmpInformRequest getTimeoutRequests() {
        return this.waitq.getTimeoutRequests();
    }

    public void removeRequest(SnmpInformRequest reqc) {
        this.newq.removeElement(reqc);
        this.waitq.removeElement(reqc);
    }

    public SnmpInformRequest removeRequest(long reqid) {
        SnmpInformRequest reqc = this.newq.removeRequest(reqid);
        if (reqc == null) {
            reqc = this.waitq.removeRequest(reqid);
        }
        return reqc;
    }
}

