/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpQManager;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;

final class SnmpSendServer
extends Thread {
    private int intervalRange = 5000;
    private Vector<SnmpInformRequest> readyPool;
    SnmpQManager snmpq = null;
    boolean isBeingDestroyed = false;

    public SnmpSendServer(ThreadGroup grp, SnmpQManager q) {
        super(grp, "SnmpSendServer");
        this.snmpq = q;
        this.start();
    }

    public synchronized void stopSendServer() {
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setPriority(5);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSendServer.class.getName(), "run", "Thread Started");
        }
        while (true) {
            try {
                do {
                    this.prepareAndSendRequest();
                } while (!this.isBeingDestroyed);
            }
            catch (Exception anye) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSendServer.class.getName(), "run", "Exception in send server", anye);
                continue;
            }
            catch (ThreadDeath td) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSendServer.class.getName(), "run", "Exiting... Fatal error");
                }
                throw td;
            }
            catch (OutOfMemoryError ome) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSendServer.class.getName(), "run", "Out of memory");
                continue;
            }
            catch (Error err) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSendServer.class.getName(), "run", "Got unexpected error", err);
                }
                throw err;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndSendRequest() {
        if (this.readyPool == null || this.readyPool.isEmpty()) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSendServer.class.getName(), "prepareAndSendRequest", "Blocking for inform requests");
            }
            this.readyPool = this.snmpq.getAllOutstandingRequest(this.intervalRange);
            if (this.isBeingDestroyed) {
                return;
            }
        } else if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSendServer.class.getName(), "prepareAndSendRequest", "Inform requests from a previous block left unprocessed. Will try again");
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSendServer.class.getName(), "prepareAndSendRequest", "List of inform requests to send : " + this.reqListToString(this.readyPool));
        }
        SnmpSendServer snmpSendServer = this;
        synchronized (snmpSendServer) {
            if (this.readyPool.size() < 2) {
                this.fireRequestList(this.readyPool);
                return;
            }
            while (!this.readyPool.isEmpty()) {
                SnmpInformRequest req = this.readyPool.lastElement();
                if (req != null && req.inProgress()) {
                    this.fireRequest(req);
                }
                this.readyPool.removeElementAt(this.readyPool.size() - 1);
            }
            this.readyPool.removeAllElements();
        }
    }

    private void fireRequest(SnmpInformRequest req) {
        if (req != null && req.inProgress()) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSendServer.class.getName(), "fireRequest", "Firing inform request directly. -> " + req.getRequestId());
            }
            req.action();
        }
    }

    private void fireRequestList(Vector<SnmpInformRequest> reqList) {
        while (!reqList.isEmpty()) {
            SnmpInformRequest req = reqList.lastElement();
            if (req != null && req.inProgress()) {
                this.fireRequest(req);
            }
            reqList.removeElementAt(reqList.size() - 1);
        }
    }

    private final String reqListToString(Vector<SnmpInformRequest> vec) {
        StringBuilder s = new StringBuilder(vec.size() * 100);
        Enumeration<SnmpInformRequest> dbge = vec.elements();
        while (dbge.hasMoreElements()) {
            SnmpInformRequest reqc = dbge.nextElement();
            s.append("InformRequestId -> ");
            s.append(reqc.getRequestId());
            s.append(" / Destination -> ");
            s.append(reqc.getAddress());
            s.append(". ");
        }
        String str = s.toString();
        return str;
    }
}

