/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBindList;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import com.sun.jmx.snmp.daemon.SnmpInformHandler;
import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpQManager;
import com.sun.jmx.snmp.daemon.SnmpResponseHandler;
import com.sun.jmx.snmp.daemon.SnmpSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;

class SnmpSession
implements SnmpDefinitions,
Runnable {
    protected transient SnmpAdaptorServer adaptor;
    protected transient SnmpSocket informSocket = null;
    private transient Hashtable<SnmpInformRequest, SnmpInformRequest> informRequestList = new Hashtable();
    private transient Stack<SnmpInformRequest> informRespq = new Stack();
    private transient Thread myThread = null;
    private transient SnmpInformRequest syncInformReq;
    SnmpQManager snmpQman = null;
    private boolean isBeingCancelled = false;

    public SnmpSession(SnmpAdaptorServer adp) throws SocketException {
        this.adaptor = adp;
        this.snmpQman = new SnmpQManager();
        SnmpResponseHandler snmpRespHdlr = new SnmpResponseHandler(adp, this.snmpQman);
        this.initialize(adp, snmpRespHdlr);
    }

    public SnmpSession() throws SocketException {
    }

    protected synchronized void initialize(SnmpAdaptorServer adp, SnmpResponseHandler snmpRespHdlr) throws SocketException {
        this.informSocket = new SnmpSocket(snmpRespHdlr, adp.getAddress(), adp.getBufferSize());
        this.myThread = new Thread((Runnable)this, "SnmpSession");
        this.myThread.start();
    }

    synchronized boolean isSessionActive() {
        return this.adaptor.isActive() && this.myThread != null && this.myThread.isAlive();
    }

    SnmpSocket getSocket() {
        return this.informSocket;
    }

    SnmpQManager getSnmpQManager() {
        return this.snmpQman;
    }

    private synchronized boolean syncInProgress() {
        return this.syncInformReq != null;
    }

    private synchronized void setSyncMode(SnmpInformRequest req) {
        this.syncInformReq = req;
    }

    private synchronized void resetSyncMode() {
        if (this.syncInformReq == null) {
            return;
        }
        this.syncInformReq = null;
        if (this.thisSessionContext()) {
            return;
        }
        this.notifyAll();
    }

    boolean thisSessionContext() {
        return Thread.currentThread() == this.myThread;
    }

    SnmpInformRequest makeAsyncRequest(InetAddress addr, String cs, SnmpInformHandler cb, SnmpVarBindList vblst, int port) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException("SNMP adaptor server not ONLINE");
        }
        SnmpInformRequest snmpreq = new SnmpInformRequest(this, this.adaptor, addr, cs, port, cb);
        snmpreq.start(vblst);
        return snmpreq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForResponse(SnmpInformRequest req, long waitTime) {
        if (!req.inProgress()) {
            return;
        }
        this.setSyncMode(req);
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSession.class.getName(), "waitForResponse", "Session switching to sync mode for inform request " + req.getRequestId());
        }
        long maxTime = waitTime <= 0L ? System.currentTimeMillis() + 6000000L : System.currentTimeMillis() + waitTime;
        while ((req.inProgress() || this.syncInProgress()) && (waitTime = maxTime - System.currentTimeMillis()) > 0L) {
            SnmpSession snmpSession = this;
            synchronized (snmpSession) {
                if (!this.informRespq.removeElement(req)) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            try {
                this.processResponse(req);
            }
            catch (Exception e) {
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSession.class.getName(), "waitForResponse", "Got unexpected exception", e);
            }
        }
        this.resetSyncMode();
    }

    @Override
    public void run() {
        this.myThread = Thread.currentThread();
        this.myThread.setPriority(5);
        SnmpInformRequest reqc = null;
        while (this.myThread != null) {
            try {
                reqc = this.nextResponse();
                if (reqc == null) continue;
                this.processResponse(reqc);
            }
            catch (ThreadDeath d) {
                this.myThread = null;
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSession.class.getName(), "run", "ThreadDeath, session thread unexpectedly shutting down");
                }
                throw d;
            }
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSession.class.getName(), "run", "Session thread shutting down");
        }
        this.myThread = null;
    }

    private void processResponse(SnmpInformRequest reqc) {
        while (reqc != null && this.myThread != null) {
            try {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSession.class.getName(), "processResponse", "Processing response to req = " + reqc.getRequestId());
                }
                reqc.processResponse();
                reqc = null;
            }
            catch (Exception e) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSession.class.getName(), "processResponse", "Got unexpected exception", e);
                }
                reqc = null;
            }
            catch (OutOfMemoryError ome) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSession.class.getName(), "processResponse", "Out of memory error in session thread", ome);
                }
                Thread.yield();
            }
        }
    }

    synchronized void addInformRequest(SnmpInformRequest snmpreq) throws SnmpStatusException {
        if (!this.isSessionActive()) {
            throw new SnmpStatusException("SNMP adaptor is not ONLINE or session is dead...");
        }
        this.informRequestList.put(snmpreq, snmpreq);
    }

    synchronized void removeInformRequest(SnmpInformRequest snmpreq) {
        if (!this.isBeingCancelled) {
            this.informRequestList.remove(snmpreq);
        }
        if (this.syncInformReq != null && this.syncInformReq == snmpreq) {
            this.resetSyncMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllRequests() {
        SnmpInformRequest[] list;
        SnmpSession snmpSession = this;
        synchronized (snmpSession) {
            if (this.informRequestList.isEmpty()) {
                return;
            }
            this.isBeingCancelled = true;
            list = new SnmpInformRequest[this.informRequestList.size()];
            Iterator<SnmpInformRequest> it = this.informRequestList.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                SnmpInformRequest req = it.next();
                list[i++] = req;
                it.remove();
            }
            this.informRequestList.clear();
        }
        for (int i = 0; i < list.length; ++i) {
            list[i].cancelRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addResponse(SnmpInformRequest reqc) {
        SnmpInformRequest snmpreq = reqc;
        if (this.isSessionActive()) {
            SnmpSession snmpSession = this;
            synchronized (snmpSession) {
                this.informRespq.push(reqc);
                this.notifyAll();
            }
        } else if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSession.class.getName(), "addResponse", "Adaptor not ONLINE or session thread dead, so inform response is dropped..." + reqc.getRequestId());
        }
    }

    private synchronized SnmpInformRequest nextResponse() {
        if (this.informRespq.isEmpty()) {
            try {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSession.class.getName(), "nextResponse", "Blocking for response");
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.informRespq.isEmpty()) {
            return null;
        }
        SnmpInformRequest reqc = (SnmpInformRequest)this.informRespq.firstElement();
        this.informRespq.removeElementAt(0);
        return reqc;
    }

    private synchronized void cancelAllResponses() {
        if (this.informRespq != null) {
            this.syncInformReq = null;
            this.informRespq.removeAllElements();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void destroySession() {
        this.cancelAllRequests();
        this.cancelAllResponses();
        SnmpSession snmpSession = this;
        synchronized (snmpSession) {
            this.informSocket.close();
            this.informSocket = null;
        }
        this.snmpQman.stopQThreads();
        this.snmpQman = null;
        this.killSessionThread();
    }

    private synchronized void killSessionThread() {
        if (this.myThread != null && this.myThread.isAlive()) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSession.class.getName(), "killSessionThread", "Destroying session");
            }
            if (!this.thisSessionContext()) {
                this.myThread = null;
                this.notifyAll();
            } else {
                this.myThread = null;
            }
        }
    }

    protected void finalize() {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSession.class.getName(), "finalize", "Shutting all servers");
        }
        if (this.informRespq != null) {
            this.informRespq.removeAllElements();
        }
        this.informRespq = null;
        if (this.informSocket != null) {
            this.informSocket.close();
        }
        this.informSocket = null;
        this.snmpQman = null;
    }
}

