/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.daemon.SnmpResponseHandler;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.logging.Level;

final class SnmpSocket
implements Runnable {
    private DatagramSocket _socket = null;
    private SnmpResponseHandler _dgramHdlr = null;
    private Thread _sockThread = null;
    private byte[] _buffer = null;
    private transient boolean isClosing = false;
    int _socketPort = 0;
    int responseBufSize = 1024;

    public SnmpSocket(SnmpResponseHandler rspHdlr, InetAddress addr, int bufferSize) throws SocketException {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSocket.class.getName(), "constructor", "Creating new SNMP datagram socket");
        }
        this._socket = new DatagramSocket(0, addr);
        this._socketPort = this._socket.getLocalPort();
        this.responseBufSize = bufferSize;
        this._buffer = new byte[this.responseBufSize];
        this._dgramHdlr = rspHdlr;
        this._sockThread = new Thread((Runnable)this, "SnmpSocket");
        this._sockThread.start();
    }

    public synchronized void sendPacket(byte[] buff, int length, InetAddress addr, int port) throws IOException {
        DatagramPacket dgrmpkt = new DatagramPacket(buff, length, addr, port);
        this.sendPacket(dgrmpkt);
    }

    public synchronized void sendPacket(DatagramPacket dgrmpkt) throws IOException {
        try {
            if (this.isValid()) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSocket.class.getName(), "sendPacket", "Sending DatagramPacket. Length = " + dgrmpkt.getLength() + " through socket = " + this._socket.toString());
                }
            } else {
                throw new IOException("Invalid state of SNMP datagram socket.");
            }
            this._socket.send(dgrmpkt);
        }
        catch (IOException e) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSocket.class.getName(), "sendPacket", "I/O error while sending", e);
            }
            throw e;
        }
    }

    public synchronized boolean isValid() {
        return this._socket != null && this._sockThread != null && this._sockThread.isAlive();
    }

    public synchronized void close() {
        this.isClosing = true;
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSocket.class.getName(), "close", "Closing and destroying the SNMP datagram socket -> " + this.toString());
        }
        try {
            DatagramSocket sn = new DatagramSocket(0);
            byte[] ob = new byte[1];
            DatagramPacket pk = new DatagramPacket(ob, 1, InetAddress.getLocalHost(), this._socketPort);
            sn.send(pk);
            sn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        }
        if (this._sockThread != null && this._sockThread.isAlive()) {
            this._sockThread.interrupt();
            try {
                this._sockThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._sockThread = null;
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setPriority(8);
        block5: while (true) {
            try {
                while (true) {
                    DatagramPacket dgrmpkt = new DatagramPacket(this._buffer, this._buffer.length);
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSocket.class.getName(), "run", "[" + Thread.currentThread().toString() + "]:Blocking for receiving packet");
                    }
                    this._socket.receive(dgrmpkt);
                    if (this.isClosing) break block5;
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSocket.class.getName(), "run", "[" + Thread.currentThread().toString() + "]:Received a packet");
                    }
                    if (dgrmpkt.getLength() <= 0) continue;
                    if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                        JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSocket.class.getName(), "run", "[" + Thread.currentThread().toString() + "]:Received a packet from : " + dgrmpkt.getAddress().toString() + ", Length = " + dgrmpkt.getLength());
                    }
                    this.handleDatagram(dgrmpkt);
                    if (this.isClosing) break;
                }
            }
            catch (IOException io) {
                if (this.isClosing) break;
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSocket.class.getName(), "run", "IOEXception while receiving datagram", io);
                continue;
            }
            catch (Exception e) {
                if (this.isClosing) break;
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSocket.class.getName(), "run", "Exception in socket thread...", e);
                continue;
            }
            catch (ThreadDeath d) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSocket.class.getName(), "run", "Socket Thread DEAD..." + this.toString(), d);
                }
                this.close();
                throw d;
            }
            catch (Error err) {
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSocket.class.getName(), "run", "Got unexpected error", err);
                }
                this.handleJavaError(err);
                continue;
            }
            break;
        }
    }

    protected synchronized void finalize() {
        this.close();
    }

    private synchronized void handleJavaError(Throwable thr) {
        if (thr instanceof OutOfMemoryError) {
            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSocket.class.getName(), "handleJavaError", "OutOfMemory error", thr);
            }
            Thread.yield();
            return;
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSocket.class.getName(), "handleJavaError", "Global Internal error");
        }
        Thread.yield();
    }

    private synchronized void handleDatagram(DatagramPacket dgrmpkt) {
        this._dgramHdlr.processDatagram(dgrmpkt);
    }
}

