/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpDefinitions;
import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.ThreadContext;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import com.sun.jmx.snmp.internal.SnmpIncomingRequest;
import java.util.Vector;
import java.util.logging.Level;

class SnmpSubRequestHandler
implements SnmpDefinitions,
Runnable {
    protected SnmpIncomingRequest incRequest = null;
    protected SnmpEngine engine = null;
    protected int version = 0;
    protected int type = 0;
    protected SnmpMibAgent agent;
    protected int errorStatus = 0;
    protected int errorIndex = -1;
    protected Vector<SnmpVarBind> varBind;
    protected int[] translation;
    protected Object data;
    private SnmpMibRequest mibRequest = null;
    private SnmpPdu reqPdu = null;

    protected SnmpSubRequestHandler(SnmpEngine engine, SnmpIncomingRequest incRequest, SnmpMibAgent agent2, SnmpPdu req) {
        this(agent2, req);
        this.init(engine, incRequest);
    }

    protected SnmpSubRequestHandler(SnmpEngine engine, SnmpIncomingRequest incRequest, SnmpMibAgent agent2, SnmpPdu req, boolean nouse) {
        this(agent2, req, nouse);
        this.init(engine, incRequest);
    }

    protected SnmpSubRequestHandler(SnmpMibAgent agent2, SnmpPdu req) {
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "constructor", "creating instance for request " + String.valueOf(req.requestId));
        }
        this.version = req.version;
        this.type = req.type;
        this.agent = agent2;
        this.reqPdu = req;
        int length = req.varBindList.length;
        this.translation = new int[length];
        this.varBind = new NonSyncVector<SnmpVarBind>(length);
    }

    protected SnmpSubRequestHandler(SnmpMibAgent agent2, SnmpPdu req, boolean nouse) {
        this(agent2, req);
        int max = this.translation.length;
        SnmpVarBind[] list = req.varBindList;
        for (int i = 0; i < max; ++i) {
            this.translation[i] = i;
            ((NonSyncVector)this.varBind).addNonSyncElement(list[i]);
        }
    }

    SnmpMibRequest createMibRequest(Vector<SnmpVarBind> vblist, int protocolVersion, Object userData) {
        if (this.type == 163 && this.mibRequest != null) {
            return this.mibRequest;
        }
        SnmpMibRequest result = null;
        result = this.incRequest != null ? SnmpMibAgent.newMibRequest(this.engine, this.reqPdu, vblist, protocolVersion, userData, this.incRequest.getPrincipal(), this.incRequest.getSecurityLevel(), this.incRequest.getSecurityModel(), this.incRequest.getContextName(), this.incRequest.getAccessContext()) : SnmpMibAgent.newMibRequest(this.reqPdu, vblist, protocolVersion, userData);
        if (this.type == 253) {
            this.mibRequest = result;
        }
        return result;
    }

    void setUserData(Object userData) {
        this.data = userData;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block19: {
            try {
                oldContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    switch (this.type) {
                        case 160: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:get operation on " + this.agent.getMibName());
                            }
                            this.agent.get(this.createMibRequest(this.varBind, this.version, this.data));
                            ** break;
lbl10:
                            // 1 sources

                            break;
                        }
                        case 161: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:getNext operation on " + this.agent.getMibName());
                            }
                            this.agent.getNext(this.createMibRequest(this.varBind, this.version, this.data));
                            ** break;
lbl16:
                            // 1 sources

                            break;
                        }
                        case 163: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:set operation on " + this.agent.getMibName());
                            }
                            this.agent.set(this.createMibRequest(this.varBind, this.version, this.data));
                            ** break;
lbl22:
                            // 1 sources

                            break;
                        }
                        case 253: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:check operation on " + this.agent.getMibName());
                            }
                            this.agent.check(this.createMibRequest(this.varBind, this.version, this.data));
                            ** break;
lbl28:
                            // 1 sources

                            break;
                        }
                        default: {
                            if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:unknown operation (" + this.type + ") on " + this.agent.getMibName());
                            }
                            this.errorStatus = 5;
                            this.errorIndex = 1;
                            break;
                        }
                    }
                }
                finally {
                    ThreadContext.restore(oldContext);
                }
            }
            catch (SnmpStatusException x) {
                this.errorStatus = x.getStatus();
                this.errorIndex = x.getErrorIndex();
                if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
                    JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:an Snmp error occurred during the operation", x);
                }
            }
            catch (Exception x) {
                this.errorStatus = 5;
                if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) break block19;
                JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:a generic error occurred during the operation", x);
            }
        }
        if (JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINER, SnmpSubRequestHandler.class.getName(), "run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    static final int mapErrorStatusToV1(int errorStatus, int reqPduType) {
        if (errorStatus == 0) {
            return 0;
        }
        if (errorStatus == 5) {
            return 5;
        }
        if (errorStatus == 2) {
            return 2;
        }
        if (errorStatus == 224 || errorStatus == 225 || errorStatus == 6 || errorStatus == 18 || errorStatus == 16) {
            return 2;
        }
        if (errorStatus == 16 || errorStatus == 17) {
            if (reqPduType == 253) {
                return 4;
            }
            return 2;
        }
        if (errorStatus == 11) {
            return 2;
        }
        if (errorStatus == 7 || errorStatus == 8 || errorStatus == 9 || errorStatus == 10 || errorStatus == 8 || errorStatus == 12) {
            if (reqPduType == 163 || reqPduType == 253) {
                return 3;
            }
            return 2;
        }
        if (errorStatus == 13 || errorStatus == 14 || errorStatus == 15) {
            return 5;
        }
        if (errorStatus == 1) {
            return 1;
        }
        if (errorStatus == 3 || errorStatus == 4) {
            if (reqPduType == 163 || reqPduType == 253) {
                return errorStatus;
            }
            return 2;
        }
        return 5;
    }

    static final int mapErrorStatusToV2(int errorStatus, int reqPduType) {
        if (errorStatus == 0) {
            return 0;
        }
        if (errorStatus == 5) {
            return 5;
        }
        if (errorStatus == 1) {
            return 1;
        }
        if (reqPduType != 163 && reqPduType != 253) {
            if (errorStatus == 16) {
                return errorStatus;
            }
            return 5;
        }
        if (errorStatus == 2) {
            return 6;
        }
        if (errorStatus == 4) {
            return 17;
        }
        if (errorStatus == 3) {
            return 10;
        }
        if (errorStatus == 6 || errorStatus == 18 || errorStatus == 16 || errorStatus == 17 || errorStatus == 11 || errorStatus == 7 || errorStatus == 8 || errorStatus == 9 || errorStatus == 10 || errorStatus == 8 || errorStatus == 12 || errorStatus == 13 || errorStatus == 14 || errorStatus == 15) {
            return errorStatus;
        }
        return 5;
    }

    static final int mapErrorStatus(int errorStatus, int protocolVersion, int reqPduType) {
        if (errorStatus == 0) {
            return 0;
        }
        if (protocolVersion == 0) {
            return SnmpSubRequestHandler.mapErrorStatusToV1(errorStatus, reqPduType);
        }
        if (protocolVersion == 1 || protocolVersion == 3) {
            return SnmpSubRequestHandler.mapErrorStatusToV2(errorStatus, reqPduType);
        }
        return 5;
    }

    protected int getErrorStatus() {
        if (this.errorStatus == 0) {
            return 0;
        }
        return SnmpSubRequestHandler.mapErrorStatus(this.errorStatus, this.version, this.type);
    }

    protected int getErrorIndex() {
        if (this.errorStatus == 0) {
            return -1;
        }
        if (this.errorIndex == 0 || this.errorIndex == -1) {
            this.errorIndex = 1;
        }
        return this.translation[this.errorIndex - 1];
    }

    protected void updateRequest(SnmpVarBind var, int pos) {
        int size = this.varBind.size();
        this.translation[size] = pos;
        this.varBind.addElement(var);
    }

    protected void updateResult(SnmpVarBind[] result) {
        if (result == null) {
            return;
        }
        int max = this.varBind.size();
        int len = result.length;
        for (int i = 0; i < max; ++i) {
            int pos = this.translation[i];
            if (pos < len) {
                result[pos] = (SnmpVarBind)((NonSyncVector)this.varBind).elementAtNonSync(i);
                continue;
            }
            if (!JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) continue;
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpSubRequestHandler.class.getName(), "updateResult", "Position `" + pos + "' is out of bound...");
        }
    }

    private void init(SnmpEngine engine, SnmpIncomingRequest incRequest) {
        this.incRequest = incRequest;
        this.engine = engine;
    }

    class NonSyncVector<E>
    extends Vector<E> {
        public NonSyncVector(int size) {
            super(size);
        }

        final void addNonSyncElement(E obj) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = obj;
        }

        final E elementAtNonSync(int index) {
            return (E)this.elementData[index];
        }
    }
}

