/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.daemon.SnmpInformRequest;
import com.sun.jmx.snmp.daemon.SnmpQManager;
import java.util.Vector;
import java.util.logging.Level;

class WaitQ
extends Vector<SnmpInformRequest> {
    boolean isBeingDestroyed = false;

    WaitQ(int initialCapacity, int capacityIncr) {
        super(initialCapacity, capacityIncr);
    }

    public synchronized void addWaiting(SnmpInformRequest req) {
        int i;
        long waitTime = req.getAbsMaxTimeToWait();
        for (i = this.size(); i > 0 && waitTime >= this.getRequestAt(i - 1).getAbsMaxTimeToWait(); --i) {
        }
        if (i == this.size()) {
            this.addElement(req);
            this.notifyClients();
        } else {
            this.insertElementAt(req, i);
        }
    }

    public synchronized boolean waitUntilReady() {
        while (!this.isBeingDestroyed) {
            long tmp = 0L;
            if (!this.isEmpty()) {
                long currTime = System.currentTimeMillis();
                SnmpInformRequest req = (SnmpInformRequest)this.lastElement();
                tmp = req.getAbsMaxTimeToWait() - currTime;
                if (tmp <= 0L) {
                    return true;
                }
            }
            this.waitOnThisQueue(tmp);
        }
        return false;
    }

    public synchronized SnmpInformRequest getTimeoutRequests() {
        if (this.waitUntilReady()) {
            SnmpInformRequest req = (SnmpInformRequest)this.lastElement();
            --this.elementCount;
            return req;
        }
        return null;
    }

    private synchronized void notifyClients() {
        this.notifyAll();
    }

    public synchronized void waitOnThisQueue(long time) {
        if (time == 0L && !this.isEmpty() && JmxProperties.SNMP_ADAPTOR_LOGGER.isLoggable(Level.FINEST)) {
            JmxProperties.SNMP_ADAPTOR_LOGGER.logp(Level.FINEST, SnmpQManager.class.getName(), "waitOnThisQueue", "[" + Thread.currentThread().toString() + "]:Fatal BUG :: Blocking on waitq permenantly. But size = " + this.size());
        }
        try {
            this.wait(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public SnmpInformRequest getRequestAt(int idx) {
        return (SnmpInformRequest)this.elementAt(idx);
    }

    public synchronized SnmpInformRequest removeRequest(long reqid) {
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            SnmpInformRequest reqc = this.getRequestAt(i);
            if (reqid != (long)reqc.getRequestId()) continue;
            this.removeElementAt(i);
            return reqc;
        }
        return null;
    }
}

