/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.internal;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.snmp.SnmpBadSecurityLevelException;
import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpEngineFactory;
import com.sun.jmx.snmp.SnmpEngineId;
import com.sun.jmx.snmp.SnmpUsmKeyHandler;
import com.sun.jmx.snmp.internal.SnmpAccessControlSubSystem;
import com.sun.jmx.snmp.internal.SnmpLcd;
import com.sun.jmx.snmp.internal.SnmpMsgProcessingSubSystem;
import com.sun.jmx.snmp.internal.SnmpSecuritySubSystem;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;

public class SnmpEngineImpl
implements SnmpEngine,
Serializable {
    private static final long serialVersionUID = -2564301391365614725L;
    public static final int noAuthNoPriv = 0;
    public static final int authNoPriv = 1;
    public static final int authPriv = 3;
    public static final int reportableFlag = 4;
    public static final int authMask = 1;
    public static final int privMask = 2;
    public static final int authPrivMask = 3;
    private SnmpEngineId engineid = null;
    private SnmpEngineFactory factory = null;
    private long startTime = 0L;
    private int boot = 0;
    private boolean checkOid = false;
    private transient SnmpUsmKeyHandler usmKeyHandler = null;
    private transient SnmpLcd lcd = null;
    private transient SnmpSecuritySubSystem securitySub = null;
    private transient SnmpMsgProcessingSubSystem messageSub = null;
    private transient SnmpAccessControlSubSystem accessSub = null;

    @Override
    public synchronized int getEngineTime() {
        long delta = System.currentTimeMillis() / 1000L - this.startTime;
        if (delta > Integer.MAX_VALUE) {
            this.startTime = System.currentTimeMillis() / 1000L;
            if (this.boot != Integer.MAX_VALUE) {
                ++this.boot;
            }
            this.storeNBBoots(this.boot);
        }
        return (int)(System.currentTimeMillis() / 1000L - this.startTime);
    }

    @Override
    public SnmpEngineId getEngineId() {
        return this.engineid;
    }

    @Override
    public SnmpUsmKeyHandler getUsmKeyHandler() {
        return this.usmKeyHandler;
    }

    public SnmpLcd getLcd() {
        return this.lcd;
    }

    @Override
    public int getEngineBoots() {
        return this.boot;
    }

    public SnmpEngineImpl(SnmpEngineFactory fact, SnmpLcd lcd, SnmpEngineId engineid) throws UnknownHostException {
        this.init(lcd, fact);
        this.initEngineID();
        if (this.engineid == null) {
            this.engineid = engineid != null ? engineid : SnmpEngineId.createEngineId();
        }
        lcd.storeEngineId(this.engineid);
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpEngineImpl.class.getName(), "SnmpEngineImpl(SnmpEngineFactory,SnmpLcd,SnmpEngineId)", "LOCAL ENGINE ID: " + this.engineid);
        }
    }

    public SnmpEngineImpl(SnmpEngineFactory fact, SnmpLcd lcd, InetAddress address, int port) throws UnknownHostException {
        this.init(lcd, fact);
        this.initEngineID();
        if (this.engineid == null) {
            this.engineid = SnmpEngineId.createEngineId(address, port);
        }
        lcd.storeEngineId(this.engineid);
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpEngineImpl.class.getName(), "SnmpEngineImpl(SnmpEngineFactory,SnmpLcd,InetAddress,int)", "LOCAL ENGINE ID: " + this.engineid + " / LOCAL ENGINE NB BOOTS: " + this.boot + " / LOCAL ENGINE START TIME: " + this.getEngineTime());
        }
    }

    public SnmpEngineImpl(SnmpEngineFactory fact, SnmpLcd lcd, int port) throws UnknownHostException {
        this.init(lcd, fact);
        this.initEngineID();
        if (this.engineid == null) {
            this.engineid = SnmpEngineId.createEngineId(port);
        }
        lcd.storeEngineId(this.engineid);
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpEngineImpl.class.getName(), "SnmpEngineImpl(SnmpEngineFactory,SnmpLcd,int)", "LOCAL ENGINE ID: " + this.engineid + " / LOCAL ENGINE NB BOOTS: " + this.boot + " / LOCAL ENGINE START TIME: " + this.getEngineTime());
        }
    }

    public SnmpEngineImpl(SnmpEngineFactory fact, SnmpLcd lcd) throws UnknownHostException {
        this.init(lcd, fact);
        this.initEngineID();
        if (this.engineid == null) {
            this.engineid = SnmpEngineId.createEngineId();
        }
        lcd.storeEngineId(this.engineid);
        if (JmxProperties.SNMP_LOGGER.isLoggable(Level.FINER)) {
            JmxProperties.SNMP_LOGGER.logp(Level.FINER, SnmpEngineImpl.class.getName(), "SnmpEngineImpl(SnmpEngineFactory,SnmpLcd)", "LOCAL ENGINE ID: " + this.engineid + " / LOCAL ENGINE NB BOOTS: " + this.boot + " / LOCAL ENGINE START TIME: " + this.getEngineTime());
        }
    }

    public synchronized void activateCheckOid() {
        this.checkOid = true;
    }

    public synchronized void deactivateCheckOid() {
        this.checkOid = false;
    }

    public synchronized boolean isCheckOidActivated() {
        return this.checkOid;
    }

    private void storeNBBoots(int boot) {
        if (boot < 0 || boot == Integer.MAX_VALUE) {
            boot = Integer.MAX_VALUE;
            this.lcd.storeEngineBoots(boot);
        } else {
            this.lcd.storeEngineBoots(boot + 1);
        }
    }

    private void init(SnmpLcd lcd, SnmpEngineFactory fact) {
        this.factory = fact;
        this.lcd = lcd;
        this.boot = lcd.getEngineBoots();
        if (this.boot == -1 || this.boot == 0) {
            this.boot = 1;
        }
        this.storeNBBoots(this.boot);
        this.startTime = System.currentTimeMillis() / 1000L;
    }

    void setUsmKeyHandler(SnmpUsmKeyHandler usmKeyHandler) {
        this.usmKeyHandler = usmKeyHandler;
    }

    private void initEngineID() throws UnknownHostException {
        String id = this.lcd.getEngineId();
        if (id != null) {
            this.engineid = SnmpEngineId.createEngineId(id);
        }
    }

    public SnmpMsgProcessingSubSystem getMsgProcessingSubSystem() {
        return this.messageSub;
    }

    public void setMsgProcessingSubSystem(SnmpMsgProcessingSubSystem sys) {
        this.messageSub = sys;
    }

    public SnmpSecuritySubSystem getSecuritySubSystem() {
        return this.securitySub;
    }

    public void setSecuritySubSystem(SnmpSecuritySubSystem sys) {
        this.securitySub = sys;
    }

    public void setAccessControlSubSystem(SnmpAccessControlSubSystem sys) {
        this.accessSub = sys;
    }

    public SnmpAccessControlSubSystem getAccessControlSubSystem() {
        return this.accessSub;
    }

    public static void checkSecurityLevel(byte msgFlags) throws SnmpBadSecurityLevelException {
        int secLevel = msgFlags & 3;
        if ((secLevel & 2) != 0 && (secLevel & 1) == 0) {
            throw new SnmpBadSecurityLevelException("Security level: noAuthPriv!!!");
        }
    }
}

