/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.cosnaming;

import com.sun.jndi.cosnaming.CNCtx;
import com.sun.jndi.toolkit.url.Uri;
import com.sun.jndi.toolkit.url.UrlUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NamingException;

public final class IiopUrl {
    private static final String PARSE_MODE_PROP = "com.sun.jndi.corbaURLParsing";
    private static final Uri.ParseMode DEFAULT_PARSE_MODE = Uri.ParseMode.COMPAT;
    public static final Uri.ParseMode PARSE_MODE;
    private static final int DEFAULT_IIOPNAME_PORT = 9999;
    private static final int DEFAULT_IIOP_PORT = 900;
    private static final String DEFAULT_HOST = "localhost";
    private Vector<Address> addresses;
    private String stringName;

    public Vector<Address> getAddresses() {
        return this.addresses;
    }

    public String getStringName() {
        return this.stringName;
    }

    public Name getCosName() throws NamingException {
        return CNCtx.parser.parse(this.stringName);
    }

    public IiopUrl(String url) throws MalformedURLException {
        int aend;
        int addrEnd;
        int slash;
        int addrStart;
        boolean oldFormat;
        if (url.startsWith("iiopname://")) {
            oldFormat = false;
            addrStart = 11;
        } else if (url.startsWith("iiop://")) {
            oldFormat = true;
            addrStart = 7;
        } else {
            throw new MalformedURLException("Invalid iiop/iiopname URL: " + url);
        }
        int smark = slash = url.indexOf(47, addrStart);
        int qmark = url.indexOf(63, addrStart);
        int fmark = url.indexOf(35, addrStart);
        if (qmark >= 0 && smark > qmark) {
            smark = -1;
        }
        if (fmark >= 0 && smark > fmark) {
            smark = -1;
        }
        if (fmark >= 0 && qmark > fmark) {
            qmark = -1;
        }
        if ((addrEnd = (aend = PARSE_MODE == Uri.ParseMode.LEGACY ? slash : (smark >= 0 ? smark : (qmark >= 0 ? qmark : fmark)))) < 0) {
            addrEnd = url.length();
            this.stringName = "";
        } else {
            this.stringName = smark < 0 && PARSE_MODE != Uri.ParseMode.LEGACY ? "" : UrlUtil.decode(url.substring(addrEnd + 1));
        }
        if (!this.stringName.isEmpty() && PARSE_MODE == Uri.ParseMode.STRICT) {
            try {
                new URI("iiop:///" + this.stringName);
            }
            catch (URISyntaxException x) {
                MalformedURLException mue = new MalformedURLException("Invalid iiop/iiopname URL: " + url);
                mue.initCause(x);
                throw mue;
            }
            if (smark < 0 && (fmark > -1 || qmark > -1)) {
                MalformedURLException mue = new MalformedURLException("Invalid iiop/iiopname URL: " + url);
                mue.initCause(new IllegalArgumentException("unexpected query or fragment"));
                throw mue;
            }
        }
        if (PARSE_MODE != Uri.ParseMode.LEGACY && aend > -1 && aend != slash) {
            MalformedURLException mue = new MalformedURLException("Invalid iiop/iiopname URL: " + url);
            mue.initCause(new IllegalArgumentException("unexpected query or fragment"));
            throw mue;
        }
        this.addresses = new Vector(3);
        try {
            if (oldFormat) {
                this.addresses.addElement(new Address(url.substring(addrStart, addrEnd), oldFormat));
            } else {
                StringTokenizer tokens = new StringTokenizer(url.substring(addrStart, addrEnd), ",");
                while (tokens.hasMoreTokens()) {
                    this.addresses.addElement(new Address(tokens.nextToken(), oldFormat));
                }
                if (this.addresses.size() == 0) {
                    this.addresses.addElement(new Address("", oldFormat));
                }
            }
        }
        catch (IllegalArgumentException x) {
            Throwable cause = x.getCause();
            if (cause instanceof URISyntaxException) {
                MalformedURLException mfue = new MalformedURLException(cause.getMessage());
                mfue.initCause(cause);
                throw mfue;
            }
            throw x;
        }
    }

    static {
        PrivilegedAction<String> action = () -> System.getProperty(PARSE_MODE_PROP, DEFAULT_PARSE_MODE.toString());
        Uri.ParseMode parseMode = DEFAULT_PARSE_MODE;
        try {
            String mode = AccessController.doPrivileged(action);
            parseMode = Uri.ParseMode.valueOf(mode.toUpperCase(Locale.ROOT));
        }
        catch (Throwable t) {
            parseMode = DEFAULT_PARSE_MODE;
        }
        finally {
            PARSE_MODE = parseMode;
        }
    }

    public static class Address {
        public int port = -1;
        public int major;
        public int minor;
        public String host;

        public Address(String hostPortVers, boolean oldFormat) throws MalformedURLException {
            int start;
            int at;
            if (oldFormat || (at = hostPortVers.indexOf(64)) < 0) {
                this.major = 1;
                this.minor = 0;
                start = 0;
            } else {
                int dot = hostPortVers.indexOf(46);
                if (dot < 0) {
                    throw new MalformedURLException("invalid version: " + hostPortVers);
                }
                try {
                    this.major = Integer.parseInt(hostPortVers.substring(0, dot));
                    this.minor = Integer.parseInt(hostPortVers.substring(dot + 1, at));
                }
                catch (NumberFormatException e) {
                    throw new MalformedURLException("Nonnumeric version: " + hostPortVers);
                }
                start = at + 1;
            }
            start = this.parse(hostPortVers, start);
            if ("".equals(this.host) || this.host == null) {
                this.host = IiopUrl.DEFAULT_HOST;
            }
            if (this.port == -1) {
                this.port = oldFormat ? 900 : 9999;
            }
        }

        private int parseLegacy(String hostPortVers, int start) {
            int slash = hostPortVers.indexOf(47, start);
            if (slash < 0) {
                slash = hostPortVers.length();
            }
            if (hostPortVers.startsWith("[", start)) {
                int brac = hostPortVers.indexOf(93, start + 1);
                if (brac < 0 || brac > slash) {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + hostPortVers);
                }
                this.host = hostPortVers.substring(start, brac + 1);
                start = brac + 1;
            } else {
                int hostEnd;
                int colon = hostPortVers.indexOf(58, start);
                int n = hostEnd = colon < 0 || colon > slash ? slash : colon;
                if (start < hostEnd) {
                    this.host = hostPortVers.substring(start, hostEnd);
                }
                start = hostEnd;
            }
            if (start + 1 < slash) {
                if (hostPortVers.startsWith(":", start)) {
                    this.port = Integer.parseInt(hostPortVers.substring(++start, slash));
                } else {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + hostPortVers);
                }
            }
            return slash;
        }

        private int parseCompat(String hostPortVers, int start) {
            int colon;
            int slash = hostPortVers.indexOf(47, start);
            if (slash < 0) {
                slash = hostPortVers.length();
            }
            if ((colon = hostPortVers.indexOf(58, start)) == start) {
                this.host = "";
                this.port = Integer.parseInt(hostPortVers.substring(start + 1, slash));
            } else if (start == slash) {
                this.host = "";
                this.port = -1;
            } else {
                URI uri = URI.create("iiop://" + hostPortVers.substring(0, slash));
                this.host = uri.getHost();
                this.port = uri.getPort();
                if (this.host == null) {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + hostPortVers);
                }
                String hostport = (this.host == null ? "" : this.host) + (this.port == -1 ? "" : ":" + this.port);
                if (!hostPortVers.substring(start, slash).equals(hostport)) {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + hostPortVers);
                }
            }
            return slash;
        }

        private int parseStrict(String hostPortVers, int start) {
            int colon;
            int slash = hostPortVers.indexOf(47, start);
            if (slash < 0) {
                slash = hostPortVers.length();
            }
            if ((colon = hostPortVers.indexOf(58, start)) == start) {
                this.host = "";
                this.port = Integer.parseInt(hostPortVers.substring(++start, slash));
                URI.create("iiop://localhost:" + this.port + hostPortVers.substring(slash));
            } else if (start == slash) {
                URI uri;
                this.host = "";
                this.port = -1;
                if (slash < hostPortVers.length() && ((uri = URI.create("iiop://" + hostPortVers.substring(slash))).getHost() != null || uri.getPort() != -1)) {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + hostPortVers);
                }
            } else {
                URI uri = URI.create("iiop://" + hostPortVers);
                this.host = uri.getHost();
                this.port = uri.getPort();
                if (this.host == null) {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + hostPortVers);
                }
                String hostport = (this.host == null ? "" : this.host) + (this.port == -1 ? "" : ":" + this.port);
                if (!hostPortVers.substring(start, slash).equals(hostport)) {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + hostPortVers);
                }
            }
            return slash;
        }

        private int parse(String hostPortVers, int start) {
            switch (PARSE_MODE) {
                case LEGACY: {
                    return this.parseLegacy(hostPortVers, start);
                }
                case STRICT: {
                    return this.parseStrict(hostPortVers, start);
                }
            }
            return this.parseCompat(hostPortVers, start);
        }
    }
}

