/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.toolkit.url.Uri;
import com.sun.jndi.toolkit.url.UrlUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.StringTokenizer;

public class DnsUrl
extends Uri {
    private static final String PARSE_MODE_PROP = "com.sun.jndi.dnsURLParsing";
    private static final Uri.ParseMode DEFAULT_PARSE_MODE = Uri.ParseMode.COMPAT;
    public static final Uri.ParseMode PARSE_MODE;
    private String domain;

    public static DnsUrl[] fromList(String urlList) throws MalformedURLException {
        DnsUrl[] urls = new DnsUrl[(urlList.length() + 1) / 2];
        int i = 0;
        StringTokenizer st = new StringTokenizer(urlList, " ");
        while (st.hasMoreTokens()) {
            try {
                urls[i++] = new DnsUrl(DnsUrl.validateURI(st.nextToken()));
            }
            catch (URISyntaxException e) {
                MalformedURLException mue = new MalformedURLException(e.getMessage());
                mue.initCause(e);
                throw mue;
            }
        }
        DnsUrl[] trimmed = new DnsUrl[i];
        System.arraycopy(urls, 0, trimmed, 0, i);
        return trimmed;
    }

    @Override
    protected Uri.ParseMode parseMode() {
        return PARSE_MODE;
    }

    @Override
    protected final boolean isSchemeOnly(String uri) {
        return DnsUrl.isDnsSchemeOnly(uri);
    }

    @Override
    protected boolean checkSchemeOnly(String uri, String scheme) {
        return uri.equals(scheme + ":") || uri.equals(scheme + "://");
    }

    @Override
    protected final MalformedURLException newInvalidURISchemeException(String uri) {
        return new MalformedURLException(uri + " is not a valid DNS pseudo-URL");
    }

    private static boolean isDnsSchemeOnly(String uri) {
        return "dns:".equals(uri) || "dns://".equals(uri);
    }

    private static String validateURI(String uri) throws URISyntaxException {
        if (PARSE_MODE == Uri.ParseMode.LEGACY) {
            return uri;
        }
        if (DnsUrl.isDnsSchemeOnly(uri)) {
            return uri;
        }
        return new URI(uri).toString();
    }

    public DnsUrl(String url) throws MalformedURLException {
        super(url);
        if (!this.scheme.equals("dns")) {
            throw this.newInvalidURISchemeException(url);
        }
        this.domain = this.path.startsWith("/") ? this.path.substring(1) : this.path;
        this.domain = this.domain.equals("") ? "." : UrlUtil.decode(this.domain);
    }

    public String getDomain() {
        return this.domain;
    }

    static {
        PrivilegedAction<String> action = () -> System.getProperty(PARSE_MODE_PROP, DEFAULT_PARSE_MODE.toString());
        Uri.ParseMode parseMode = DEFAULT_PARSE_MODE;
        try {
            String mode = AccessController.doPrivileged(action);
            parseMode = Uri.ParseMode.valueOf(mode.toUpperCase(Locale.ROOT));
        }
        catch (Throwable t) {
            parseMode = DEFAULT_PARSE_MODE;
        }
        finally {
            PARSE_MODE = parseMode;
        }
    }
}

