/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.DefaultLdapDnsProvider;
import com.sun.jndi.ldap.spi.LdapDnsProvider;
import com.sun.jndi.ldap.spi.LdapDnsProviderResult;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.naming.NamingException;
import sun.security.util.SecurityConstants;

final class LdapDnsProviderService {
    private static volatile LdapDnsProviderService service;
    private static final Object LOCK;
    private final ServiceLoader<LdapDnsProvider> providers;

    private LdapDnsProviderService() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            this.providers = ServiceLoader.load(LdapDnsProvider.class, ClassLoader.getSystemClassLoader());
        } else {
            PrivilegedAction<ServiceLoader> pa = () -> ServiceLoader.load(LdapDnsProvider.class, ClassLoader.getSystemClassLoader());
            this.providers = AccessController.doPrivileged(pa, null, new RuntimePermission("ldapDnsProvider"), SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LdapDnsProviderService getInstance() {
        if (service != null) {
            return service;
        }
        Object object = LOCK;
        synchronized (object) {
            if (service != null) {
                return service;
            }
            service = new LdapDnsProviderService();
        }
        return service;
    }

    LdapDnsProviderResult lookupEndpoints(String url, Hashtable<?, ?> env) throws NamingException {
        Iterator<LdapDnsProvider> iterator = this.providers.iterator();
        Hashtable envCopy = new Hashtable(env);
        LdapDnsProviderResult result = null;
        while (result == null && iterator.hasNext()) {
            result = iterator.next().lookupEndpoints(url, envCopy).filter(r -> r.getEndpoints().size() > 0).orElse(null);
        }
        if (result == null) {
            return new DefaultLdapDnsProvider().lookupEndpoints(url, env).orElse(new LdapDnsProviderResult("", new ArrayList<String>()));
        }
        return result;
    }

    static {
        LOCK = new int[0];
    }
}

