/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.VersionHelper;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.SharedSecrets;

final class VersionHelper12
extends VersionHelper {
    private static final String trustURLCodebase = VersionHelper12.getPrivilegedProperty("com.sun.jndi.ldap.object.trustURLCodebase", "false");
    private static final boolean trustSerialData;

    VersionHelper12() {
    }

    private static String getPrivilegedProperty(String propertyName, String defaultVal) {
        PrivilegedAction<String> action = () -> System.getProperty(propertyName, defaultVal);
        if (System.getSecurityManager() == null) {
            return action.run();
        }
        return AccessController.doPrivileged(action);
    }

    @Override
    ClassLoader getURLClassLoader(String[] url) throws MalformedURLException {
        ClassLoader parent = this.getContextClassLoader();
        if (url != null && "true".equalsIgnoreCase(trustURLCodebase)) {
            return URLClassLoader.newInstance(VersionHelper12.getUrlArray(url), parent);
        }
        return parent;
    }

    @Override
    Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader cl = this.getContextClassLoader();
        return Class.forName(className, true, cl);
    }

    @Override
    boolean isSerialDataAllowed() {
        return trustSerialData;
    }

    private ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    @Override
    Thread createThread(final Runnable r) {
        final AccessControlContext acc = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return SharedSecrets.getJavaLangAccess().newThreadWithAcc(r, acc);
            }
        });
    }

    static {
        String trustSerialDataSp = VersionHelper12.getPrivilegedProperty("com.sun.jndi.ldap.object.trustSerialData", "true");
        trustSerialData = "true".equalsIgnoreCase(trustSerialDataSp);
    }
}

