/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.pool;

import com.sun.jndi.ldap.LdapPoolManager;
import com.sun.jndi.ldap.pool.ConnectionDesc;
import com.sun.jndi.ldap.pool.Pool;
import com.sun.jndi.ldap.pool.PoolCallback;
import com.sun.jndi.ldap.pool.PooledConnection;
import com.sun.jndi.ldap.pool.PooledConnectionFactory;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;

final class Connections
implements PoolCallback {
    private static final boolean debug = Pool.debug;
    private static final boolean trace = LdapPoolManager.trace;
    private static final int DEFAULT_SIZE = 10;
    private final int initSize;
    private final int maxSize;
    private final int prefSize;
    private final List<ConnectionDesc> conns;
    private final PooledConnectionFactory factory;
    private boolean closed = false;
    private Reference<Object> ref;
    private boolean initialized = false;
    private final ReentrantLock lock;
    private final Condition connectionsAvailable;

    Connections(Object id, int initSize, int prefSize, int maxSize, PooledConnectionFactory factory, ReentrantLock lock) throws NamingException {
        this.maxSize = maxSize;
        this.lock = lock;
        this.connectionsAvailable = lock.newCondition();
        this.factory = factory;
        if (maxSize > 0) {
            this.prefSize = Math.min(prefSize, maxSize);
            this.initSize = Math.min(initSize, maxSize);
        } else {
            this.prefSize = prefSize;
            this.initSize = initSize;
        }
        this.conns = new ArrayList<ConnectionDesc>(maxSize > 0 ? maxSize : 10);
        this.initialized = initSize <= 0;
        this.ref = new SoftReference<Object>(id);
        this.d("init size=", initSize);
        this.d("max size=", maxSize);
        this.d("preferred size=", prefSize);
    }

    void waitForAvailableConnection() throws InterruptedNamingException {
        try {
            this.d("get(): waiting");
            this.connectionsAvailable.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedNamingException("Interrupted while waiting for a connection");
        }
    }

    void waitForAvailableConnection(long waitTime) throws InterruptedNamingException {
        try {
            this.d("get(): waiting");
            this.connectionsAvailable.await(waitTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new InterruptedNamingException("Interrupted while waiting for a connection");
        }
    }

    PooledConnection getAvailableConnection(long timeout) throws NamingException {
        if (!this.initialized) {
            PooledConnection conn = this.createConnection(this.factory, timeout);
            if (this.conns.size() >= this.initSize) {
                this.initialized = true;
            }
            return conn;
        }
        int size = this.conns.size();
        if (this.prefSize <= 0 || size >= this.prefSize) {
            for (ConnectionDesc connectionDesc : this.conns) {
                ConnectionDesc entry = connectionDesc;
                PooledConnection conn = entry.tryUse();
                if (conn == null) continue;
                this.d("get(): use ", conn);
                this.td("Use ", conn);
                return conn;
            }
        }
        return null;
    }

    PooledConnection createConnection(PooledConnectionFactory factory, long timeout) throws NamingException {
        int size = this.conns.size();
        if (this.maxSize == 0 || size < this.maxSize) {
            PooledConnection conn = factory.createPooledConnection(this, timeout);
            this.td("Create and use ", conn, factory);
            this.conns.add(new ConnectionDesc(conn, true));
            return conn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releasePooledConnection(PooledConnection conn) {
        this.lock.lock();
        try {
            ConnectionDesc entry = new ConnectionDesc(conn);
            int loc = this.conns.indexOf(entry);
            this.d("release(): ", conn);
            if (loc >= 0) {
                if (this.closed || this.prefSize > 0 && this.conns.size() > this.prefSize) {
                    this.d("release(): closing ", conn);
                    this.td("Close ", conn);
                    this.conns.remove(entry);
                    conn.closeConnection();
                } else {
                    this.d("release(): release ", conn);
                    this.td("Release ", conn);
                    entry = this.conns.get(loc);
                    entry.release();
                }
                this.connectionsAvailable.signalAll();
                this.d("release(): notify");
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    @Override
    public boolean removePooledConnection(PooledConnection conn) {
        this.lock.lock();
        try {
            if (this.conns.remove(new ConnectionDesc(conn))) {
                this.d("remove(): ", conn);
                this.connectionsAvailable.signalAll();
                this.d("remove(): notify");
                this.td("Remove ", conn);
                if (this.conns.isEmpty()) {
                    this.ref = null;
                }
                boolean bl = true;
                return bl;
            }
            this.d("remove(): not found ", conn);
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean expire(long threshold) {
        ArrayList<ConnectionDesc> clonedConns;
        this.lock.lock();
        try {
            clonedConns = new ArrayList<ConnectionDesc>(this.conns);
        }
        finally {
            this.lock.unlock();
        }
        ArrayList<ConnectionDesc> expired = new ArrayList<ConnectionDesc>();
        for (ConnectionDesc entry : clonedConns) {
            this.d("expire(): ", entry);
            if (!entry.expire(threshold)) continue;
            expired.add(entry);
            this.td("expire(): Expired ", entry);
        }
        this.lock.lock();
        try {
            this.conns.removeAll(expired);
            boolean bl = this.conns.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    synchronized void close() {
        this.expire(System.currentTimeMillis());
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getStats() {
        int len;
        int idle = 0;
        int busy = 0;
        int expired = 0;
        long use = 0L;
        Connections connections = this;
        synchronized (connections) {
            len = this.conns.size();
            block8: for (int i = 0; i < len; ++i) {
                ConnectionDesc entry = this.conns.get(i);
                use += entry.getUseCount();
                switch (entry.getState()) {
                    case 0: {
                        ++busy;
                        continue block8;
                    }
                    case 1: {
                        ++idle;
                        continue block8;
                    }
                    case 2: {
                        ++expired;
                    }
                }
            }
        }
        return "size=" + len + "; use=" + use + "; busy=" + busy + "; idle=" + idle + "; expired=" + expired;
    }

    boolean grabLock(long timeout) throws InterruptedNamingException {
        long start;
        long current = start = System.nanoTime();
        boolean locked = false;
        for (long remaining = timeout; !locked && remaining > 0L; remaining -= TimeUnit.NANOSECONDS.toMillis(current - start)) {
            try {
                locked = this.lock.tryLock(remaining, TimeUnit.MILLISECONDS);
                remaining -= TimeUnit.NANOSECONDS.toMillis(current - start);
            }
            catch (InterruptedException ignore) {
                throw new InterruptedNamingException("Interrupted while waiting for the connection pool lock");
            }
            current = System.nanoTime();
        }
        return locked;
    }

    void unlock() {
        this.lock.unlock();
    }

    private void d(String msg, Object o1) {
        if (debug) {
            this.d(msg + o1);
        }
    }

    private void d(String msg, int i) {
        if (debug) {
            this.d(msg + i);
        }
    }

    private void d(String msg) {
        if (debug) {
            System.err.println(this + "." + msg + "; size: " + this.conns.size());
        }
    }

    private void td(String msg, Object o1, Object o2) {
        if (trace) {
            this.td(msg + o1 + "[" + o2 + "]");
        }
    }

    private void td(String msg, Object o1) {
        if (trace) {
            this.td(msg + o1);
        }
    }

    private void td(String msg) {
        if (trace) {
            System.err.println(msg);
        }
    }
}

