/*
 * Decompiled with CFR 0.152.
 */
package com.sun.naming.internal;

import com.sun.naming.internal.VersionHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.naming.NamingEnumeration;

final class VersionHelper12
extends VersionHelper {
    private static final String TRUST_URL_CODEBASE_PROPERTY = "com.sun.jndi.ldap.object.trustURLCodebase";
    private static final String trustURLCodebase = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            try {
                return System.getProperty(VersionHelper12.TRUST_URL_CODEBASE_PROPERTY, "false");
            }
            catch (SecurityException e) {
                return "false";
            }
        }
    });

    VersionHelper12() {
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, this.getContextClassLoader());
    }

    @Override
    Class<?> loadClass(String className, boolean initialize, ClassLoader cl) throws ClassNotFoundException {
        Class<?> cls = Class.forName(className, initialize, cl);
        return cls;
    }

    @Override
    public Class<?> loadClassWithoutInit(String className) throws ClassNotFoundException {
        return this.loadClass(className, false, this.getContextClassLoader());
    }

    @Override
    Class<?> loadClass(String className, ClassLoader cl) throws ClassNotFoundException {
        return this.loadClass(className, true, cl);
    }

    @Override
    public Class<?> loadClass(String className, String codebase) throws ClassNotFoundException, MalformedURLException {
        if ("true".equalsIgnoreCase(trustURLCodebase)) {
            ClassLoader parent = this.getContextClassLoader();
            URLClassLoader cl = URLClassLoader.newInstance(VersionHelper12.getUrlArray(codebase), parent);
            return this.loadClass(className, cl);
        }
        return null;
    }

    @Override
    String getJndiProperty(final int i) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return System.getProperty(VersionHelper.PROPS[i]);
                }
                catch (SecurityException e) {
                    return null;
                }
            }
        });
    }

    @Override
    String[] getJndiProperties() {
        Properties sysProps = AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                try {
                    return System.getProperties();
                }
                catch (SecurityException e) {
                    return null;
                }
            }
        });
        if (sysProps == null) {
            return null;
        }
        String[] jProps = new String[PROPS.length];
        for (int i = 0; i < PROPS.length; ++i) {
            jProps[i] = sysProps.getProperty(PROPS[i]);
        }
        return jProps;
    }

    @Override
    InputStream getResourceAsStream(final Class<?> c, final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return c.getResourceAsStream(name);
            }
        });
    }

    @Override
    InputStream getJavaHomeLibStream(final String filename) {
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                try {
                    String javahome = System.getProperty("java.home");
                    if (javahome == null) {
                        return null;
                    }
                    String pathname = javahome + File.separator + "lib" + File.separator + filename;
                    return new FileInputStream(pathname);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    @Override
    NamingEnumeration<InputStream> getResources(final ClassLoader cl, final String name) throws IOException {
        Enumeration<URL> urls;
        try {
            urls = AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){

                @Override
                public Enumeration<URL> run() throws IOException {
                    return cl == null ? ClassLoader.getSystemResources(name) : cl.getResources(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return new InputStreamEnumeration(urls);
    }

    @Override
    ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = ClassLoader.getSystemClassLoader();
                }
                return loader;
            }
        });
    }

    class InputStreamEnumeration
    implements NamingEnumeration<InputStream> {
        private final Enumeration<URL> urls;
        private InputStream nextElement = null;

        InputStreamEnumeration(Enumeration<URL> urls) {
            this.urls = urls;
        }

        private InputStream getNextElement() {
            return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    while (InputStreamEnumeration.this.urls.hasMoreElements()) {
                        try {
                            return ((URL)InputStreamEnumeration.this.urls.nextElement()).openStream();
                        }
                        catch (IOException iOException) {
                        }
                    }
                    return null;
                }
            });
        }

        @Override
        public boolean hasMore() {
            if (this.nextElement != null) {
                return true;
            }
            this.nextElement = this.getNextElement();
            return this.nextElement != null;
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasMore();
        }

        @Override
        public InputStream next() {
            if (this.hasMore()) {
                InputStream res = this.nextElement;
                this.nextElement = null;
                return res;
            }
            throw new NoSuchElementException();
        }

        @Override
        public InputStream nextElement() {
            return this.next();
        }

        @Override
        public void close() {
        }
    }
}

