/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security;

import com.sun.org.apache.xml.internal.security.algorithms.JCEMapper;
import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolver;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import com.sun.org.apache.xml.internal.security.utils.I18n;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Init {
    public static final String CONF_NS = "http://www.xmlsecurity.org/NS/#configuration";
    private static final Logger LOG = LoggerFactory.getLogger(Init.class);
    private static boolean alreadyInitialized = false;

    public static final synchronized boolean isInitialized() {
        return alreadyInitialized;
    }

    public static synchronized void init() {
        if (alreadyInitialized) {
            return;
        }
        InputStream is = AccessController.doPrivileged(() -> {
            String cfile = System.getProperty("com.sun.org.apache.xml.internal.security.resource.config");
            if (cfile == null) {
                return null;
            }
            return Init.getResourceAsStream(cfile, Init.class);
        });
        if (is == null) {
            Init.dynamicInit();
        } else {
            Init.fileInit(is);
            try {
                is.close();
            }
            catch (IOException ex) {
                LOG.warn(ex.getMessage());
            }
        }
        alreadyInitialized = true;
    }

    private static void dynamicInit() {
        I18n.init("en", "US");
        LOG.debug("Registering default algorithms");
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws XMLSecurityException {
                    ElementProxy.registerDefaultPrefixes();
                    Transform.registerDefaultAlgorithms();
                    SignatureAlgorithm.registerDefaultAlgorithms();
                    JCEMapper.registerDefaultAlgorithms();
                    Canonicalizer.registerDefaultAlgorithms();
                    ResourceResolver.registerDefaultResolvers();
                    KeyResolver.registerDefaultResolvers();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            XMLSecurityException xse = (XMLSecurityException)ex.getException();
            LOG.error(xse.getMessage(), xse);
            xse.printStackTrace();
        }
    }

    private static void fileInit(InputStream is) {
        try {
            Node config;
            Document doc = XMLUtils.read(is, true);
            for (config = doc.getFirstChild(); config != null && !"Configuration".equals(config.getLocalName()); config = config.getNextSibling()) {
            }
            if (config == null) {
                LOG.error("Error in reading configuration file - Configuration element not found");
                return;
            }
            for (Node el = config.getFirstChild(); el != null; el = el.getNextSibling()) {
                Element[] nl;
                String description;
                ArrayList<String> classNames;
                Element[] resolverElem;
                Element[] algorithms;
                Node algorithmsNode;
                Object[] exArgs;
                String javaClass;
                String uri;
                if (1 != el.getNodeType()) continue;
                String tag = el.getLocalName();
                if ("ResourceBundles".equals(tag)) {
                    Element resource = (Element)el;
                    Element[] langAttr = resource.getAttributeNodeNS(null, "defaultLanguageCode");
                    Attr countryAttr = resource.getAttributeNodeNS(null, "defaultCountryCode");
                    String languageCode = langAttr == null ? null : langAttr.getNodeValue();
                    String countryCode = countryAttr == null ? null : countryAttr.getNodeValue();
                    I18n.init(languageCode, countryCode);
                }
                if ("CanonicalizationMethods".equals(tag)) {
                    Element[] list;
                    for (Element element : list = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "CanonicalizationMethod")) {
                        uri = element.getAttributeNS(null, "URI");
                        javaClass = element.getAttributeNS(null, "JAVACLASS");
                        try {
                            Canonicalizer.register(uri, javaClass);
                            LOG.debug("Canonicalizer.register({}, {})", uri, javaClass);
                        }
                        catch (ClassNotFoundException e) {
                            exArgs = new Object[]{uri, javaClass};
                            LOG.error(I18n.translate("algorithm.classDoesNotExist", exArgs));
                        }
                    }
                }
                if ("TransformAlgorithms".equals(tag)) {
                    Element[] tranElem;
                    for (Element element : tranElem = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "TransformAlgorithm")) {
                        uri = element.getAttributeNS(null, "URI");
                        javaClass = element.getAttributeNS(null, "JAVACLASS");
                        try {
                            Transform.register(uri, javaClass);
                            LOG.debug("Transform.register({}, {})", uri, javaClass);
                        }
                        catch (ClassNotFoundException e) {
                            exArgs = new Object[]{uri, javaClass};
                            LOG.error(I18n.translate("algorithm.classDoesNotExist", exArgs));
                        }
                        catch (NoClassDefFoundError ex) {
                            LOG.warn("Not able to found dependencies for algorithm, I'll keep working.");
                        }
                    }
                }
                if ("JCEAlgorithmMappings".equals(tag) && (algorithmsNode = ((Element)el).getElementsByTagName("Algorithms").item(0)) != null) {
                    for (Element element : algorithms = XMLUtils.selectNodes(algorithmsNode.getFirstChild(), CONF_NS, "Algorithm")) {
                        String id = element.getAttributeNS(null, "URI");
                        JCEMapper.register(id, new JCEMapper.Algorithm(element));
                    }
                }
                if ("SignatureAlgorithms".equals(tag)) {
                    Element[] sigElems;
                    algorithms = sigElems = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "SignatureAlgorithm");
                    int n = algorithms.length;
                    for (int i = 0; i < n; ++i) {
                        Element sigElem = algorithms[i];
                        uri = sigElem.getAttributeNS(null, "URI");
                        javaClass = sigElem.getAttributeNS(null, "JAVACLASS");
                        try {
                            SignatureAlgorithm.register(uri, javaClass);
                            LOG.debug("SignatureAlgorithm.register({}, {})", uri, javaClass);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            exArgs = new Object[]{uri, javaClass};
                            LOG.error(I18n.translate("algorithm.classDoesNotExist", exArgs));
                        }
                    }
                }
                if ("ResourceResolvers".equals(tag)) {
                    resolverElem = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "Resolver");
                    classNames = new ArrayList<String>(resolverElem.length);
                    for (Element element : resolverElem) {
                        javaClass = element.getAttributeNS(null, "JAVACLASS");
                        description = element.getAttributeNS(null, "DESCRIPTION");
                        if (description != null && description.length() > 0) {
                            LOG.debug("Register Resolver: {}: {}", javaClass, description);
                        } else {
                            LOG.debug("Register Resolver: {}: For unknown purposes", javaClass);
                        }
                        classNames.add(javaClass);
                    }
                    ResourceResolver.registerClassNames(classNames);
                }
                if ("KeyResolver".equals(tag)) {
                    resolverElem = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "Resolver");
                    classNames = new ArrayList(resolverElem.length);
                    for (Element element : resolverElem) {
                        javaClass = element.getAttributeNS(null, "JAVACLASS");
                        description = element.getAttributeNS(null, "DESCRIPTION");
                        if (description != null && description.length() > 0) {
                            LOG.debug("Register Resolver: {}: {}", javaClass, description);
                        } else {
                            LOG.debug("Register Resolver: {}: For unknown purposes", javaClass);
                        }
                        classNames.add(javaClass);
                    }
                    KeyResolver.registerClassNames(classNames);
                }
                if (!"PrefixMappings".equals(tag)) continue;
                LOG.debug("Now I try to bind prefixes:");
                for (Element element : nl = XMLUtils.selectNodes(el.getFirstChild(), CONF_NS, "PrefixMapping")) {
                    String namespace = element.getAttributeNS(null, "namespace");
                    String prefix = element.getAttributeNS(null, "prefix");
                    LOG.debug("Now I try to bind {} to {}", prefix, namespace);
                    ElementProxy.setDefaultPrefix(namespace, prefix);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Bad: ", e);
        }
    }

    public static URL getResource(String resourceName, Class<?> callingClass) {
        ClassLoader cl;
        ClassLoader cluClassloader;
        if (resourceName == null) {
            throw new NullPointerException();
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null && resourceName.charAt(0) == '/') {
            url = Thread.currentThread().getContextClassLoader().getResource(resourceName.substring(1));
        }
        if ((cluClassloader = Init.class.getClassLoader()) == null) {
            cluClassloader = ClassLoader.getSystemClassLoader();
        }
        if (url == null) {
            url = cluClassloader.getResource(resourceName);
        }
        if (url == null && resourceName.charAt(0) == '/') {
            url = cluClassloader.getResource(resourceName.substring(1));
        }
        if (url == null && (cl = callingClass.getClassLoader()) != null) {
            url = cl.getResource(resourceName);
        }
        if (url == null) {
            url = callingClass.getResource(resourceName);
        }
        if (url == null && resourceName.charAt(0) != '/') {
            return Init.getResource('/' + resourceName, callingClass);
        }
        return url;
    }

    private static List<URL> getResources(String resourceName, Class<?> callingClass) {
        URL url;
        ClassLoader cl;
        ClassLoader cluClassloader;
        if (resourceName == null) {
            throw new NullPointerException();
        }
        ArrayList<URL> ret = new ArrayList<URL>();
        Enumeration<URL> urls = new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public URL nextElement() {
                return null;
            }
        };
        try {
            urls = Thread.currentThread().getContextClassLoader().getResources(resourceName);
        }
        catch (IOException e) {
            LOG.debug(e.getMessage(), e);
        }
        if (!urls.hasMoreElements() && resourceName.charAt(0) == '/') {
            try {
                urls = Thread.currentThread().getContextClassLoader().getResources(resourceName.substring(1));
            }
            catch (IOException e) {
                LOG.debug(e.getMessage(), e);
            }
        }
        if ((cluClassloader = Init.class.getClassLoader()) == null) {
            cluClassloader = ClassLoader.getSystemClassLoader();
        }
        if (!urls.hasMoreElements()) {
            try {
                urls = cluClassloader.getResources(resourceName);
            }
            catch (IOException e) {
                LOG.debug(e.getMessage(), e);
            }
        }
        if (!urls.hasMoreElements() && resourceName.charAt(0) == '/') {
            try {
                urls = cluClassloader.getResources(resourceName.substring(1));
            }
            catch (IOException e) {
                LOG.debug(e.getMessage(), e);
            }
        }
        if (!urls.hasMoreElements() && (cl = callingClass.getClassLoader()) != null) {
            try {
                urls = cl.getResources(resourceName);
            }
            catch (IOException e) {
                LOG.debug(e.getMessage(), e);
            }
        }
        if (!urls.hasMoreElements() && (url = callingClass.getResource(resourceName)) != null) {
            ret.add(url);
        }
        while (urls.hasMoreElements()) {
            ret.add(urls.nextElement());
        }
        if (ret.isEmpty() && resourceName.charAt(0) != '/') {
            return Init.getResources('/' + resourceName, callingClass);
        }
        return ret;
    }

    private static InputStream getResourceAsStream(String resourceName, Class<?> callingClass) {
        URL url = Init.getResource(resourceName, callingClass);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            LOG.debug(e.getMessage(), e);
            return null;
        }
    }
}

