/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;

public class TransformXSLT
extends TransformSpi {
    static final String XSLTSpecNS = "http://www.w3.org/1999/XSL/Transform";
    static final String defaultXSLTSpecNSprefix = "xslt";
    static final String XSLTSTYLESHEET = "stylesheet";
    private static final Logger LOG = LoggerFactory.getLogger(TransformXSLT.class);

    @Override
    protected String engineGetURI() {
        return "http://www.w3.org/TR/1999/REC-xslt-19991116";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input, OutputStream baos, Element transformElement, String baseURI, boolean secureValidation) throws IOException, TransformationException {
        try {
            StreamResult outputTarget;
            StreamSource xmlSource;
            StreamSource stylesheet;
            Element xsltElement = XMLUtils.selectNode(transformElement.getFirstChild(), XSLTSpecNS, XSLTSTYLESHEET, 0);
            if (xsltElement == null) {
                xsltElement = XMLUtils.selectNode(transformElement.getFirstChild(), XSLTSpecNS, "transform", 0);
            }
            if (xsltElement == null) {
                Object[] exArgs = new Object[]{"xslt:stylesheet", "Transform"};
                throw new TransformationException("xml.WrongContent", exArgs);
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            tFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            if (secureValidation) {
                try {
                    tFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    tFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                Transformer transformer = tFactory.newTransformer();
                DOMSource source = new DOMSource(xsltElement);
                StreamResult result = new StreamResult(os);
                transformer.transform(source, result);
                stylesheet = new StreamSource(new ByteArrayInputStream(os.toByteArray()));
            }
            Transformer transformer = tFactory.newTransformer(stylesheet);
            try {
                transformer.setOutputProperty("{http://xml.apache.org/xalan}line-separator", "\n");
            }
            catch (Exception e) {
                LOG.warn("Unable to set Xalan line-separator property: " + e.getMessage());
            }
            ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes());
            Throwable throwable = null;
            try {
                xmlSource = new StreamSource(is);
                if (baos == null) {
                    try (ByteArrayOutputStream baos1 = new ByteArrayOutputStream();){
                        StreamResult outputTarget2 = new StreamResult(baos1);
                        transformer.transform(xmlSource, outputTarget2);
                        XMLSignatureInput output = new XMLSignatureInput(baos1.toByteArray());
                        output.setSecureValidation(secureValidation);
                        XMLSignatureInput xMLSignatureInput = output;
                        return xMLSignatureInput;
                    }
                }
                outputTarget = new StreamResult(baos);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            transformer.transform(xmlSource, outputTarget);
            XMLSignatureInput output = new XMLSignatureInput((byte[])null);
            output.setSecureValidation(secureValidation);
            output.setOutputStream(baos);
            return output;
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)is).close();
                    }
                }
            }
        }
        catch (XMLSecurityException | TransformerException ex) {
            throw new TransformationException(ex);
        }
    }
}

