/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ClassLoaderUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverContext;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverDirectHTTP;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverFragment;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverLocalFilesystem;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverXPointer;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class ResourceResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceResolver.class);
    private static final List<ResourceResolverSpi> resolverList = new CopyOnWriteArrayList<ResourceResolverSpi>();
    private static final AtomicBoolean defaultResolversAdded = new AtomicBoolean();

    public static void register(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JavaUtils.checkRegisterPermission();
        Class<?> resourceResolverClass = ClassLoaderUtils.loadClass(className, ResourceResolver.class);
        ResourceResolver.register((ResourceResolverSpi)JavaUtils.newInstanceWithEmptyConstructor(resourceResolverClass), false);
    }

    public static void registerAtStart(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JavaUtils.checkRegisterPermission();
        Class<?> resourceResolverClass = ClassLoaderUtils.loadClass(className, ResourceResolver.class);
        ResourceResolver.register((ResourceResolverSpi)JavaUtils.newInstanceWithEmptyConstructor(resourceResolverClass), true);
    }

    public static void register(ResourceResolverSpi resourceResolverSpi, boolean start) {
        JavaUtils.checkRegisterPermission();
        if (start) {
            resolverList.add(0, resourceResolverSpi);
        } else {
            resolverList.add(resourceResolverSpi);
        }
        LOG.debug("Registered resolver: {}", resourceResolverSpi.toString());
    }

    public static void registerClassNames(List<String> classNames) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        JavaUtils.checkRegisterPermission();
        ArrayList<ResourceResolverSpi> resourceResolversToAdd = new ArrayList<ResourceResolverSpi>(classNames.size());
        for (String className : classNames) {
            ResourceResolverSpi resourceResolverSpi = (ResourceResolverSpi)JavaUtils.newInstanceWithEmptyConstructor(ClassLoaderUtils.loadClass(className, ResourceResolver.class));
            resourceResolversToAdd.add(resourceResolverSpi);
        }
        resolverList.addAll(resourceResolversToAdd);
    }

    public static void registerDefaultResolvers() {
        if (defaultResolversAdded.compareAndSet(false, true)) {
            ArrayList<ResourceResolverSpi> resourceResolversToAdd = new ArrayList<ResourceResolverSpi>();
            resourceResolversToAdd.add(new ResolverFragment());
            resourceResolversToAdd.add(new ResolverLocalFilesystem());
            resourceResolversToAdd.add(new ResolverXPointer());
            resourceResolversToAdd.add(new ResolverDirectHTTP());
            resolverList.addAll(resourceResolversToAdd);
        }
    }

    public static XMLSignatureInput resolve(ResourceResolverContext context) throws ResourceResolverException {
        for (ResourceResolverSpi resolver : resolverList) {
            LOG.debug("check resolvability by class {}", resolver.getClass().getName());
            if (!resolver.engineCanResolveURI(context)) continue;
            return resolver.engineResolveURI(context);
        }
        Object[] exArgs = new Object[]{context.uriToResolve != null ? context.uriToResolve : "null", context.baseUri};
        throw new ResourceResolverException("utils.resolver.noClass", exArgs, context.uriToResolve, context.baseUri);
    }

    public static XMLSignatureInput resolve(List<ResourceResolverSpi> individualResolvers, ResourceResolverContext context) throws ResourceResolverException {
        LOG.debug("I was asked to create a ResourceResolver and got {}", individualResolvers == null ? 0 : individualResolvers.size());
        if (individualResolvers != null) {
            for (ResourceResolverSpi resolver : individualResolvers) {
                String currentClass = resolver.getClass().getName();
                LOG.debug("check resolvability by class {}", currentClass);
                if (!resolver.engineCanResolveURI(context)) continue;
                return resolver.engineResolveURI(context);
            }
        }
        return ResourceResolver.resolve(context);
    }
}

