/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.security.AccessController;
import java.security.PrivilegedAction;

class ImageDimensionsChecker {
    private static final boolean addExtraChecks;
    private static final long maxWidth;
    private static final long maxHeight;
    private static final long maxNrOfPixels;
    private static final long maxSize;
    private static final String DISABLE_TEXT = "You can disable all extra checks by setting the system property 'com.sap.jvm.addExtraChecksInSampleModel' to false.";

    ImageDimensionsChecker() {
    }

    public static void checkWidthAndHeight(int pixelSize, int width, int height) {
        if (!addExtraChecks) {
            return;
        }
        if ((long)width > maxWidth) {
            throw new IllegalArgumentException("Width " + width + " is larger than maximum width " + maxWidth + ". You can change the max width via the system property 'com.sap.jvm.maxSampleModelWidth'. " + DISABLE_TEXT);
        }
        if ((long)height > maxHeight) {
            throw new IllegalArgumentException("Height " + height + " is larger than maximum height" + maxHeight + ". You can change the max height via the system property 'com.sap.jvm.maxSampleModelHeight'. " + DISABLE_TEXT);
        }
        long s = (long)width * (long)height;
        if (s >= maxNrOfPixels) {
            throw new IllegalArgumentException("Width " + width + " times Height " + height + "results in " + s + " pixels which is larger than the maximum allowed number of pixels " + maxNrOfPixels + ". You can change the maximum allowed numver of pixels via the system property 'com.sap.jvm.maxSampleModelPixels'. " + DISABLE_TEXT);
        }
        if ((s = s * (long)pixelSize / 8L) >= maxSize) {
            throw new IllegalArgumentException("Width " + width + " times Height " + height + " leads to an image of size " + s + " which is larger than the maximum size " + maxSize + ". You can change the maximum size via the system property 'com.sap.jvm.maxSampleModelSize'. " + DISABLE_TEXT);
        }
    }

    static {
        Boolean addExtraChecksBoolean = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return "true".equals(System.getProperty("com.sap.jvm.addExtraChecksInSampleModel"));
            }
        });
        Long maxWidthLong = AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return Long.getLong("com.sap.jvm.maxSampleModelWidth", 10000000L);
            }
        });
        Long maxHeightLong = AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return Long.getLong("com.sap.jvm.maxSampleModelHeight", 10000000L);
            }
        });
        Long maxNrOfPixelsLong = AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return Long.getLong("com.sap.jvm.maxSampleModelPixels", 2000000000L);
            }
        });
        Long maxSizeLong = AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                return Long.getLong("com.sap.jvm.maxSampleModelSize", 2000000000L);
            }
        });
        addExtraChecks = addExtraChecksBoolean;
        maxWidth = maxWidthLong;
        maxHeight = maxHeightLong;
        maxNrOfPixels = maxNrOfPixelsLong;
        maxSize = maxSizeLong;
    }
}

