/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.SyncFailedException;
import java.util.ArrayList;
import java.util.List;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

public final class FileDescriptor {
    private int fd;
    private Closeable parent;
    private List<Closeable> otherParents;
    private boolean closed;
    public static final FileDescriptor in = new FileDescriptor(0, "<stdin>");
    public static final FileDescriptor out = new FileDescriptor(1, "<stdout>");
    public static final FileDescriptor err = new FileDescriptor(2, "<stderr>");

    public FileDescriptor() {
        this.fd = -1;
    }

    private FileDescriptor(int fd) {
        this.fd = fd;
    }

    private FileDescriptor(int fd, String name) {
        this.fd = fd;
        FileDescriptor.registerStandardStream(fd, name);
    }

    public boolean valid() {
        return this.fd != -1;
    }

    public native void sync() throws SyncFailedException;

    private static native void initIDs();

    synchronized void attach(Closeable c) {
        if (this.parent == null) {
            this.parent = c;
        } else if (this.otherParents == null) {
            this.otherParents = new ArrayList<Closeable>();
            this.otherParents.add(this.parent);
            this.otherParents.add(c);
        } else {
            this.otherParents.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeAll(Closeable releaser) throws IOException {
        block24: {
            if (!this.closed) {
                this.closed = true;
                IOException ioe = null;
                try (Closeable c = releaser;){
                    if (this.otherParents != null) {
                        for (Closeable referent : this.otherParents) {
                            try {
                                referent.close();
                            }
                            catch (IOException x) {
                                if (ioe == null) {
                                    ioe = x;
                                    continue;
                                }
                                ioe.addSuppressed(x);
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    if (ioe != null) {
                        ex.addSuppressed(ioe);
                    }
                    ioe = ex;
                }
                finally {
                    if (ioe == null) break block24;
                    throw ioe;
                }
            }
        }
    }

    private static native void registerStandardStream(long var0, String var2);

    static {
        FileDescriptor.initIDs();
        SharedSecrets.setJavaIOFileDescriptorAccess(new JavaIOFileDescriptorAccess(){

            @Override
            public void set(FileDescriptor obj, int fd) {
                obj.fd = fd;
            }

            @Override
            public int get(FileDescriptor obj) {
                return obj.fd;
            }

            @Override
            public void setHandle(FileDescriptor obj, long handle) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long getHandle(FileDescriptor obj) {
                throw new UnsupportedOperationException();
            }
        });
    }
}

