/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import sun.nio.ch.FileChannelImpl;
import sun.security.action.GetPropertyAction;

public class FileOutputStream
extends OutputStream {
    private final FileDescriptor fd;
    private final boolean append;
    private FileChannel channel;
    private final String path;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;
    private static final boolean extendExceptionWithPath;

    public FileOutputStream(String name) throws FileNotFoundException {
        this(name != null ? new File(name) : null, false);
    }

    public FileOutputStream(String name, boolean append) throws FileNotFoundException {
        this(name != null ? new File(name) : null, append);
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean append) throws FileNotFoundException {
        String name = file != null ? file.getPath() : null;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(name);
        }
        if (name == null) {
            throw new NullPointerException();
        }
        if (file.isInvalid()) {
            throw new FileNotFoundException("Invalid file path");
        }
        this.fd = new FileDescriptor();
        this.fd.attach(this);
        this.append = append;
        this.path = name;
        this.open(name, append);
    }

    public FileOutputStream(FileDescriptor fdObj) {
        SecurityManager security = System.getSecurityManager();
        if (fdObj == null) {
            throw new NullPointerException();
        }
        if (security != null) {
            security.checkWrite(fdObj);
        }
        this.fd = fdObj;
        this.append = false;
        this.path = null;
        this.fd.attach(this);
    }

    private native void open0(String var1, boolean var2) throws FileNotFoundException;

    private void open(String name, boolean append) throws FileNotFoundException {
        this.open0(name, append);
    }

    private native void write(int var1, boolean var2) throws IOException;

    @Override
    public void write(int b) throws IOException {
        this.write(b, this.append);
    }

    private native void writeBytes(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    private native void writeBytesWithPath(byte[] var1, int var2, int var3, boolean var4, String var5) throws IOException;

    @Override
    public void write(byte[] b) throws IOException {
        if (this.path == null || !extendExceptionWithPath) {
            this.writeBytes(b, 0, b.length, this.append);
        } else {
            this.writeBytesWithPath(b, 0, b.length, this.append, this.path);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.path == null || !extendExceptionWithPath) {
            this.writeBytes(b, off, len, this.append);
        } else {
            this.writeBytesWithPath(b, off, len, this.append, this.path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        if (this.channel != null) {
            this.channel.close();
        }
        this.fd.closeAll(new Closeable(){

            @Override
            public void close() throws IOException {
                FileOutputStream.this.close0();
            }
        });
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileOutputStream fileOutputStream = this;
        synchronized (fileOutputStream) {
            if (this.channel == null) {
                this.channel = FileChannelImpl.open(this.fd, this.path, false, true, this.append, this);
            }
            return this.channel;
        }
    }

    protected void finalize() throws IOException {
        if (this.fd != null) {
            if (this.fd == FileDescriptor.out || this.fd == FileDescriptor.err) {
                this.flush();
            } else {
                this.close();
            }
        }
    }

    private native void close0() throws IOException;

    private static native void initIDs();

    static {
        String propValue = AccessController.doPrivileged(new GetPropertyAction("com.sap.jvm.fileoutputstream.extendexceptionwithpath", "true"));
        extendExceptionWithPath = propValue.length() == 0 ? true : Boolean.valueOf(propValue);
        FileOutputStream.initIDs();
    }
}

