/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.security.action.GetPropertyAction;

class ClassLoaderHelper {
    private ClassLoaderHelper() {
    }

    private static boolean isAIXOrAS400() {
        String osName = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (osName == null) {
            return false;
        }
        return osName.equalsIgnoreCase("AIX") || osName.equalsIgnoreCase("OS400");
    }

    private static boolean checkFileExistence(final File libtmp) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return libtmp.exists();
            }
        });
    }

    static boolean loadLibraryOnlyIfPresent() {
        return true;
    }

    static File mapAlternativeName(File lib) {
        if (ClassLoaderHelper.isAIXOrAS400()) {
            String name = lib.toString();
            String parent = lib.getParent();
            String filename = lib.getName();
            if (filename.toLowerCase().startsWith("lib") && filename.toLowerCase().endsWith(".so")) {
                File ftmp;
                String origName = filename.substring(3, filename.length() - 3);
                File file = ftmp = parent == null ? new File(origName) : new File(parent, origName);
                if (ClassLoaderHelper.checkFileExistence(ftmp)) {
                    return ftmp;
                }
            }
            if (name.toLowerCase().endsWith(".so")) {
                return new File(name.substring(0, name.length() - 2) + "a");
            }
        }
        return null;
    }
}

