/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import jdk.internal.misc.JavaLangProcessBuilderAccess;
import jdk.internal.misc.SharedSecrets;
import jdk.internal.misc.Unsafe;

public final class ProcessBuilder {
    private List<String> command;
    private File directory;
    private Map<String, String> environment;
    private boolean redirectErrorStream;
    private Redirect[] redirects;
    private boolean processGroup = false;
    private static final Unsafe unsafe = Unsafe.getUnsafe();

    public ProcessBuilder(List<String> command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.command = command;
    }

    public ProcessBuilder(String ... command) {
        this.command = new ArrayList<String>(command.length);
        for (String arg : command) {
            this.command.add(arg);
        }
    }

    public ProcessBuilder command(List<String> command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.command = command;
        return this;
    }

    public ProcessBuilder command(String ... command) {
        this.command = new ArrayList<String>(command.length);
        for (String arg : command) {
            this.command.add(arg);
        }
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public Map<String, String> environment() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new RuntimePermission("getenv.*"));
        }
        if (this.environment == null) {
            this.environment = ProcessEnvironment.environment();
        }
        assert (this.environment != null);
        return this.environment;
    }

    ProcessBuilder environment(String[] envp) {
        assert (this.environment == null);
        if (envp != null) {
            this.environment = ProcessEnvironment.emptyEnvironment(envp.length);
            assert (this.environment != null);
            for (String envstring : envp) {
                int eqlsign;
                if (envstring.indexOf(0) != -1) {
                    envstring = envstring.replaceFirst("\u0000.*", "");
                }
                if ((eqlsign = envstring.indexOf(61, 0)) == -1) continue;
                this.environment.put(envstring.substring(0, eqlsign), envstring.substring(eqlsign + 1));
            }
        }
        return this;
    }

    public File directory() {
        return this.directory;
    }

    public ProcessBuilder directory(File directory) {
        this.directory = directory;
        return this;
    }

    private Redirect[] redirects() {
        if (this.redirects == null) {
            this.redirects = new Redirect[]{Redirect.PIPE, Redirect.PIPE, Redirect.PIPE};
        }
        return this.redirects;
    }

    public ProcessBuilder redirectInput(Redirect source) {
        if (source.type() == Redirect.Type.WRITE || source.type() == Redirect.Type.APPEND) {
            throw new IllegalArgumentException("Redirect invalid for reading: " + source);
        }
        this.redirects()[0] = source;
        return this;
    }

    public ProcessBuilder redirectOutput(Redirect destination) {
        if (destination.type() == Redirect.Type.READ) {
            throw new IllegalArgumentException("Redirect invalid for writing: " + destination);
        }
        this.redirects()[1] = destination;
        return this;
    }

    public ProcessBuilder redirectError(Redirect destination) {
        if (destination.type() == Redirect.Type.READ) {
            throw new IllegalArgumentException("Redirect invalid for writing: " + destination);
        }
        this.redirects()[2] = destination;
        return this;
    }

    public ProcessBuilder redirectInput(File file) {
        return this.redirectInput(Redirect.from(file));
    }

    public ProcessBuilder redirectOutput(File file) {
        return this.redirectOutput(Redirect.to(file));
    }

    public ProcessBuilder redirectError(File file) {
        return this.redirectError(Redirect.to(file));
    }

    public Redirect redirectInput() {
        return this.redirects == null ? Redirect.PIPE : this.redirects[0];
    }

    public Redirect redirectOutput() {
        return this.redirects == null ? Redirect.PIPE : this.redirects[1];
    }

    public Redirect redirectError() {
        return this.redirects == null ? Redirect.PIPE : this.redirects[2];
    }

    public ProcessBuilder inheritIO() {
        Arrays.fill(this.redirects(), Redirect.INHERIT);
        return this;
    }

    public boolean redirectErrorStream() {
        return this.redirectErrorStream;
    }

    public ProcessBuilder redirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
        return this;
    }

    public Process start() throws IOException {
        String[] cmdarray = this.command.toArray(new String[this.command.size()]);
        for (String arg : cmdarray = (String[])cmdarray.clone()) {
            if (arg != null) continue;
            throw new NullPointerException();
        }
        String prog = cmdarray[0];
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkExec(prog);
        }
        String dir = this.directory == null ? null : this.directory.toString();
        for (int i = 1; i < cmdarray.length; ++i) {
            if (cmdarray[i].indexOf(0) < 0) continue;
            throw new IOException("invalid null character in command");
        }
        return ProcessImpl.start(cmdarray, this.environment, dir, this.redirects, this.redirectErrorStream, this.processGroup);
    }

    static {
        SharedSecrets.setJavaLangProcessProcessBuilderAccess(new JavaLangProcessBuilderAccess(){

            @Override
            public Process startProcessGroup(ProcessBuilder builder) throws IOException {
                builder.processGroup = true;
                return builder.start();
            }

            @Override
            public ProcessBuilder environment(ProcessBuilder builder, String[] envp) {
                return builder.environment(envp);
            }
        });
        unsafe.ensureClassInitialized(ProcessImpl.class);
    }

    public static abstract class Redirect {
        public static final Redirect PIPE = new Redirect(){

            @Override
            public Type type() {
                return Type.PIPE;
            }

            public String toString() {
                return this.type().toString();
            }
        };
        public static final Redirect INHERIT = new Redirect(){

            @Override
            public Type type() {
                return Type.INHERIT;
            }

            public String toString() {
                return this.type().toString();
            }
        };

        public abstract Type type();

        public File file() {
            return null;
        }

        boolean append() {
            throw new UnsupportedOperationException();
        }

        public static Redirect from(final File file) {
            if (file == null) {
                throw new NullPointerException();
            }
            return new Redirect(){

                @Override
                public Type type() {
                    return Type.READ;
                }

                @Override
                public File file() {
                    return file;
                }

                public String toString() {
                    return "redirect to read from file \"" + file + "\"";
                }
            };
        }

        public static Redirect to(final File file) {
            if (file == null) {
                throw new NullPointerException();
            }
            return new Redirect(){

                @Override
                public Type type() {
                    return Type.WRITE;
                }

                @Override
                public File file() {
                    return file;
                }

                public String toString() {
                    return "redirect to write to file \"" + file + "\"";
                }

                @Override
                boolean append() {
                    return false;
                }
            };
        }

        public static Redirect appendTo(final File file) {
            if (file == null) {
                throw new NullPointerException();
            }
            return new Redirect(){

                @Override
                public Type type() {
                    return Type.APPEND;
                }

                @Override
                public File file() {
                    return file;
                }

                public String toString() {
                    return "redirect to append to file \"" + file + "\"";
                }

                @Override
                boolean append() {
                    return true;
                }
            };
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Redirect)) {
                return false;
            }
            Redirect r = (Redirect)obj;
            if (r.type() != this.type()) {
                return false;
            }
            assert (this.file() != null);
            return this.file().equals(r.file());
        }

        public int hashCode() {
            File file = this.file();
            if (file == null) {
                return super.hashCode();
            }
            return file.hashCode();
        }

        private Redirect() {
        }

        public static enum Type {
            PIPE,
            INHERIT,
            READ,
            WRITE,
            APPEND;

        }
    }

    static class NullOutputStream
    extends OutputStream {
        static final NullOutputStream INSTANCE = new NullOutputStream();

        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            throw new IOException("Stream closed");
        }
    }

    static class NullInputStream
    extends InputStream {
        static final NullInputStream INSTANCE = new NullInputStream();

        private NullInputStream() {
        }

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int available() {
            return 0;
        }
    }
}

