/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    private final char[] value;
    private int hash;
    private static final long serialVersionUID = -6849794470754667710L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();

    public String() {
        this.value = "".value;
    }

    public String(String original) {
        this.value = original.value;
        this.hash = original.hash;
    }

    public String(char[] value) {
        this.value = Arrays.copyOf(value, value.length);
    }

    public String(char[] value, int offset, int count) {
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (count <= 0) {
            if (count < 0) {
                throw new StringIndexOutOfBoundsException(count);
            }
            if (offset <= value.length) {
                this.value = "".value;
                return;
            }
        }
        if (offset > value.length - count) {
            throw new StringIndexOutOfBoundsException(offset + count);
        }
        this.value = Arrays.copyOfRange(value, offset, offset + count);
    }

    public String(int[] codePoints, int offset, int count) {
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (count <= 0) {
            if (count < 0) {
                throw new StringIndexOutOfBoundsException(count);
            }
            if (offset <= codePoints.length) {
                this.value = "".value;
                return;
            }
        }
        if (offset > codePoints.length - count) {
            throw new StringIndexOutOfBoundsException(offset + count);
        }
        int end = offset + count;
        int n = count;
        for (int i = offset; i < end; ++i) {
            int c = codePoints[i];
            if (Character.isBmpCodePoint(c)) continue;
            if (Character.isValidCodePoint(c)) {
                ++n;
                continue;
            }
            throw new IllegalArgumentException(Integer.toString(c));
        }
        char[] v = new char[n];
        int i = offset;
        int j = 0;
        while (i < end) {
            int c = codePoints[i];
            if (Character.isBmpCodePoint(c)) {
                v[j] = (char)c;
            } else {
                Character.toSurrogates(c, v, j++);
            }
            ++i;
            ++j;
        }
        this.value = v;
    }

    @Deprecated
    public String(byte[] ascii, int hibyte, int offset, int count) {
        String.checkBounds(ascii, offset, count);
        char[] value = new char[count];
        if (hibyte == 0) {
            int i = count;
            while (i-- > 0) {
                value[i] = (char)(ascii[i + offset] & 0xFF);
            }
        } else {
            hibyte <<= 8;
            int i = count;
            while (i-- > 0) {
                value[i] = (char)(hibyte | ascii[i + offset] & 0xFF);
            }
        }
        this.value = value;
    }

    @Deprecated
    public String(byte[] ascii, int hibyte) {
        this(ascii, hibyte, 0, ascii.length);
    }

    private static void checkBounds(byte[] bytes, int offset, int length) {
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (offset > bytes.length - length) {
            throw new StringIndexOutOfBoundsException(offset + length);
        }
    }

    public String(byte[] bytes, int offset, int length, String charsetName) throws UnsupportedEncodingException {
        if (charsetName == null) {
            throw new NullPointerException("charsetName");
        }
        String.checkBounds(bytes, offset, length);
        this.value = StringCoding.decode(charsetName, bytes, offset, length);
    }

    public String(byte[] bytes, int offset, int length, Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        String.checkBounds(bytes, offset, length);
        this.value = StringCoding.decode(charset, bytes, offset, length);
    }

    public String(byte[] bytes, String charsetName) throws UnsupportedEncodingException {
        this(bytes, 0, bytes.length, charsetName);
    }

    public String(byte[] bytes, Charset charset) {
        this(bytes, 0, bytes.length, charset);
    }

    public String(byte[] bytes, int offset, int length) {
        String.checkBounds(bytes, offset, length);
        this.value = StringCoding.decode(bytes, offset, length);
    }

    public String(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String(StringBuffer buffer) {
        StringBuffer stringBuffer = buffer;
        synchronized (stringBuffer) {
            this.value = Arrays.copyOf(buffer.getValue(), buffer.length());
        }
    }

    public String(StringBuilder builder) {
        this.value = Arrays.copyOf(builder.getValue(), builder.length());
    }

    String(char[] value, boolean share) {
        this.value = value;
    }

    @Override
    public int length() {
        return this.value.length;
    }

    public boolean isEmpty() {
        return this.value.length == 0;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.value.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public int codePointAt(int index) {
        if (index < 0 || index >= this.value.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return Character.codePointAtImpl(this.value, index, this.value.length);
    }

    public int codePointBefore(int index) {
        int i = index - 1;
        if (i < 0 || i >= this.value.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return Character.codePointBeforeImpl(this.value, index, 0);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.value.length || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointCountImpl(this.value, beginIndex, endIndex - beginIndex);
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        if (index < 0 || index > this.value.length) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePointsImpl(this.value, 0, this.value.length, index, codePointOffset);
    }

    void getChars(char[] dst, int dstBegin) {
        System.arraycopy(this.value, 0, dst, dstBegin, this.value.length);
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.value.length) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcBegin);
        }
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    @Deprecated
    public void getBytes(int srcBegin, int srcEnd, byte[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd > this.value.length) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException(srcEnd - srcBegin);
        }
        Objects.requireNonNull(dst);
        int j = dstBegin;
        int n = srcEnd;
        int i = srcBegin;
        char[] val = this.value;
        while (i < n) {
            dst[j++] = (byte)val[i++];
        }
    }

    public byte[] getBytes(String charsetName) throws UnsupportedEncodingException {
        if (charsetName == null) {
            throw new NullPointerException();
        }
        return StringCoding.encode(charsetName, this.value, 0, this.value.length);
    }

    public byte[] getBytes(Charset charset) {
        if (charset == null) {
            throw new NullPointerException();
        }
        return StringCoding.encode(charset, this.value, 0, this.value.length);
    }

    public byte[] getBytes() {
        return StringCoding.encode(this.value, 0, this.value.length);
    }

    private static boolean equals(char[] value, char[] other) {
        if (value.length != other.length) {
            return false;
        }
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == other[i]) continue;
            return false;
        }
        return true;
    }

    private static int compareTo(char[] value, char[] other) {
        int len1 = value.length;
        int len2 = other.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            int diff = value[k] - other[k];
            if (diff == 0) continue;
            return diff;
        }
        return len1 - len2;
    }

    private static int indexOf(char[] value, char[] str) {
        if (str.length == 0) {
            return 0;
        }
        if (value.length == 0) {
            return -1;
        }
        return String.indexOf(value, 0, value.length, str, 0, str.length, 0);
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof String) {
            String anotherString = (String)anObject;
            return String.equals(this.value, anotherString.value);
        }
        return false;
    }

    public boolean contentEquals(StringBuffer sb) {
        return this.contentEquals((CharSequence)sb);
    }

    private boolean nonSyncContentEquals(AbstractStringBuilder sb) {
        char[] v1 = this.value;
        char[] v2 = sb.getValue();
        int n = v1.length;
        if (n != sb.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (v1[i] == v2[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(CharSequence cs) {
        if (cs instanceof AbstractStringBuilder) {
            if (cs instanceof StringBuffer) {
                CharSequence charSequence = cs;
                synchronized (charSequence) {
                    return this.nonSyncContentEquals((AbstractStringBuilder)cs);
                }
            }
            return this.nonSyncContentEquals((AbstractStringBuilder)cs);
        }
        if (cs instanceof String) {
            return this.equals(cs);
        }
        char[] v1 = this.value;
        int n = v1.length;
        if (n != cs.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (v1[i] == cs.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String anotherString) {
        return this == anotherString ? true : anotherString != null && anotherString.value.length == this.value.length && this.regionMatches(true, 0, anotherString, 0, this.value.length);
    }

    @Override
    public int compareTo(String anotherString) {
        return String.compareTo(this.value, anotherString.value);
    }

    public int compareToIgnoreCase(String str) {
        return CASE_INSENSITIVE_ORDER.compare(this, str);
    }

    public boolean regionMatches(int toffset, String other, int ooffset, int len) {
        char[] ta = this.value;
        int to = toffset;
        char[] pa = other.value;
        int po = ooffset;
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)this.value.length - (long)len || (long)ooffset > (long)other.value.length - (long)len) {
            return false;
        }
        while (len-- > 0) {
            if (ta[to++] == pa[po++]) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(boolean ignoreCase, int toffset, String other, int ooffset, int len) {
        char[] ta = this.value;
        int to = toffset;
        char[] pa = other.value;
        int po = ooffset;
        if (ooffset < 0 || toffset < 0 || (long)toffset > (long)this.value.length - (long)len || (long)ooffset > (long)other.value.length - (long)len) {
            return false;
        }
        while (len-- > 0) {
            char u2;
            char u1;
            char c2;
            char c1;
            if ((c1 = ta[to++]) == (c2 = pa[po++]) || ignoreCase && ((u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String prefix, int toffset) {
        char[] ta = this.value;
        int to = toffset;
        char[] pa = prefix.value;
        int po = 0;
        int pc = prefix.value.length;
        if (toffset < 0 || toffset > this.value.length - pc) {
            return false;
        }
        while (--pc >= 0) {
            if (ta[to++] == pa[po++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean endsWith(String suffix) {
        return this.startsWith(suffix, this.value.length - suffix.value.length);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.value.length > 0) {
            char[] val = this.value;
            for (int i = 0; i < this.value.length; ++i) {
                h = 31 * h + val[i];
            }
            this.hash = h;
        }
        return h;
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(int ch, int fromIndex) {
        int max = this.value.length;
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= max) {
            return -1;
        }
        if (ch < 65536) {
            char[] value = this.value;
            for (int i = fromIndex; i < max; ++i) {
                if (value[i] != ch) continue;
                return i;
            }
            return -1;
        }
        return this.indexOfSupplementary(ch, fromIndex);
    }

    private int indexOfSupplementary(int ch, int fromIndex) {
        if (Character.isValidCodePoint(ch)) {
            char[] value = this.value;
            char hi = Character.highSurrogate(ch);
            char lo = Character.lowSurrogate(ch);
            int max = value.length - 1;
            for (int i = fromIndex; i < max; ++i) {
                if (value[i] != hi || value[i + 1] != lo) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(int ch) {
        return this.lastIndexOf(ch, this.value.length - 1);
    }

    public int lastIndexOf(int ch, int fromIndex) {
        if (ch < 65536) {
            char[] value = this.value;
            for (int i = Math.min(fromIndex, value.length - 1); i >= 0; --i) {
                if (value[i] != ch) continue;
                return i;
            }
            return -1;
        }
        return this.lastIndexOfSupplementary(ch, fromIndex);
    }

    private int lastIndexOfSupplementary(int ch, int fromIndex) {
        if (Character.isValidCodePoint(ch)) {
            char[] value = this.value;
            char hi = Character.highSurrogate(ch);
            char lo = Character.lowSurrogate(ch);
            for (int i = Math.min(fromIndex, value.length - 2); i >= 0; --i) {
                if (value[i] != hi || value[i + 1] != lo) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(String str) {
        return String.indexOf(this.value, str.value);
    }

    public int indexOf(String str, int fromIndex) {
        return String.indexOf(this.value, 0, this.value.length, str.value, 0, str.value.length, fromIndex);
    }

    static int indexOf(char[] source, int sourceOffset, int sourceCount, String target, int fromIndex) {
        return String.indexOf(source, sourceOffset, sourceCount, target.value, 0, target.value.length, fromIndex);
    }

    static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.value.length);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return String.lastIndexOf(this.value, 0, this.value.length, str.value, 0, str.value.length, fromIndex);
    }

    static int lastIndexOf(char[] source, int sourceOffset, int sourceCount, String target, int fromIndex) {
        return String.lastIndexOf(source, sourceOffset, sourceCount, target.value, 0, target.value.length, fromIndex);
    }

    static int lastIndexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = target[strLastIndex];
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && source[i] != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source[j--] == target[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    public String substring(int beginIndex) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        int subLen = this.value.length - beginIndex;
        if (subLen < 0) {
            throw new StringIndexOutOfBoundsException(subLen);
        }
        return beginIndex == 0 ? this : new String(this.value, beginIndex, subLen);
    }

    public String substring(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > this.value.length) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        int subLen = endIndex - beginIndex;
        if (subLen < 0) {
            throw new StringIndexOutOfBoundsException(subLen);
        }
        return beginIndex == 0 && endIndex == this.value.length ? this : new String(this.value, beginIndex, subLen);
    }

    @Override
    public CharSequence subSequence(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex);
    }

    public String concat(String str) {
        if (str.isEmpty()) {
            return this;
        }
        int len = this.value.length;
        int otherLen = str.length();
        char[] buf = Arrays.copyOf(this.value, len + otherLen);
        str.getChars(buf, len);
        return new String(buf, true);
    }

    public String replace(char oldChar, char newChar) {
        if (oldChar != newChar) {
            int len = this.value.length;
            int i = -1;
            char[] val = this.value;
            while (++i < len && val[i] != oldChar) {
            }
            if (i < len) {
                char[] buf = new char[len];
                for (int j = 0; j < i; ++j) {
                    buf[j] = val[j];
                }
                while (i < len) {
                    char c = val[i];
                    buf[i] = c == oldChar ? newChar : c;
                    ++i;
                }
                return new String(buf, true);
            }
        }
        return this;
    }

    public boolean matches(String regex) {
        return Pattern.matches(regex, this);
    }

    public boolean contains(CharSequence s) {
        return this.indexOf(s.toString()) > -1;
    }

    public String replaceFirst(String regex, String replacement) {
        return Pattern.compile(regex).matcher(this).replaceFirst(replacement);
    }

    public String replaceAll(String regex, String replacement) {
        return Pattern.compile(regex).matcher(this).replaceAll(replacement);
    }

    public String replace(CharSequence target, CharSequence replacement) {
        return Pattern.compile(target.toString(), 16).matcher(this).replaceAll(Matcher.quoteReplacement(replacement.toString()));
    }

    public String[] split(String regex, int limit) {
        char ch = '\u0000';
        if ((regex.value.length == 1 && ".$|()[{^?*+\\".indexOf(ch = regex.charAt(0)) == -1 || regex.length() == 2 && regex.charAt(0) == '\\' && ((ch = regex.charAt(1)) - 48 | 57 - ch) < 0 && (ch - 97 | 122 - ch) < 0 && (ch - 65 | 90 - ch) < 0) && (ch < '\ud800' || ch > '\udfff')) {
            int resultSize;
            int off = 0;
            int next = 0;
            boolean limited = limit > 0;
            ArrayList<String> list = new ArrayList<String>();
            while ((next = this.indexOf(ch, off)) != -1) {
                if (!limited || list.size() < limit - 1) {
                    list.add(this.substring(off, next));
                    off = next + 1;
                    continue;
                }
                list.add(this.substring(off, this.value.length));
                off = this.value.length;
                break;
            }
            if (off == 0) {
                return new String[]{this};
            }
            if (!limited || list.size() < limit) {
                list.add(this.substring(off, this.value.length));
            }
            if (limit == 0) {
                for (resultSize = list.size(); resultSize > 0 && ((String)list.get(resultSize - 1)).isEmpty(); --resultSize) {
                }
            }
            String[] result = new String[resultSize];
            return list.subList(0, resultSize).toArray(result);
        }
        return Pattern.compile(regex).split(this, limit);
    }

    public String[] split(String regex) {
        return this.split(regex, 0);
    }

    public static String join(CharSequence delimiter, CharSequence ... elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        StringJoiner joiner = new StringJoiner(delimiter);
        for (CharSequence cs : elements) {
            joiner.add(cs);
        }
        return joiner.toString();
    }

    public static String join(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        StringJoiner joiner = new StringJoiner(delimiter);
        for (CharSequence charSequence : elements) {
            joiner.add(charSequence);
        }
        return joiner.toString();
    }

    public String toLowerCase(Locale locale) {
        int srcCount;
        int firstUpper;
        int len;
        block15: {
            if (locale == null) {
                throw new NullPointerException();
            }
            len = this.value.length;
            firstUpper = 0;
            while (firstUpper < len) {
                char c = this.value[firstUpper];
                if (c >= '\ud800' && c <= '\udbff') {
                    int supplChar = this.codePointAt(firstUpper);
                    if (supplChar == Character.toLowerCase(supplChar)) {
                        firstUpper += Character.charCount(supplChar);
                        continue;
                    }
                } else if (c == Character.toLowerCase(c)) {
                    ++firstUpper;
                    continue;
                }
                break block15;
            }
            return this;
        }
        char[] result = new char[len];
        int resultOffset = 0;
        System.arraycopy(this.value, 0, result, 0, firstUpper);
        String lang = locale.getLanguage();
        boolean localeDependent = lang == "tr" || lang == "az" || lang == "lt";
        for (int i = firstUpper; i < len; i += srcCount) {
            int srcChar = this.value[i];
            if ((char)srcChar >= '\ud800' && (char)srcChar <= '\udbff') {
                srcChar = this.codePointAt(i);
                srcCount = Character.charCount(srcChar);
            } else {
                srcCount = 1;
            }
            int lowerChar = localeDependent || srcChar == 931 || srcChar == 304 ? ConditionalSpecialCasing.toLowerCaseEx(this, i, locale) : Character.toLowerCase(srcChar);
            if (lowerChar == -1 || lowerChar >= 65536) {
                char[] lowerCharArray;
                if (lowerChar == -1) {
                    lowerCharArray = ConditionalSpecialCasing.toLowerCaseCharArray(this, i, locale);
                } else {
                    if (srcCount == 2) {
                        resultOffset += Character.toChars(lowerChar, result, i + resultOffset) - srcCount;
                        continue;
                    }
                    lowerCharArray = Character.toChars(lowerChar);
                }
                int mapLen = lowerCharArray.length;
                if (mapLen > srcCount) {
                    char[] result2 = new char[result.length + mapLen - srcCount];
                    System.arraycopy(result, 0, result2, 0, i + resultOffset);
                    result = result2;
                }
                for (int x = 0; x < mapLen; ++x) {
                    result[i + resultOffset + x] = lowerCharArray[x];
                }
                resultOffset += mapLen - srcCount;
                continue;
            }
            result[i + resultOffset] = (char)lowerChar;
        }
        return new String(result, 0, len + resultOffset);
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public String toUpperCase(Locale locale) {
        int srcCount;
        int firstLower;
        int len;
        block14: {
            int srcCount2;
            if (locale == null) {
                throw new NullPointerException();
            }
            len = this.value.length;
            for (firstLower = 0; firstLower < len; firstLower += srcCount2) {
                int c = this.value[firstLower];
                if (c >= 55296 && c <= 56319) {
                    c = this.codePointAt(firstLower);
                    srcCount2 = Character.charCount(c);
                } else {
                    srcCount2 = 1;
                }
                int upperCaseChar = Character.toUpperCaseEx(c);
                if (upperCaseChar != -1 && c == upperCaseChar) {
                    continue;
                }
                break block14;
            }
            return this;
        }
        int resultOffset = 0;
        char[] result = new char[len];
        System.arraycopy(this.value, 0, result, 0, firstLower);
        String lang = locale.getLanguage();
        boolean localeDependent = lang == "tr" || lang == "az" || lang == "lt";
        for (int i = firstLower; i < len; i += srcCount) {
            int srcChar = this.value[i];
            if ((char)srcChar >= '\ud800' && (char)srcChar <= '\udbff') {
                srcChar = this.codePointAt(i);
                srcCount = Character.charCount(srcChar);
            } else {
                srcCount = 1;
            }
            int upperChar = localeDependent ? ConditionalSpecialCasing.toUpperCaseEx(this, i, locale) : Character.toUpperCaseEx(srcChar);
            if (upperChar == -1 || upperChar >= 65536) {
                char[] upperCharArray;
                if (upperChar == -1) {
                    upperCharArray = localeDependent ? ConditionalSpecialCasing.toUpperCaseCharArray(this, i, locale) : Character.toUpperCaseCharArray(srcChar);
                } else {
                    if (srcCount == 2) {
                        resultOffset += Character.toChars(upperChar, result, i + resultOffset) - srcCount;
                        continue;
                    }
                    upperCharArray = Character.toChars(upperChar);
                }
                int mapLen = upperCharArray.length;
                if (mapLen > srcCount) {
                    char[] result2 = new char[result.length + mapLen - srcCount];
                    System.arraycopy(result, 0, result2, 0, i + resultOffset);
                    result = result2;
                }
                for (int x = 0; x < mapLen; ++x) {
                    result[i + resultOffset + x] = upperCharArray[x];
                }
                resultOffset += mapLen - srcCount;
                continue;
            }
            result[i + resultOffset] = (char)upperChar;
        }
        return new String(result, 0, len + resultOffset);
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public String trim() {
        int st;
        int len = this.value.length;
        char[] val = this.value;
        for (st = 0; st < len && val[st] <= ' '; ++st) {
        }
        while (st < len && val[len - 1] <= ' ') {
            --len;
        }
        return st > 0 || len < this.value.length ? this.substring(st, len) : this;
    }

    @Override
    public String toString() {
        return this;
    }

    public char[] toCharArray() {
        char[] result = new char[this.value.length];
        System.arraycopy(this.value, 0, result, 0, this.value.length);
        return result;
    }

    public static String format(String format, Object ... args) {
        return new Formatter().format(format, args).toString();
    }

    public static String format(Locale l, String format, Object ... args) {
        return new Formatter(l).format(format, args).toString();
    }

    public static String valueOf(Object obj) {
        return obj == null ? "null" : obj.toString();
    }

    public static String valueOf(char[] data) {
        return new String(data);
    }

    public static String valueOf(char[] data, int offset, int count) {
        return new String(data, offset, count);
    }

    public static String copyValueOf(char[] data, int offset, int count) {
        return new String(data, offset, count);
    }

    public static String copyValueOf(char[] data) {
        return new String(data);
    }

    public static String valueOf(boolean b) {
        return b ? "true" : "false";
    }

    public static String valueOf(char c) {
        char[] data = new char[]{c};
        return new String(data, true);
    }

    public static String valueOf(int i) {
        return Integer.toString(i);
    }

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public native String intern();

    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int n1 = s1.length();
            int n2 = s2.length();
            int min = Math.min(n1, n2);
            for (int i = 0; i < min; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i)) || (c1 = Character.toUpperCase(c1)) == (c2 = Character.toUpperCase(c2)) || (c1 = Character.toLowerCase(c1)) == (c2 = Character.toLowerCase(c2))) continue;
                return c1 - c2;
            }
            return n1 - n2;
        }

        private Object readResolve() {
            return String.CASE_INSENSITIVE_ORDER;
        }
    }
}

