/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import jdk.internal.misc.JavaLangProcessAccess;
import jdk.internal.misc.SharedSecrets;
import sun.misc.JavaIOFileDescriptorAccess;

final class UNIXProcess
extends Process {
    private static final JavaIOFileDescriptorAccess fdAccess = sun.misc.SharedSecrets.getJavaIOFileDescriptorAccess();
    private final int pid;
    private int exitcode;
    private boolean hasExited;
    private OutputStream stdin;
    private InputStream stdout;
    private InputStream stderr;
    private DeferredCloseInputStream stdout_inner_stream;
    private static final Platform platform = Platform.get();
    private static final LaunchMechanism launchMechanism = platform.launchMechanism();
    private static final byte[] helperpath = UNIXProcess.toCString(platform.helperPath());
    private static final Executor processReaperExecutor = AccessController.doPrivileged(() -> {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        ThreadGroup systemThreadGroup = tg;
        ThreadFactory threadFactory = grimReaper -> {
            long stackSize = Boolean.getBoolean("jdk.lang.processReaperUseDefaultStackSize") ? 0L : 262144L;
            Thread t = new Thread(systemThreadGroup, grimReaper, "process reaper", stackSize);
            t.setDaemon(true);
            t.setPriority(10);
            return t;
        };
        return Executors.newCachedThreadPool(threadFactory);
    });

    private static byte[] toCString(String s) {
        if (s == null) {
            return null;
        }
        byte[] bytes = s.getBytes();
        byte[] result = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        result[result.length - 1] = 0;
        return result;
    }

    private native int waitForProcessExit(int var1);

    private native int forkAndExec(int var1, byte[] var2, byte[] var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int[] var9, boolean var10, boolean var11) throws IOException;

    UNIXProcess(byte[] prog, byte[] argBlock, int argc, byte[] envBlock, int envc, byte[] dir, int[] fds, boolean redirectErrorStream, boolean processGroup) throws IOException {
        this.pid = this.forkAndExec(launchMechanism.ordinal() + 1, helperpath, prog, argBlock, argc, envBlock, envc, dir, fds, redirectErrorStream, processGroup);
        try {
            AccessController.doPrivileged(() -> {
                this.initStreams(fds);
                return null;
            });
        }
        catch (PrivilegedActionException ex) {
            throw (IOException)ex.getException();
        }
    }

    static FileDescriptor newFileDescriptor(int fd) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        fdAccess.set(fileDescriptor, fd);
        return fileDescriptor;
    }

    void initStreams(int[] fds) throws IOException {
        switch (platform) {
            case LINUX: 
            case BSD: {
                this.stdin = fds[0] == -1 ? ProcessBuilder.NullOutputStream.INSTANCE : new ProcessPipeOutputStream(fds[0]);
                this.stdout = fds[1] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new ProcessPipeInputStream(fds[1]);
                this.stderr = fds[2] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new ProcessPipeInputStream(fds[2]);
                processReaperExecutor.execute(() -> {
                    int exitcode = this.waitForProcessExit(this.pid);
                    UNIXProcess uNIXProcess = this;
                    synchronized (uNIXProcess) {
                        this.exitcode = exitcode;
                        this.hasExited = true;
                        this.notifyAll();
                    }
                    if (this.stdout instanceof ProcessPipeInputStream) {
                        ((ProcessPipeInputStream)this.stdout).processExited();
                    }
                    if (this.stderr instanceof ProcessPipeInputStream) {
                        ((ProcessPipeInputStream)this.stderr).processExited();
                    }
                    if (this.stdin instanceof ProcessPipeOutputStream) {
                        ((ProcessPipeOutputStream)this.stdin).processExited();
                    }
                });
                break;
            }
            case SOLARIS: 
            case HPUX: {
                InputStream inputStream;
                OutputStream outputStream = this.stdin = fds[0] == -1 ? ProcessBuilder.NullOutputStream.INSTANCE : new BufferedOutputStream(new FileOutputStream(UNIXProcess.newFileDescriptor(fds[0])));
                if (fds[1] == -1) {
                    inputStream = ProcessBuilder.NullInputStream.INSTANCE;
                } else {
                    this.stdout_inner_stream = new DeferredCloseInputStream(UNIXProcess.newFileDescriptor(fds[1]));
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(this.stdout_inner_stream);
                    inputStream = bufferedInputStream;
                }
                this.stdout = inputStream;
                this.stderr = fds[2] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new DeferredCloseInputStream(UNIXProcess.newFileDescriptor(fds[2]));
                processReaperExecutor.execute(() -> {
                    int exitcode = this.waitForProcessExit(this.pid);
                    UNIXProcess uNIXProcess = this;
                    synchronized (uNIXProcess) {
                        this.exitcode = exitcode;
                        this.hasExited = true;
                        this.notifyAll();
                    }
                });
                break;
            }
            case AIX: {
                this.stdin = fds[0] == -1 ? ProcessBuilder.NullOutputStream.INSTANCE : new ProcessPipeOutputStream(fds[0]);
                this.stdout = fds[1] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new DeferredCloseProcessPipeInputStream(fds[1]);
                this.stderr = fds[2] == -1 ? ProcessBuilder.NullInputStream.INSTANCE : new DeferredCloseProcessPipeInputStream(fds[2]);
                processReaperExecutor.execute(() -> {
                    int exitcode = this.waitForProcessExit(this.pid);
                    UNIXProcess uNIXProcess = this;
                    synchronized (uNIXProcess) {
                        this.exitcode = exitcode;
                        this.hasExited = true;
                        this.notifyAll();
                    }
                    if (this.stdout instanceof DeferredCloseProcessPipeInputStream) {
                        ((DeferredCloseProcessPipeInputStream)this.stdout).processExited();
                    }
                    if (this.stderr instanceof DeferredCloseProcessPipeInputStream) {
                        ((DeferredCloseProcessPipeInputStream)this.stderr).processExited();
                    }
                    if (this.stdin instanceof ProcessPipeOutputStream) {
                        ((ProcessPipeOutputStream)this.stdin).processExited();
                    }
                });
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported platform: " + (Object)((Object)platform)));
            }
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr;
    }

    @Override
    public synchronized int waitFor() throws InterruptedException {
        while (!this.hasExited) {
            this.wait();
        }
        return this.exitcode;
    }

    @Override
    public synchronized boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        long remainingNanos = unit.toNanos(timeout);
        if (this.hasExited) {
            return true;
        }
        if (timeout <= 0L) {
            return false;
        }
        long deadline = System.nanoTime() + remainingNanos;
        do {
            TimeUnit.NANOSECONDS.timedWait(this, remainingNanos);
            if (!this.hasExited) continue;
            return true;
        } while ((remainingNanos = deadline - System.nanoTime()) > 0L);
        return this.hasExited;
    }

    @Override
    public synchronized int exitValue() {
        if (!this.hasExited) {
            throw new IllegalThreadStateException("process hasn't exited");
        }
        return this.exitcode;
    }

    private static native void destroyProcess(int var0, boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(boolean force) {
        switch (platform) {
            case LINUX: 
            case HPUX: 
            case AIX: 
            case BSD: {
                UNIXProcess uNIXProcess = this;
                synchronized (uNIXProcess) {
                    if (!this.hasExited) {
                        UNIXProcess.destroyProcess(this.pid, force);
                    }
                }
                try {
                    this.stdin.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.stdout.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.stderr.close();
                }
                catch (IOException iOException) {}
                break;
            }
            case SOLARIS: {
                UNIXProcess uNIXProcess = this;
                synchronized (uNIXProcess) {
                    if (!this.hasExited) {
                        UNIXProcess.destroyProcess(this.pid, force);
                    }
                    try {
                        this.stdin.close();
                        if (this.stdout_inner_stream != null) {
                            this.stdout_inner_stream.closeDeferred(this.stdout);
                        }
                        if (this.stderr instanceof DeferredCloseInputStream) {
                            ((DeferredCloseInputStream)this.stderr).closeDeferred(this.stderr);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    break;
                }
            }
            default: {
                throw new AssertionError((Object)("Unsupported platform: " + (Object)((Object)platform)));
            }
        }
    }

    @Override
    public void destroy() {
        this.destroy(false);
    }

    @Override
    public Process destroyForcibly() {
        this.destroy(true);
        return this;
    }

    @Override
    public synchronized boolean isAlive() {
        return !this.hasExited;
    }

    private static native void init();

    static {
        UNIXProcess.init();
        SharedSecrets.setJavaLangProcessAccess(new JavaLangProcessAccess(){

            @Override
            public long getProcessGroupOwner(Process master) {
                return ((UNIXProcess)master).pid;
            }

            @Override
            public void destroyProcessGroup(Process master, boolean force) {
                UNIXProcess cfr_ignored_0 = (UNIXProcess)master;
                UNIXProcess.destroyProcess(-((UNIXProcess)master).pid, force);
            }

            @Override
            public long getPid(Process process) {
                return ((UNIXProcess)process).pid;
            }
        });
    }

    private static class DeferredCloseProcessPipeInputStream
    extends BufferedInputStream {
        private final Object closeLock = new Object();
        private int useCount = 0;
        private boolean closePending = false;

        DeferredCloseProcessPipeInputStream(int fd) {
            super(new FileInputStream(UNIXProcess.newFileDescriptor(fd)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InputStream drainInputStream(InputStream in) throws IOException {
            int j;
            int n = 0;
            byte[] a = null;
            Object object = this.closeLock;
            synchronized (object) {
                if (this.buf == null) {
                    return null;
                }
                j = in.available();
            }
            while (j > 0) {
                a = a == null ? new byte[j] : Arrays.copyOf(a, n + j);
                object = this.closeLock;
                synchronized (object) {
                    if (this.buf == null) {
                        return null;
                    }
                    n += in.read(a, n, j);
                    j = in.available();
                }
            }
            return a == null ? ProcessBuilder.NullInputStream.INSTANCE : new ByteArrayInputStream(n == a.length ? a : Arrays.copyOf(a, n));
        }

        synchronized void processExited() {
            try {
                InputStream in = this.in;
                if (in != null) {
                    InputStream stragglers = this.drainInputStream(in);
                    in.close();
                    this.in = stragglers;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void raise() {
            Object object = this.closeLock;
            synchronized (object) {
                ++this.useCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lower() throws IOException {
            Object object = this.closeLock;
            synchronized (object) {
                --this.useCount;
                if (this.useCount == 0 && this.closePending) {
                    this.closePending = false;
                    super.close();
                }
            }
        }

        @Override
        public int read() throws IOException {
            this.raise();
            try {
                int n = super.read();
                return n;
            }
            finally {
                this.lower();
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.raise();
            try {
                int n = super.read(b);
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.raise();
            try {
                int n = super.read(b, off, len);
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            this.raise();
            try {
                long l = super.skip(n);
                return l;
            }
            finally {
                this.lower();
            }
        }

        @Override
        public int available() throws IOException {
            this.raise();
            try {
                int n = super.available();
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.closeLock;
            synchronized (object) {
                if (this.useCount == 0) {
                    super.close();
                } else {
                    this.closePending = true;
                }
            }
        }
    }

    private static class DeferredCloseInputStream
    extends FileInputStream {
        private Object lock = new Object();
        private boolean closePending = false;
        private int useCount = 0;
        private InputStream streamToClose;

        DeferredCloseInputStream(FileDescriptor fd) {
            super(fd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void raise() {
            Object object = this.lock;
            synchronized (object) {
                ++this.useCount;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lower() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                --this.useCount;
                if (this.useCount == 0 && this.closePending) {
                    this.streamToClose.close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeDeferred(InputStream stc) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.useCount == 0) {
                    stc.close();
                } else {
                    this.closePending = true;
                    this.streamToClose = stc;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.useCount = 0;
                this.closePending = false;
            }
            super.close();
        }

        @Override
        public int read() throws IOException {
            this.raise();
            try {
                int n = super.read();
                return n;
            }
            finally {
                this.lower();
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.raise();
            try {
                int n = super.read(b);
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.raise();
            try {
                int n = super.read(b, off, len);
                return n;
            }
            finally {
                this.lower();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            this.raise();
            try {
                long l = super.skip(n);
                return l;
            }
            finally {
                this.lower();
            }
        }

        @Override
        public int available() throws IOException {
            this.raise();
            try {
                int n = super.available();
                return n;
            }
            finally {
                this.lower();
            }
        }
    }

    private static class ProcessPipeOutputStream
    extends BufferedOutputStream {
        ProcessPipeOutputStream(int fd) {
            super(new FileOutputStream(UNIXProcess.newFileDescriptor(fd)));
        }

        synchronized void processExited() {
            OutputStream out = this.out;
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.out = ProcessBuilder.NullOutputStream.INSTANCE;
            }
        }
    }

    private static class ProcessPipeInputStream
    extends BufferedInputStream {
        private final Object closeLock = new Object();

        ProcessPipeInputStream(int fd) {
            super(new FileInputStream(UNIXProcess.newFileDescriptor(fd)));
        }

        private static byte[] drainInputStream(InputStream in) throws IOException {
            int j;
            int n = 0;
            byte[] a = null;
            while ((j = in.available()) > 0) {
                a = a == null ? new byte[j] : Arrays.copyOf(a, n + j);
                n += in.read(a, n, j);
            }
            return a == null || n == a.length ? a : Arrays.copyOf(a, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void processExited() {
            Object object = this.closeLock;
            synchronized (object) {
                try {
                    InputStream in = this.in;
                    if (in != null) {
                        byte[] stragglers = ProcessPipeInputStream.drainInputStream(in);
                        in.close();
                        this.in = stragglers == null ? ProcessBuilder.NullInputStream.INSTANCE : new ByteArrayInputStream(stragglers);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.closeLock;
            synchronized (object) {
                super.close();
            }
        }
    }

    private static enum Platform {
        LINUX(LaunchMechanism.VFORK, LaunchMechanism.FORK),
        BSD(LaunchMechanism.POSIX_SPAWN, LaunchMechanism.FORK),
        SOLARIS(LaunchMechanism.POSIX_SPAWN, LaunchMechanism.FORK),
        AIX(LaunchMechanism.POSIX_SPAWN, LaunchMechanism.FORK),
        HPUX(LaunchMechanism.VFORK, LaunchMechanism.FORK);

        final LaunchMechanism defaultLaunchMechanism;
        final Set<LaunchMechanism> validLaunchMechanisms;

        private Platform(LaunchMechanism ... launchMechanisms) {
            this.defaultLaunchMechanism = launchMechanisms[0];
            this.validLaunchMechanisms = EnumSet.copyOf(Arrays.asList(launchMechanisms));
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        private String helperPath(String javahome, String osArch) {
            switch (this) {
                case SOLARIS: {
                    if (osArch.equals("x86")) {
                        osArch = "i386";
                    } else {
                        if (!osArch.equals("x86_64")) return javahome + "/lib/" + osArch + "/jspawnhelper";
                        osArch = "amd64";
                    }
                }
                case LINUX: 
                case HPUX: 
                case AIX: {
                    return javahome + "/lib/" + osArch + "/jspawnhelper";
                }
                case BSD: {
                    return javahome + "/lib/jspawnhelper";
                }
            }
            throw new AssertionError((Object)("Unsupported platform: " + (Object)((Object)this)));
        }

        String helperPath() {
            return AccessController.doPrivileged(() -> this.helperPath(System.getProperty("java.home"), System.getProperty("os.arch")));
        }

        LaunchMechanism launchMechanism() {
            return AccessController.doPrivileged(() -> {
                LaunchMechanism lm;
                String s = System.getProperty("jdk.lang.Process.launchMechanism");
                if (s == null) {
                    lm = this.defaultLaunchMechanism;
                    s = lm.name().toLowerCase(Locale.ENGLISH);
                } else {
                    try {
                        lm = LaunchMechanism.valueOf(s.toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException e) {
                        lm = null;
                    }
                }
                if (lm == null || !this.validLaunchMechanisms.contains((Object)lm)) {
                    throw new Error(s + " is not a supported process launch mechanism on this platform.");
                }
                return lm;
            });
        }

        static Platform get() {
            String osName = AccessController.doPrivileged(() -> System.getProperty("os.name"));
            if (osName.equals("Linux")) {
                return LINUX;
            }
            if (osName.contains("OS X")) {
                return BSD;
            }
            if (osName.equals("SunOS")) {
                return SOLARIS;
            }
            if (osName.equals("AIX")) {
                return AIX;
            }
            if (osName.equals("HP-UX")) {
                return HPUX;
            }
            if (osName.equals("OS400")) {
                return AIX;
            }
            throw new Error(osName + " is not a supported OS platform.");
        }
    }

    private static enum LaunchMechanism {
        FORK,
        POSIX_SPAWN,
        VFORK;

    }
}

