/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleNatives;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;

public abstract class CallSite {
    MethodHandle target;
    private final MethodHandleNatives.CallSiteContext context = MethodHandleNatives.CallSiteContext.make(this);
    private static final MethodHandle GET_TARGET;
    private static final MethodHandle THROW_UCS;
    private static final long TARGET_OFFSET;
    private static final long CONTEXT_OFFSET;

    CallSite(MethodType type) {
        this.target = this.makeUninitializedCallSite(type);
    }

    CallSite(MethodHandle target) {
        target.type();
        this.target = target;
    }

    CallSite(MethodType targetType, MethodHandle createTargetHook) throws Throwable {
        this(targetType);
        ConstantCallSite selfCCS = (ConstantCallSite)this;
        MethodHandle boundTarget = (MethodHandle)createTargetHook.invokeWithArguments(selfCCS);
        this.checkTargetChange(this.target, boundTarget);
        this.target = boundTarget;
    }

    public MethodType type() {
        return this.target.type();
    }

    public abstract MethodHandle getTarget();

    public abstract void setTarget(MethodHandle var1);

    void checkTargetChange(MethodHandle oldTarget, MethodHandle newTarget) {
        MethodType oldType = oldTarget.type();
        MethodType newType = newTarget.type();
        if (!newType.equals((Object)oldType)) {
            throw CallSite.wrongTargetType(newTarget, oldType);
        }
    }

    private static WrongMethodTypeException wrongTargetType(MethodHandle target, MethodType type) {
        return new WrongMethodTypeException(String.valueOf(target) + " should be of type " + type);
    }

    public abstract MethodHandle dynamicInvoker();

    MethodHandle makeDynamicInvoker() {
        BoundMethodHandle getTarget = GET_TARGET.bindArgumentL(0, this);
        MethodHandle invoker = MethodHandles.exactInvoker(this.type());
        return MethodHandles.foldArguments(invoker, getTarget);
    }

    private static Object uninitializedCallSite(Object ... ignore) {
        throw new IllegalStateException("uninitialized call site");
    }

    private MethodHandle makeUninitializedCallSite(MethodType targetType) {
        MethodType basicType = targetType.basicType();
        MethodHandle invoker = basicType.form().cachedMethodHandle(2);
        if (invoker == null) {
            invoker = THROW_UCS.asType(basicType);
            invoker = basicType.form().setCachedMethodHandle(2, invoker);
        }
        return invoker.viewAsType(targetType, false);
    }

    void setTargetNormal(MethodHandle newTarget) {
        MethodHandleNatives.setCallSiteTargetNormal(this, newTarget);
    }

    MethodHandle getTargetVolatile() {
        return (MethodHandle)MethodHandleStatics.UNSAFE.getObjectVolatile(this, TARGET_OFFSET);
    }

    void setTargetVolatile(MethodHandle newTarget) {
        MethodHandleNatives.setCallSiteTargetVolatile(this, newTarget);
    }

    static CallSite makeSite(MethodHandle bootstrapMethod, String name, MethodType type, Object info, Class<?> callerClass) {
        CallSite site;
        MethodHandles.Lookup caller = MethodHandles.Lookup.IMPL_LOOKUP.in(callerClass);
        try {
            Object binding;
            info = CallSite.maybeReBox(info);
            if (info == null) {
                binding = bootstrapMethod.invoke(caller, name, type);
            } else if (!info.getClass().isArray()) {
                binding = bootstrapMethod.invoke(caller, name, type, info);
            } else {
                Object[] argv = (Object[])info;
                CallSite.maybeReBoxElements(argv);
                switch (argv.length) {
                    case 0: {
                        binding = bootstrapMethod.invoke(caller, name, type);
                        break;
                    }
                    case 1: {
                        binding = bootstrapMethod.invoke(caller, name, type, argv[0]);
                        break;
                    }
                    case 2: {
                        binding = bootstrapMethod.invoke(caller, name, type, argv[0], argv[1]);
                        break;
                    }
                    case 3: {
                        binding = bootstrapMethod.invoke(caller, name, type, argv[0], argv[1], argv[2]);
                        break;
                    }
                    case 4: {
                        binding = bootstrapMethod.invoke(caller, name, type, argv[0], argv[1], argv[2], argv[3]);
                        break;
                    }
                    case 5: {
                        binding = bootstrapMethod.invoke(caller, name, type, argv[0], argv[1], argv[2], argv[3], argv[4]);
                        break;
                    }
                    case 6: {
                        binding = bootstrapMethod.invoke(caller, name, type, argv[0], argv[1], argv[2], argv[3], argv[4], argv[5]);
                        break;
                    }
                    default: {
                        int NON_SPREAD_ARG_COUNT = 3;
                        if (3 + argv.length > 254) {
                            throw new BootstrapMethodError("too many bootstrap method arguments");
                        }
                        MethodType bsmType = bootstrapMethod.type();
                        MethodType invocationType = MethodType.genericMethodType(3 + argv.length);
                        MethodHandle typedBSM = bootstrapMethod.asType(invocationType);
                        MethodHandle spreader = invocationType.invokers().spreadInvoker(3);
                        binding = spreader.invokeExact(typedBSM, caller, name, type, argv);
                    }
                }
            }
            if (!(binding instanceof CallSite)) {
                throw new ClassCastException("bootstrap method failed to produce a CallSite");
            }
            site = (CallSite)binding;
            if (!site.getTarget().type().equals((Object)type)) {
                throw CallSite.wrongTargetType(site.getTarget(), type);
            }
        }
        catch (Throwable ex) {
            BootstrapMethodError bex = ex instanceof BootstrapMethodError ? (BootstrapMethodError)ex : new BootstrapMethodError("call site initialization exception", ex);
            throw bex;
        }
        return site;
    }

    private static Object maybeReBox(Object x) {
        int xi;
        if (x instanceof Integer && (xi = ((Integer)x).intValue()) == (byte)xi) {
            x = xi;
        }
        return x;
    }

    private static void maybeReBoxElements(Object[] xa) {
        for (int i = 0; i < xa.length; ++i) {
            xa[i] = CallSite.maybeReBox(xa[i]);
        }
    }

    static {
        MethodHandleImpl.initStatics();
        try {
            GET_TARGET = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(CallSite.class, "getTarget", MethodType.methodType(MethodHandle.class));
            THROW_UCS = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(CallSite.class, "uninitializedCallSite", MethodType.methodType(Object.class, Object[].class));
        }
        catch (ReflectiveOperationException e) {
            throw MethodHandleStatics.newInternalError(e);
        }
        try {
            TARGET_OFFSET = MethodHandleStatics.UNSAFE.objectFieldOffset(CallSite.class.getDeclaredField("target"));
            CONTEXT_OFFSET = MethodHandleStatics.UNSAFE.objectFieldOffset(CallSite.class.getDeclaredField("context"));
        }
        catch (Exception ex) {
            throw MethodHandleStatics.newInternalError(ex);
        }
    }
}

